<?php
/**
* ChronoForms 8
* Copyright (c) 2023 ChronoEngine.com, All rights reserved.
* Author: (ChronoEngine.com Team)
* license:     GNU General Public License version 2 or later; see LICENSE.txt
* Visit http://www.ChronoEngine.com for regular updates and information.
**/
defined('_JEXEC') or die('Restricted access');

if(empty($this->data("table"))){
	ChronoSession::setFlash("error", "Table name is missing");
	ChronoApp::$instance->Redirect(ChronoApp::$instance->extension_url."&action=ma.tables");
}

$model = new ChronoModel();
$model->Table = $this->data("table");

$tcolumns = ExtensionsModel::instance()->Select(sql: "SHOW FULL COLUMNS FROM ".$this->data("table"));
if (ChronoApp::$instance->isPost && isset($this->data["search"])) {
	$search = [];
	foreach($tcolumns as $tcolumn){
		if(strlen($this->data("operator_".$tcolumn["Field"])) > 0){
			$search[] = [$tcolumn["Field"], $this->data("operator_".$tcolumn["Field"]), $this->data($tcolumn["Field"])];
		}
	}
	if(!empty($search)){
		ChronoSession::set($this->data("table")."_search", $search);
		ChronoApp::$instance->Redirect(ChronoApp::$instance->extension_url."&action=ma.browse&table=".$this->data("table"));
	}else{
		ChronoSession::setFlash("warning", "You did not specify any search values.");
	}
}else{
	$conditions = ChronoSession::get($this->data("table")."_search", []);
	if(!empty($conditions)){
		foreach($conditions as $condition){
			$this->data[$condition[0]] = $condition[2];
			$this->data["operator_".$condition[0]] = $condition[1];
		}
	}
}
?>

<form class="nui form" action="<?php echo ChronoApp::$instance->current_url; ?>&action=ma.search&table=<?php echo $this->data("table"); ?>" method="post" enctype="multipart/form-data" accept-charset="UTF-8">
	<?php
	require(__DIR__."/ma.menubar.php");
	?>
	<?php foreach($tcolumns as $tcolumn): ?>
	<div class="equal fields">
		<?php new FormField(name: "operator_".$tcolumn["Field"], type:"select", label: $tcolumn["Field"]." - ".$tcolumn["Type"], options:[
			new Option(value:""),
			new Option(value:"=", text:"= ?"),
			new Option(value:"!=", text:"!= ?"),
			new Option(value:">", text:"> ?"),
			new Option(value:">=", text:">= ?"),
			new Option(value:"<", text:"< ?"),
			new Option(value:"<=", text:"<= ?"),
			new Option(value:"LIKE", text:"LIKE ?"),
			new Option(value:"NOT LIKE", text:"NOT LIKE ?"),
			new Option(value:"IN", text:"IN ?"),
			new Option(value:"NOT IN", text:"NOT IN ?"),
			new Option(value:"IS NULL", text:"IS NULL"),
			new Option(value:"IS NOT NULL", text:"IS NOT NULL"),
		]); ?>
		<?php new FormField(name: $tcolumn["Field"], label: "&nbsp;"); ?>
	</div>
	<?php endforeach; ?>
</form>