<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\Model;

use OSL\Model\AdminModel;

defined('_JEXEC') or die;

class Category extends AdminModel
{
	/**
	 * Give a chance for child class to pre-process the data
	 *
	 * @param   \OSSolution\HelpdeskPro\Admin\Table\Category  $row
	 * @param   \OSL\Input\Input                              $input
	 * @param   bool                                          $isNew
	 */
	protected function beforeStore($row, $input, $isNew)
	{
		// Default value
		$input->set('managers', '');

		$manageUserIds = $input->get('manage_user_ids', [], 'raw');

		if (is_array($manageUserIds) && count($manageUserIds))
		{
			$userIds = [];

			foreach ($manageUserIds as $manageUserId)
			{
				$userId = (int) $manageUserId['user_id'];

				if ($userId > 0)
				{
					$userIds[] = $userId;
				}
			}

			if (count($userIds))
			{
				$db    = $this->getDbo();
				$query = $db->getQuery(true)
					->select('username')
					->from('#__users')
					->whereIn('id', $userIds);
				$db->setQuery($query);
				$input->set('managers', implode(',', $db->loadColumn()));
			}
		}
	}

	/**
	 * Prepare and sanitise the table data prior to saving.
	 *
	 * @param   \OSSolution\HelpdeskPro\Admin\Table\Category  $row  A JTable object.
	 *
	 * @return void
	 */
	protected function prepareTable($row, $task)
	{
		$row->parent_id = (int) $row->parent_id;

		if ($row->parent_id > 0)
		{
			// Calculate level
			$db    = $this->getDbo();
			$query = $db->getQuery(true)
				->select($db->quoteName('level'))
				->from('#__helpdeskpro_categories')
				->where('id = ' . (int) $row->parent_id);
			$db->setQuery($query);
			$row->level = (int) $db->loadResult() + 1;
		}
		else
		{
			$row->level = 1;
		}

		parent::prepareTable($row, $task);
	}

	/**
	 * A protected method to get a set of ordering conditions.
	 *
	 * @param   \OSSolution\HelpdeskPro\Admin\Table\Category  $row  A JTable object.
	 *
	 * @return array An array of conditions to add to ordering queries.
	 */

	protected function getReorderConditions($row)
	{
		return ['`parent_id` = ' . (int) $row->parent_id];
	}
}