CREATE TABLE IF NOT EXISTS `#__helpdeskpro_articles` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int unsigned DEFAULT 0,
  `ticket_id` int unsigned DEFAULT 0,
  `title` varchar(225) NOT NULL,
  `text` text,
  `created_date` datetime DEFAULT NULL,
  `published` tinyint unsigned DEFAULT 0,
  `hits` int unsigned DEFAULT 0,
  `ordering` int unsigned DEFAULT 0,
  `alias` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;
CREATE TABLE IF NOT EXISTS `#__helpdeskpro_categories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int unsigned DEFAULT 0,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `access` int unsigned NOT NULL DEFAULT 0,
  `managers` varchar(255) DEFAULT NULL,
  `ordering` int unsigned DEFAULT 0,
  `published` tinyint unsigned DEFAULT 0,
  `level` tinyint unsigned NOT NULL DEFAULT 1,
  `category_type` int unsigned NOT NULL DEFAULT 0,
  `alias` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;
CREATE TABLE IF NOT EXISTS `#__helpdeskpro_configs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `config_key` varchar(255) DEFAULT NULL,
  `config_value` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `#__helpdeskpro_emails` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `email_key` varchar(255) DEFAULT NULL,
  `email_message` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `#__helpdeskpro_fields` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int DEFAULT 0,
  `name` varchar(50) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `field_type` tinyint unsigned DEFAULT 0,
  `is_filterable` tinyint unsigned DEFAULT 0,
  `required` tinyint unsigned DEFAULT 0,
  `prompt_text` varchar(255) DEFAULT '',
  `values` text,
  `default_values` text,
  `rows` tinyint unsigned DEFAULT 0,
  `cols` tinyint unsigned DEFAULT 0,
  `size` tinyint unsigned DEFAULT 0,
  `datatype_validation` tinyint unsigned DEFAULT 0,
  `receive_confirmation_email` tinyint unsigned DEFAULT 0,
  `css_class` varchar(100) DEFAULT NULL,
  `extra` varchar(255) DEFAULT NULL,
  `ordering` int unsigned DEFAULT 0,
  `published` tinyint unsigned DEFAULT 0,
  `multiple` tinyint unsigned NOT NULL DEFAULT 0,
  `validation_rules` varchar(255) DEFAULT NULL,
  `fieldtype` varchar(50) DEFAULT NULL,
  `is_searchable` tinyint unsigned NOT NULL DEFAULT 0,
  `show_in_list_view` tinyint unsigned NOT NULL DEFAULT 0,
  `is_filterable` tinyint unsigned NOT NULL DEFAULT 0,
  `depend_on_field_id` int NOT NULL DEFAULT 0,
  `depend_on_options` text,
  `access` int unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `#__helpdeskpro_field_categories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `field_id` int unsigned DEFAULT 0,
  `category_id` int unsigned DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `#__helpdeskpro_field_value` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ticket_id` int unsigned DEFAULT 0,
  `field_id` int unsigned DEFAULT 0,
  `field_value` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `#__helpdeskpro_labels` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `color_code` varchar(40) DEFAULT NULL,
  `published` tinyint unsigned DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `#__helpdeskpro_messages` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `ticket_id` int unsigned DEFAULT 0,
  `user_id` int unsigned DEFAULT 0,
  `internal` tinyint unsigned DEFAULT 0,
  `date_added` datetime DEFAULT NULL,
  `message` text,
  `attachments` text,
  `original_filenames` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;
CREATE TABLE IF NOT EXISTS `#__helpdeskpro_priorities` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `ordering` int unsigned DEFAULT 0,
  `published` tinyint unsigned DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `#__helpdeskpro_replies` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int unsigned DEFAULT 0,
  `title` varchar(225) NOT NULL,
  `message` text,
  `published` tinyint unsigned DEFAULT 0,
  `ordering` int unsigned DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;
CREATE TABLE IF NOT EXISTS `#__helpdeskpro_statuses` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `ordering` int unsigned DEFAULT 0,
  `published` tinyint unsigned DEFAULT 0,
  `bgcolor` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `#__helpdeskpro_tickets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int unsigned NOT NULL DEFAULT 0,
  `user_id` int unsigned DEFAULT 0,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `user_ip` varchar(255) DEFAULT NULL,
  `message` text,
  `attachments` text,
  `original_filenames` text,
  `ticket_code` varchar(15) DEFAULT NULL,
  `created_date` datetime DEFAULT NULL,
  `modified_date` datetime DEFAULT NULL,
  `priority_id` tinyint unsigned DEFAULT 0,
  `status_id` tinyint unsigned DEFAULT 0,
  `rating` tinyint unsigned NOT NULL DEFAULT 0,
  `label_id` int unsigned NOT NULL DEFAULT 0,
  `staff_id` int unsigned NOT NULL DEFAULT 0,
  `last_reyply_user_id` int unsigned NOT NULL DEFAULT 0,
  `language` varchar(10) DEFAULT '*',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;
CREATE TABLE IF NOT EXISTS `#__helpdeskpro_urls` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `md5_key` varchar(32) DEFAULT NULL,
  `query` text,
  `segment` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `#__helpdeskpro_emaillogs` (
	`id` int unsigned NOT NULL AUTO_INCREMENT,
	`email_type` varchar(50) NOT NULL DEFAULT '',
	`sent_at` datetime,
	`sent_to` tinyint NOT NULL DEFAULT 0,
	`email` varchar(100) DEFAULT 0,
	`subject` varchar(255) NOT NULL DEFAULT '',
	`body` text,
	PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;
