<?php

declare(strict_types=1);

namespace JchOptimize\Core;

final class Settings
{
    public const CACHE_RANDOM_KEY = 'cache_random_key';
    public const DEBUG = 'debug';
    public const DISABLE_LOGGED_IN_USERS = 'disable_logged_in_users';
    public const ELEMENTS_ABOVE_FOLD_HOME = 'elements_above_fold_home';
    public const ELEMENTS_ABOVE_FOLD = 'elements_above_fold';
    public const ELEMENTS_ABOVE_FOLD_PER_PAGE = 'elements_above_fold_per_page';
    public const ELEMENTS_ABOVE_FOLD_MARKER = 'elements_above_fold_marker';
    public const MENUEXCLUDEDURL = 'menuexcludedurl';
    public const MENUEXCLUDED = 'menuexcluded';
    public const CACHE_STORAGE_ADAPTER = 'pro_cache_storage_adapter';
    public const MEMCACHED_SERVER_HOST = 'memcached_server_host';
    public const MEMCACHED_SERVER_PORT = 'memcached_server_port';
    public const REDIS_SERVER_HOST = 'redis_server_host';
    public const REDIS_SERVER_PORT = 'redis_server_port';
    public const REDIS_SERVER_PASSWORD = 'redis_server_password';
    public const REDIS_SERVER_DATABASE = 'redis_server_database';
    public const CACHE_LIFETIME = 'cache_lifetime';
    public const DELETE_EXPIRY = 'delete_expiry';
    public const RECACHE_BASE_URL = 'recache_base_url';
    public const RECACHE_CRAWL_LIMIT = 'recache_crawl_limit';
    public const RECACHE_CONCURRENCY = 'recache_concurrency';
    public const RECACHE_MAX_DEPTH = 'recache_max_depth';
    public const COMBINE_FILES_ENABLE = 'combine_files_enable';
    public const COMBINE_FILES = 'combine_files';
    public const TRY_CATCH = 'try_catch';
    public const HTML_MINIFY_LEVEL = 'html_minify_level';
    public const HTACCESS = 'htaccess';
    public const GZIP = 'gzip';
    public const HTML_MINIFY = 'html_minify';
    public const INCLUDE_ALL_EXTENSIONS = 'includeAllExtensions';
    public const PHP_AND_EXTERNAL = 'phpAndExternal';
    public const CSS = 'css';
    public const CSS_MINIFY = 'css_minify';
    public const REPLACE_IMPORTS = 'replaceImports';
    public const INLINE_STYLE = 'inlineStyle';
    public const EXCLUDE_CSS = 'excludeCss';
    public const EXCLUDE_CSS_COMPONENTS = 'excludeCssComponents';
    public const EXCLUDE_STYLES = 'excludeStyles';
    public const EXCLUDE_ALL_STYLES = 'excludeAllStyles';
    public const REMOVE_CSS = 'remove_css';
    public const OPTIMIZE_CSS_DELIVERY_ENABLE = 'optimizeCssDelivery_enable';
    public const REDUCE_UNUSED_CSS = 'pro_reduce_unused_css';
    public const DYNAMIC_SELECTORS = 'pro_dynamic_selectors';
    public const CRITICAL_CSS_CONFIGURE_HELPER = 'critical_css_configure_helper';
    public const CUSTOM_CSS_ENABLE = 'custom_css_enable';
    public const CUSTOM_CSS = 'custom_css';
    public const MOBILE_CSS = 'mobile_css';
    public const DESKTOP_CSS = 'desktop_css';
    public const JAVASCRIPT = 'javascript';
    public const JS_MINIFY = 'js_minify';
    public const INLINE_SCRIPTS = 'inlineScripts';
    public const BOTTOM_JS = 'bottom_js';
    public const LOAD_ASYNCHRONOUS = 'loadAsynchronous';
    public const EXCLUDE_JS_PEO = 'excludeJs_peo';
    public const EXCLUDE_JS_COMPONENTS_PEO = 'excludeJsComponents_peo';
    public const EXCLUDE_SCRIPTS_PEO = 'excludeScripts_peo';
    public const EXCLUDE_ALL_SCRIPTS = 'excludeAllScripts';
    public const REMOVE_JS = 'remove_js';
    public const REDUCE_UNUSED_JS_ENABLE = 'pro_reduce_unused_js_enable';
    public const CRITICAL_JS = 'pro_criticalJs';
    public const CRITICAL_SCRIPTS = 'pro_criticalScripts';
    public const CRITICAL_MODULES = 'pro_criticalModules';
    public const CRITICAL_MODULES_SCRIPTS = 'pro_criticalModulesScripts';
    public const PRELOAD_CRITICAL_JS = 'preload_criticalJs';
    public const CRITICAL_JS_CONFIGURE_HELPER = 'critical_js_configure_helper';
    public const PAGE_CACHE_LIFETIME = 'page_cache_lifetime';
    public const CACHE_PLATFORM = 'pro_cache_platform';
    public const PAGE_CACHE_EXCLUDE_FORM_USERS = 'page_cache_exclude_form_users';
    public const CACHE_EXCLUDE = 'cache_exclude';
    public const CACHE_EXCLUDE_MENU = 'cache_exclude_menu';
    public const CACHE_EXCLUDE_COMPONENT = 'cache_exclude_component';
    public const PAGE_CACHE_IGNORE_QUERY_VALUES = 'page_cache_ignore_query_values';
    public const CAPTURE_CACHE_ENABLE = 'pro_capture_cache_enable';
    public const CF_ENABLE = 'cf_enable';
    public const CF_API_TOKEN = 'cf_api_token';
    public const CF_ZONE_ID = 'cf_zone_id';
    public const PAGE_CACHE_INTEGRATION = 'pro_page_cache_integration';
    public const PAGE_CACHE_INTEGRATION_ENABLE = 'pro_page_cache_integration_enable';
    public const IMG_ATTRIBUTES_ENABLE = 'img_attributes_enable';
    public const CSG_ENABLE = 'csg_enable';
    public const CSG_DIRECTION = 'csg_direction';
    public const CSG_WRAP_IMAGES = 'csg_wrap_images';
    public const CSG_EXCLUDE_IMAGES = 'csg_exclude_images';
    public const CSG_INCLUDE_IMAGES = 'csg_include_images';
    public const LAZYLOAD_ENABLE = 'lazyload_enable';
    public const LAZYLOAD_IFRAME = 'pro_lazyload_iframe';
    public const USE_YOUTUBE_FACADE = 'use_youtube_facade';
    public const LAZYLOAD_AUDIOVIDEO = 'pro_lazyload_audiovideo';
    public const LAZYLOAD_BGIMAGES = 'pro_lazyload_bgimages';
    public const EXCLUDE_LAZY_LOAD = 'excludeLazyLoad';
    public const EXCLUDE_LAZY_LOAD_FOLDERS = 'pro_excludeLazyLoadFolders';
    public const EXCLUDE_LAZY_LOAD_CLASS = 'pro_excludeLazyLoadClass';
    public const INCLUDE_LAZY_LOAD = 'includeLazyLoad';
    public const INCLUDE_LAZY_LOAD_FOLDERS = 'includeLazyLoadFolders';
    public const INCLUDE_LAZY_LOAD_CLASS = 'includeLazyLoadClass';
    public const HTTP2_PUSH_ENABLE = 'http2_push_enable';
    public const HTTP2_FILE_TYPES = 'pro_http2_file_types';
    public const HTTP2_PRELOAD_MODULES = 'pro_http2_preload_modules';
    public const HTTP2_INCLUDE = 'pro_http2_include';
    public const HTTP2_EXCLUDE = 'pro_http2_exclude';
    public const LCP_IMAGES_ENABLE = 'pro_lcp_images_enable';
    public const LCP_IMAGES = 'pro_lcp_images';
    public const LCP_IDENTIFIERS = 'pro_lcp_identifiers';
    public const LCP_IMAGES_MOBILE = 'lcp_images_mobile';
    public const LCP_IMAGES_DESKTOP = 'lcp_images_desktop';
    public const OPTIMIZE_FONTS_ENABLE = 'pro_optimizeFonts_enable';
    public const FORCE_SWAP_POLICY = 'pro_force_swap_policy';
    public const OPTIMIZE_FONT_FILES = 'pro_optimize_font_files';
    public const PRECONNECT_DOMAINS_ENABLE = 'pro_preconnect_domains_enable';
    public const PRECONNECT_DOMAINS = 'pro_preconnect_domains';
    public const DNS_PREFETCH_DOMAINS = 'dns_prefetch_domains';
    public const COOKIELESSDOMAIN_ENABLE = 'cookielessdomain_enable';
    public const CDN_SCHEME = 'cdn_scheme';
    public const COOKIELESSDOMAIN = 'cookielessdomain';
    public const STATICFILES = 'staticfiles';
    public const CUSTOMCDNEXTENSIONS = 'pro_customcdnextensions';
    public const COOKIELESSDOMAIN_2 = 'pro_cookielessdomain_2';
    public const STATICFILES_2 = 'pro_staticfiles_2';
    public const COOKIELESSDOMAIN_3 = 'pro_cookielessdomain_3';
    public const STATICFILES_3 = 'pro_staticfiles_3';
    public const IGNORE_OPTIMIZED = 'ignore_optimized';
    public const NEXT_GEN_IMAGES = 'pro_next_gen_images';
    public const GEN_AVIF_IMAGES = 'gen_avif_images';
    public const LOAD_AVIF_WEBP_IMAGES = 'load_avif_webp_images';
    public const LOAD_WEBP_IMAGES = 'pro_load_webp_images';
    public const LOAD_AVIF_IMAGES = 'load_avif_images';
    public const UNSUPPORTED_BROWSERS_POLICY = 'unsupported_browsers_policy';
    public const GEN_RESPONSIVE_IMAGES = 'pro_gen_responsive_images';
    public const LOAD_RESPONSIVE_IMAGES = 'pro_load_responsive_images';
    public const REPLACE_SRCSET_RESPONSIVE = 'replace_srcset_responsive';
    public const CROPGRAVITY = 'cropgravity';
    public const LOSSY = 'lossy';
    public const SAVE_METADATA = 'save_metadata';
    public const QUALITY = 'quality';
    public const API_CONCURRENCY = 'pro_api_concurrency';
    public const API_NUM_FILES = 'pro_api_num_files';
    public const API_MAX_SIZE = 'pro_api_max_size';
    public const API_CONNECTION_TIMEOUT = 'api_connection_timeout';
    public const API_BASE_URL = 'pro_api_base_url';
    public const API_CRAWL_LIMIT = 'pro_api_crawl_limit';
    public const API_RESIZE_MODE = 'pro_api_resize_mode';
    public const RECURSIVE = 'recursive';
    public const REDUCE_DOM = 'pro_reduce_dom';
    public const HTML_SECTIONS = 'pro_html_sections';
    public const REDUCE_DOM_IDENTIFIERS = 'reduce_dom_identifiers';
    public const REDUCE_DOM_EXCLUDE_IDENTIFIERS = 'reduce_dom_exclude_identifiers';
    public const REDUCE_DOM_ABOVE_FOLD_IDENTIFIERS = 'reduce_dom_above_fold_identifiers';

    public const DEFAULTS = [
        self::CACHE_RANDOM_KEY => '',
        self::DEBUG => '0',
        self::DISABLE_LOGGED_IN_USERS => '1',
        self::ELEMENTS_ABOVE_FOLD_HOME => '300',
        self::ELEMENTS_ABOVE_FOLD => '300',
        self::ELEMENTS_ABOVE_FOLD_PER_PAGE => [],
        self::ELEMENTS_ABOVE_FOLD_MARKER => '0',
        self::MENUEXCLUDEDURL => [],
        self::MENUEXCLUDED => [],
        self::CACHE_STORAGE_ADAPTER => 'filesystem',
        self::MEMCACHED_SERVER_HOST => '127.0.0.1',
        self::MEMCACHED_SERVER_PORT => '11211',
        self::REDIS_SERVER_HOST => '127.0.0.1',
        self::REDIS_SERVER_PORT => '6379',
        self::REDIS_SERVER_PASSWORD => '',
        self::REDIS_SERVER_DATABASE => '0',
        self::CACHE_LIFETIME => '900',
        self::DELETE_EXPIRY => '1',
        self::RECACHE_BASE_URL => '',
        self::RECACHE_CRAWL_LIMIT => '100',
        self::RECACHE_CONCURRENCY => '10',
        self::RECACHE_MAX_DEPTH => '3',
        self::COMBINE_FILES_ENABLE => '1',
        self::COMBINE_FILES => '0',
        self::TRY_CATCH => '1',
        self::HTML_MINIFY_LEVEL => '0',
        self::HTACCESS => '2',
        self::GZIP => '0',
        self::HTML_MINIFY => '0',
        self::INCLUDE_ALL_EXTENSIONS => '0',
        self::PHP_AND_EXTERNAL => '0',
        self::CSS => '1',
        self::CSS_MINIFY => '0',
        self::REPLACE_IMPORTS => '0',
        self::INLINE_STYLE => '0',
        self::EXCLUDE_CSS => [],
        self::EXCLUDE_CSS_COMPONENTS => [],
        self::EXCLUDE_STYLES => [],
        self::EXCLUDE_ALL_STYLES => '0',
        self::REMOVE_CSS => [],
        self::OPTIMIZE_CSS_DELIVERY_ENABLE => '0',
        self::REDUCE_UNUSED_CSS => '0',
        self::DYNAMIC_SELECTORS => [],
        self::CRITICAL_CSS_CONFIGURE_HELPER => '0',
        self::CUSTOM_CSS_ENABLE => '0',
        self::CUSTOM_CSS => '',
        self::MOBILE_CSS => '',
        self::DESKTOP_CSS => '',
        self::JAVASCRIPT => '1',
        self::JS_MINIFY => '0',
        self::INLINE_SCRIPTS => '0',
        self::BOTTOM_JS => '0',
        self::LOAD_ASYNCHRONOUS => '0',
        self::EXCLUDE_JS_PEO => [],
        self::EXCLUDE_JS_COMPONENTS_PEO => [],
        self::EXCLUDE_SCRIPTS_PEO => [],
        self::EXCLUDE_ALL_SCRIPTS => '0',
        self::REMOVE_JS => [],
        self::REDUCE_UNUSED_JS_ENABLE => '0',
        self::CRITICAL_JS => [],
        self::CRITICAL_SCRIPTS => [],
        self::CRITICAL_MODULES => [],
        self::CRITICAL_MODULES_SCRIPTS => [],
        self::PRELOAD_CRITICAL_JS => '0',
        self::CRITICAL_JS_CONFIGURE_HELPER => '',
        self::PAGE_CACHE_LIFETIME => '900',
        self::CACHE_PLATFORM => '0',
        self::PAGE_CACHE_EXCLUDE_FORM_USERS => '1',
        self::CACHE_EXCLUDE => [],
        self::CACHE_EXCLUDE_MENU => [],
        self::CACHE_EXCLUDE_COMPONENT => [
            0 => 'com_ajax',
        ],
        self::PAGE_CACHE_IGNORE_QUERY_VALUES => [],
        self::CAPTURE_CACHE_ENABLE => '0',
        self::CF_ENABLE => '0',
        self::CF_API_TOKEN => '',
        self::CF_ZONE_ID => '',
        self::PAGE_CACHE_INTEGRATION => 'jchpagecache',
        self::PAGE_CACHE_INTEGRATION_ENABLE => '1',
        self::IMG_ATTRIBUTES_ENABLE => '0',
        self::CSG_ENABLE => '0',
        self::CSG_DIRECTION => 'vertical',
        self::CSG_WRAP_IMAGES => '0',
        self::CSG_EXCLUDE_IMAGES => [],
        self::CSG_INCLUDE_IMAGES => [],
        self::LAZYLOAD_ENABLE => '0',
        self::LAZYLOAD_IFRAME => '0',
        self::USE_YOUTUBE_FACADE => '0',
        self::LAZYLOAD_AUDIOVIDEO => '0',
        self::LAZYLOAD_BGIMAGES => '0',
        self::EXCLUDE_LAZY_LOAD => [],
        self::EXCLUDE_LAZY_LOAD_FOLDERS => [],
        self::EXCLUDE_LAZY_LOAD_CLASS => [],
        self::INCLUDE_LAZY_LOAD => [],
        self::INCLUDE_LAZY_LOAD_FOLDERS => [],
        self::INCLUDE_LAZY_LOAD_CLASS => [],
        self::HTTP2_PUSH_ENABLE => '0',
        self::HTTP2_FILE_TYPES => [
            0 => 'style',
            1 => 'script',
            2 => 'font',
            3 => 'image',
        ],
        self::HTTP2_PRELOAD_MODULES => '1',
        self::HTTP2_INCLUDE => [],
        self::HTTP2_EXCLUDE => [],
        self::LCP_IMAGES_ENABLE => '0',
        self::LCP_IMAGES => [],
        self::LCP_IDENTIFIERS => [],
        self::LCP_IMAGES_MOBILE => [],
        self::LCP_IMAGES_DESKTOP => [],
        self::OPTIMIZE_FONTS_ENABLE => '0',
        self::FORCE_SWAP_POLICY => '1',
        self::OPTIMIZE_FONT_FILES => [],
        self::PRECONNECT_DOMAINS_ENABLE => '0',
        self::PRECONNECT_DOMAINS => [],
        self::DNS_PREFETCH_DOMAINS => [],
        self::COOKIELESSDOMAIN_ENABLE => '0',
        self::CDN_SCHEME => '0',
        self::COOKIELESSDOMAIN => '',
        self::STATICFILES => [
            0 => 'css',
            1 => 'js',
            2 => 'jpe?g',
            3 => 'gif',
            4 => 'png',
            5 => 'ico',
            6 => 'bmp',
            7 => 'pdf',
            8 => 'webp',
            9 => 'svg',
        ],
        self::CUSTOMCDNEXTENSIONS => [],
        self::COOKIELESSDOMAIN_2 => '',
        self::STATICFILES_2 => [
            0 => 'css',
            1 => 'js',
            2 => 'jpe?g',
            3 => 'gif',
            4 => 'png',
            5 => 'ico',
            6 => 'bmp',
            7 => 'pdf',
            8 => 'webp',
            9 => 'svg',
        ],
        self::COOKIELESSDOMAIN_3 => '',
        self::STATICFILES_3 => [
            0 => 'css',
            1 => 'js',
            2 => 'jpe?g',
            3 => 'gif',
            4 => 'png',
            5 => 'ico',
            6 => 'bmp',
            7 => 'pdf',
            8 => 'webp',
            9 => 'svg',
        ],
        self::IGNORE_OPTIMIZED => '1',
        self::NEXT_GEN_IMAGES => '1',
        self::GEN_AVIF_IMAGES => '1',
        self::LOAD_AVIF_WEBP_IMAGES => '0',
        self::LOAD_WEBP_IMAGES => '1',
        self::LOAD_AVIF_IMAGES => '1',
        self::UNSUPPORTED_BROWSERS_POLICY => '0',
        self::GEN_RESPONSIVE_IMAGES => '1',
        self::LOAD_RESPONSIVE_IMAGES => '0',
        self::REPLACE_SRCSET_RESPONSIVE => '0',
        self::CROPGRAVITY => [],
        self::LOSSY => '1',
        self::SAVE_METADATA => '0',
        self::QUALITY => '85',
        self::API_CONCURRENCY => '5',
        self::API_NUM_FILES => '',
        self::API_MAX_SIZE => '2M',
        self::API_CONNECTION_TIMEOUT => '30',
        self::API_BASE_URL => '',
        self::API_CRAWL_LIMIT => '15',
        self::API_RESIZE_MODE => 'manual',
        self::RECURSIVE => '1',
        self::REDUCE_DOM => '0',
        self::HTML_SECTIONS => [
            0 => 'header',
            1 => 'nav',
            2 => 'main',
            3 => 'article',
            4 => 'section',
            5 => 'aside',
            6 => 'footer',
        ],
        self::REDUCE_DOM_IDENTIFIERS => [],
        self::REDUCE_DOM_EXCLUDE_IDENTIFIERS => [],
        self::REDUCE_DOM_ABOVE_FOLD_IDENTIFIERS => [],
    ];
}
