<?php
/*------------------------------------------------------------------------
# fields.html.php - Ossolution Services Booking
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/
// no direct access
defined('_JEXEC') or die;
class HTML_OSappscheduleFields{
	/**
	 * Enter description here...
	 *
	 * @param unknown_type $option
	 * @param unknown_type $rows
	 * @param unknown_type $pageNav
	 * @param unknown_type $lists
	 */
	static function listFields($option,$rows,$pageNav,$lists){
		global $app;
		$app = JFactory::getApplication();
		JToolBarHelper::title(JText::_('OSC_CUSTOM_FIELD_MANAGEMENT'));
		JToolBarHelper::addNew('fields_add');
		JToolBarHelper::editList('fields_edit');
		JToolBarHelper::deleteList(JText::_('OS_ARE_YOU_SURE_TO_REMOVE_ITEMS'),'fields_remove');
		JToolBarHelper::publish('fields_publish');
		JToolBarHelper::unpublish('fields_unpublish');
		JToolbarHelper::cancel('season_gotoindex');
		JToolbarHelper::custom('cpanel_list','featured.png', 'featured.png',JText::_('OS_DASHBOARD'),false);
		$ordering = ($lists['order'] == 'ordering');
		$disabled = 'disabled="disabled"';
		if ($ordering) $disabled = '';
		?>
		<form method="POST" action="index.php" name="adminForm" id="adminForm">
			<table width="100%" class="adminlist table table-striped">
				<thead>
					<tr>
						<th width="5%" style="text-align:center;">#</th>
						<th width="5%" style="text-align:center;">
							<input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
						</th>
						<th width="25%">
							<?php echo JHTML::_('grid.sort',   JText::_('OSC_CUSTOM_FIELD'), 'field_label', @$lists['order_Dir'], @$lists['order'],'fields_list' ); ?>
						</th>
						<th width="15%">
							<?php echo JText::_('OSC_PRICE_FOR_ORDER'); ?>
						</th>
						<th width="20%">
							<?php echo JHTML::_('grid.sort',   JText::_('OSC_FIELD_TYPE'), 'field_type', @$lists['order_Dir'], @$lists['order'],'fields_list' ); ?>
						</th>
						<th width="10%">
							<?php echo JText::_('OS_FREE'); ?>
						</th>
						<th width="15%" style="text-align:center;">
							<?php echo JHTML::_('grid.sort',   JText::_('OSC_ORDERING'), 'ordering', @$lists['order_Dir'], @$lists['order'],'fields_list' ); ?>
							<?php if($ordering) echo JHTML::_('grid.order',  $rows ,"filesave.png","fields_saveorder"); ?>
						</th>
						<th width="5%"  style="text-align:center;">
							<?php echo JHTML::_('grid.sort',   JText::_('OS_STATUS'), 'published', @$lists['order_Dir'], @$lists['order'] ); ?>
						</th>
					</tr>
				</thead>
				<tfoot>
					<tr>
						<td width="100%" colspan="8" style="text-align:center;">
							<?php
								echo $pageNav->getListFooter();
							?>
						</td>
					</tr>
				</tfoot>
				<tbody>
				<?php
				$k = 0;
				for ($i=0, $n=count($rows); $i < $n; $i++) {
					$row = $rows[$i];
					$checked = JHtml::_('grid.id', $i, $row->id);
					$link 		= JRoute::_( 'index.php?option='.$option.'&task=fields_edit&cid[]='. $row->id );
					$published 	= JHTML::_('jgrid.published', $row->published, $i , 'fields_');

					?>
					<tr class="<?php echo "row$k"; ?>">
						<td align="center" style="text-align:center;"><?php echo $pageNav->getRowOffset( $i ); ?></td>
						<td align="center" style="text-align:center;"><?php echo $checked; ?></td>
						<td align="left"><a href="<?php echo $link; ?>"><?php echo $row->field_label; ?></a></td>
						<td align="center"><?php
						$fieldType = array(0,1);
						if(($row->field_free == 1) or (in_array($row->field_type,$fieldType))){
							echo "N/A";
						}else{
							if($row->price_for_order == 0){
								echo JText::_('OSC_FOR_ORDER');
							}elseif($row->price_for_order == 1){
								echo JText::_('OSC_FOR_EACH_ROOM_OF_ORDER');
							}
						}
						?></td>
						<td align="center"><?php echo $lists[$row->field_type]?></td>
						<td align="center">
							<?php 
							if($row->field_free == 0){
								echo JText::_('OS_NO');
							}else{
								echo JText::_('OS_YES');
							}
							?>
						</td>
						<td align="center" class="order" style="text-align:right !important;">
				 			<?php echo $pageNav->orderUpIcon($i,$ordering, 'fields_orderup', 'JLIB_HTML_MOVE_UP', 'ordering'); ?>
							<?php echo $pageNav->orderDownIcon($i, $n,  $ordering, 'fields_orderdown', 'JLIB_HTML_MOVE_DOWN', 'ordering'); ?>
							<input <?php echo $disabled;?> type="text" name="order[]" size="5" value="<?php echo $row->ordering; ?>" class="input-mini" style="text-align: center;width:20px;" />
						</td>
						<td align="center" style="text-align:center;"><?php echo $published?></td>
					</tr>
				<?php
					$k = 1 - $k;	
				}
				?>
				</tbody>
			</table>
			<input type="hidden" name="option" value="<?php echo $option?>">
			<input type="hidden" name="task" value="fields" />
			<input type="hidden" name="boxchecked" value="0" />
			<input type="hidden" name="filter_order" value="<?php echo $lists['order'];?>" />
			<input type="hidden" name="filter_order_Dir" value="<?php echo $lists['order_Dir'];?>" />
		</form>
		<?php
	}
	
	
	/**
	 * Edit field
	 *
	 * @param unknown_type $option
	 * @param unknown_type $row
	 * @param unknown_type $lists
	 */
	static function field_edit($option,$row,$lists,$translatable){
		global $mainframe, $_jversion,$configClass,$languages;
		$version 	= new JVersion();
		$_jversion	= $version->RELEASE;		
		$mainframe 	= JFactory::getApplication();
		$mainframe->input->set( 'hidemainmenu', 1 );
		if ($row->id > 0){
			$title = ' ['.JText::_('OS_EDIT').']';
		}else{
			$title = ' ['.JText::_('OS_NEW').']';
		}
		JToolBarHelper::title(JText::_('Custom field').$title);
		JToolBarHelper::save('fields_save');
		JToolBarHelper::apply('fields_apply');
		JToolBarHelper::cancel('fields_cancel');
		?>
		<form method="POST" action="index.php" name="adminForm" id="adminForm" enctype="multipart/form-data">
		<?php 
		if ($translatable)
		{
		?>
			<ul class="nav nav-tabs">
				<li class="active"><a href="#general-page" data-toggle="tab"><?php echo JText::_('OS_GENERAL'); ?></a></li>
				<li><a href="#translation-page" data-toggle="tab"><?php echo JText::_('OS_TRANSLATION'); ?></a></li>									
			</ul>		
			<div class="tab-content">
				<div class="tab-pane active" id="general-page">			
		<?php	
		}
		?>
			<table width="100%" class="admintable adminform">
				<tr>
					<td class="key"><?php echo JText::_('OS_FIELD_LABEL'); ?></td>
					<td >
						<input type="text" name="field_label" id="field_label" size="40" value="<?php echo $row->field_label?>" class=" form-control input-large" ><i class="icon-featured"></i>
					</td>
				</tr>
				<tr>
					<td class="key"><?php echo JText::_('OS_FIELD_TYPE'); ?></td>
					<td >
						<?php echo $lists['field_type'];?>
					</td>
				</tr>
				<tr>
					<td class="key"><?php echo JText::_('OSC_PRICE_FOR_ORDER'); ?></td>
					<td >
						<?php echo $lists['price_for_order'];?>
					</td>
				</tr>
				<tr>
					<td class="key"><?php echo JText::_('OS_ORDERING'); ?></td>
					<td><?php echo $row->ordering?></td>
				</tr>
				<tr>
					<td class="key"><?php echo JText::_('OS_PUBLISHED'); ?></td>
					<td ><div class="controls"><?php echo $lists['state'];?></div></td>
				</tr>
				<tr class="select_option" <?php echo $row->field_type<2? 'style="display:none"':'';?>>
					<td class="key"><?php echo JText::_('OS_FILED_FREE'); ?></td>
					<td ><input type="checkbox" class="checkfieldfree" name="field_free"></td>
				</tr>
			</table>
		<?php 
		if ($translatable)
		{
		?>
		</div>
			<div class="tab-pane" id="translation-page">
				<ul class="nav nav-tabs">
					<?php
						$i = 0;
						foreach ($languages as $language) {						
							?>
							<li <?php echo $i == 0 ? 'class="active"' : ''; ?>>
								<a href="#translation-page-<?php echo $language->sef; ?>" data-toggle="tab"><?php echo $language->title; ?>
								&nbsp;<?php echo JHtml::_('image', 'mod_languages/'.$language->sef.'.gif', $language->sef, array('title' => $language->sef), true); ?>
								</a>
							</li>
							<?php
							$i++;	
						}
					?>			
				</ul>		
				<div class="tab-content">			
					<?php	
						$i = 0;
						foreach ($languages as $language){												
						?>
							<div class="tab-pane<?php echo $i == 0 ? ' active' : ''; ?>" id="translation-page-<?php echo $language->sef; ?>">													
								<table width="100%" class="admintable" style="background-color:white;">
									<tr>
										<td class="key"><?php echo JText::_('OS_FIELD_LABEL'); ?></td>
										<td ><input type="text" name="field_label_<?php echo $language->sef; ?>" id="field_label_<?php echo $language->sef; ?>" size="40" value="<?php echo $row->{'field_label_'.$language->sef}?>">&nbsp;<?php echo JHtml::_('image', 'mod_languages/'.$language->sef.'.gif', $language->sef, array('title' => $language->sef), true); ?></td>
									</tr>
								</table>
							</div>										
						<?php				
							$i++;		
						}
					?>
				</div>	
		</div>
		<?php				
		}
		?>
			<div id="select_option" class="select_option" <?php echo $row->field_type<2? 'style="display:none"':'';?>>
				<div class="row-fluid">
					<div style="margin-top:5px;" class="span12 label label-important">
						<h2><?php echo JText::_('OSC_FIELD_CREAT_OPTION')?></h2>
					</div>
					<div style="float: right;padding: 5px;">
						<input type="button" value="<?php echo JText::_('OSC_ADD_OPTION');?>" class="btn btn-warning">
					</div>
				</div>
				<table width="100%" class="adminlist table table-striped">
					<thead>
						<tr>
							<th width="5%" align="center">
								#
							</th>
							<th align="center">
								<?php echo JText::_('OS_FIELD_OPTION')?>
							</th>
							<th width="10%" align="center" style="text-align: center;">
								<?php echo JText::_('OS_OPTION_FREE')?>
							</th>
							<th width="35%" align="center" style="text-align: center;">
								<?php echo JText::_('OS_ADDITIONAL_PRICE')?>
							</th>
							<th width="5%" align="center">
								<?php echo JText::_('OS_REMOVE')?>
							</th>
						</tr>
					</thead>
					<tbody id="body_option">
						<?php 
						$fields = $lists['field_option'];
						if(count($fields) > 0){
							for($i=0;$i<count($fields);$i++){
								$field = $fields[$i];
								$k = 1-(int)$k;
								$uniqid = uniqid();
							?>
								<tr class="rows<?php echo $k?>" id="<?php echo $uniqid;?>">
									<td style="text-align:center;">
										<?php echo $i+1;?>
									</td>
									<td>
										<input type="text" class="input-large" name="fieldoption[<?php echo $i?>][field_option]" id="field_<?php echo $uniqid;?>" value="<?php echo $field->field_option?>">
										<i class="icon-featured"></i>
										<?php 
										foreach ($languages as $language){												
										?>
										<br />
										<input type="text" class="input-large" name="fieldoption[<?php echo $i?>][field_option_<?php echo $language->sef?>]" id="field_<?php echo $language->sef?>_<?php echo $uniqid;?>" value="<?php echo $field->{'field_option_'.$language->sef}?>">
										&nbsp;<?php echo JHtml::_('image', 'mod_languages/'.$language->sef.'.gif', $language->sef, array('title' => $language->sef), true); ?>
										<?php 
										}
										?>
									</td>
									<td align="center" style="text-align: center;vertical-align: middle;">
										<input  type="checkbox" class="checkoptionfree" name="optionfree_<?php echo $uniqid;?>" >
										<input type="hidden" name="fieldoption[<?php echo $i?>][option_free]" id="optionvalue_<?php echo $uniqid;?>" value="<?php echo $field->option_free?>">
									</td>
									<td align="center" style="text-align: center;vertical-align: middle;">
										<input  id="optionprice_<?php echo $uniqid;?>" type="text" class="input-mini" name="fieldoption[<?php echo $i?>][additional_price]" value="<?php echo $field->additional_price?>" size="5"> <?php echo $configClass['currency_format'];?>
									</td>
									<td style="vertical-align: middle;">
										<img class="removeoption" src="<?php echo JURI::base()?>templates/hathor/images/menu/icon-16-delete.png">
									</td>
								</tr>
							<?php 
							}
						}else{
							?>
							<div style="text-align:center;padding:10px;color:red;">
								<strong>
									<?php echo JText::_('OS_NO_OPTION_FOUND');?>
								</strong>
							</div>
							<?php
						}
						?>
					</tbody>
				</table>
			</div>
			<input type="hidden" name="option" value="<?php echo $option?>" /> 
			<input type="hidden" name="task" value="" />
			<input type="hidden" name="id" value="<?php echo $row->id?>" />
			<input type="hidden" name="boxchecked" value="0" />
			<input type="hidden" name="live_site" id="live_site" value="<?php echo JURI::base()?>" />
			<input type="hidden" name="currency_format" id="currency_format" value="<?php echo $configClass['currency_format'];?>" />
		</form>
			<script type="text/javascript">
				Joomla.submitbutton = function(pressbutton){
					if(pressbutton != "fields_cancel" && document.adminForm.field_label.value == ''){
						alert('<?php echo JText::_('OS_FIELD').' '.JText::_('OS_IS_REQUIRE'); ?>');
						field_label.focus();
						return false;
					}
					//submitform(pressbutton);
					Joomla.submitform(pressbutton);
				}
			</script>
		<?php
	}
}
?>