<?php
/**
 * @package   OSDownloads-Pro
 * @contact   www.joomlashack.com, help@joomlashack.com
 * @copyright 2005-2025 Joomlashack.com. All rights reserved
 * @license   https://www.gnu.org/licenses/gpl.html GNU/GPL
 *
 * This file is part of OSDownloads-Pro.
 *
 * OSDownloads-Pro is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * OSDownloads-Pro is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSDownloads-Pro.  If not, see <https://www.gnu.org/licenses/>.
 */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

// phpcs:disable PSR1.Files.SideEffects
defined('_JEXEC') or die();

require_once __DIR__ . '/AbstractFormFieldMailChimp.php';

// phpcs:enable PSR1.Files.SideEffects
// phpcs:disable PSR1.Classes.ClassDeclaration.MissingNamespace

class OsdownloadsFormFieldMailchimpgroup extends AbstractFormFieldMailChimp
{
    /**
     * @inheritdoc
     */
    protected $type = 'osdownloads.mailchimpgroup';

    /**
     * @inheritDoc
     */
    protected function getMailchimpOptions(): array
    {
        if ($this->mailchimpOptions === null) {
            $this->mailchimpOptions = [];

            $listId = $this->getListId();
            if ($listId == false) {
                $this->setError(
                    Text::_('COM_OSDOWNLOADS_ML_MAILCHIMP_GROUPS_SELECT_LIST'),
                    Text::_('COM_OSDOWNLOADS_ML_MAILCHIMP_GROUPS_SELECT_LIST_TOOLTIP')
                );

            } else {
                try {
                    $groups = $this->getMailchimpGroups($listId);
                    if ($groups) {
                        foreach ($groups as $group) {
                            $this->mailchimpOptions[] = HTMLHelper::_(
                                'select.option',
                                $group->id,
                                sprintf('%s/%s', $group->category, $group->interest)
                            );
                        }

                    } else {
                        $this->setError(Text::_('COM_OSDOWNLOADS_ML_MAILCHIMP_NO_GROUPS'));
                    }

                } catch (Throwable $error) {
                    $this->setError($error);
                }
            }
        }

        return $this->mailchimpOptions;
    }

    /**
     * @return ?string
     */
    protected function getListId(): ?string
    {
        $listFieldName  = (string)$this->element['list_id'] ?: 'list_id';
        $fieldNameAtoms = explode('.', $listFieldName);

        $fieldName  = array_shift($fieldNameAtoms);
        $fieldGroup = join('.', $fieldNameAtoms) ?: $this->group;

        $listField = $this->form->getField($fieldName, $fieldGroup);

        return $listField->value ?? null;
    }
}
