<?php
/**
 * @package   OSDownloads-Pro
 * @contact   www.joomlashack.com, help@joomlashack.com
 * @copyright 2005-2025 Joomlashack.com. All rights reserved
 * @license   https://www.gnu.org/licenses/gpl.html GNU/GPL
 *
 * This file is part of OSDownloads-Pro.
 *
 * OSDownloads-Pro is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * OSDownloads-Pro is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSDownloads-Pro.  If not, see <https://www.gnu.org/licenses/>.
 */

namespace Alledia\OSDownloads\Pro\Helper;

// phpcs:disable PSR1.Files.SideEffects
defined('_JEXEC') or die();
// phpcs:enable PSR1.Files.SideEffects

/**
 * Class Mailchimp
 *
 * @package Alledia\OSDownloads\Pro\Helper
 * @TODO    : Refactor this into the plugin code
 */
abstract class Mailchimp
{
    /**
     * List of legacy categories and new ids
     *
     * @var array
     */
    protected static $legacyCategoryList = [];

    /**
     * Convert legacy values to the new format, using the group id
     *
     * @param array                $value
     * @param string               $listId
     * @param \Mailchimp\Mailchimp $mc
     *
     * @return array
     */
    public static function convertLegacyGroupValue(
        array $value,
        string $listId,
        \Mailchimp\Mailchimp $mc
    ): array {
        if ($value) {
            foreach ($value as &$currentValue) {
                if (substr_count($currentValue, ':::') > 0) {
                    if (!isset(self::$legacyCategoryList[$listId])) {
                        $groups = [];

                        // Look for all categories and groups on this list
                        $interestCategories = $mc->get(
                            "lists/{$listId}/interest-categories",
                            [
                                'fields' => 'categories.id,categories.title',
                                'count'  => 100
                            ]
                        );
                        $interestCategories = $interestCategories->toArray();

                        if (!empty($interestCategories)) {
                            foreach ($interestCategories as $categ) {
                                $interests = $mc->get(
                                    "lists/{$listId}/interest-categories/{$categ->id}/interests",
                                    [
                                        'fields' => 'interests.id,interests.name,interests.subscriber_count',
                                        'count'  => 100
                                    ]
                                );
                                $interests = $interests->toArray();

                                if (!empty($interests)) {
                                    foreach ($interests as $interest) {
                                        $legacyValue = $categ->title . ':::' . $interest->name;

                                        $groups[$legacyValue] = $interest->id;
                                    }
                                }
                            }
                        }

                        self::$legacyCategoryList[$listId] = $groups;
                    }

                    if (isset(self::$legacyCategoryList[$listId][$currentValue])) {
                        $currentValue = self::$legacyCategoryList[$listId][$currentValue];
                    }
                }
            }
        }

        return $value;
    }
}
