<?php

/**
 * @copyright	Copyright (C) 2011-2019 Cedric KEIFLIN alias ced1870
 * https://www.joomlack.fr
 * @license		GNU/GPL
 * */
defined('_JEXEC') or die;

jimport('joomla.html.html');
jimport('joomla.form.formfield');

include_once JPATH_ROOT . '/administrator/components/com_slideshowck/helpers/defines.php';

// custom class extension for J3 compatibility
if (class_exists('\Joomla\CMS\Form\Field\ListField')) {
	class JFormFieldSlideshowcklistBase extends \Joomla\CMS\Form\Field\ListField {}
} else {
	class JFormFieldSlideshowcklistBase extends JFormFieldList {}	
}

class JFormFieldSlideshowcklist extends JFormFieldSlideshowcklistBase {

	protected $type = 'slideshowcklist';

	protected function getInput() {
		// Initialize some field attributes.
		$icon = $this->element['icon'];
		$suffix = $this->element['suffix'];

		$html = $icon ? '<div class="slideshowck-field-icon" ' . ($suffix ? 'data-has-suffix="1"' : '') . '><img src="' . SLIDESHOWCK_MEDIA_URI . '/images/' . $icon . '" style="margin-right:5px;" /></div>' : '<div style="display:inline-block;width:20px;"></div>';

		$html .= parent::getInput();
		if ($suffix)
			$html .= '<span class="slideshowck-field-suffix">' . $suffix . '</span>';
		return $html;
	}

}
