<?php

/**
 * @version    6.0.2
 * @package    TAGZ
 * @author     roosterz.nl <roy@roosterz.nl>
 * @copyright  2025 roosterz.nl
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');

// Controller compatibility for Joomla 3..6
// Prefer namespaced FormController when available, otherwise fall back to legacy JControllerForm

if (class_exists('Joomla\\CMS\\MVC\\Controller\\FormController')) {
	class TagzControllerConfig extends \Joomla\CMS\MVC\Controller\FormController
	{
		protected $text_prefix = 'Tagz';
	}
} elseif (class_exists('JControllerForm')) {
	class TagzControllerConfig extends JControllerForm
	{
		protected $text_prefix = 'Tagz';
	}
} else {
	// Minimal fallback to avoid fatal errors in unexpected environments
	class TagzControllerConfig
	{
		protected $text_prefix = 'Tagz';
	}
}
