<?php
/**
 * Element: Custom Content
 * Displays a list of custom content fields and some standard Open Graph content fields
 *
 * @package  TAGZ
 * @copyright  2025 roosterz.nl
 * @ All rights reserved
 * @ Joomla! is Free Software
 * @ Released under GNU/GPL v3.0 License : http://www.gnu.org/licenses/gpl-3.0.html
 **/

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormHelper;
use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\Database\DatabaseInterface;

FormHelper::loadFieldClass('list');

class JFormFieldRH_Customcontent extends ListField
{
    public $type    = 'Customcontent';
    private $params = null;
    private $db     = null;

    /**
     * Get the field options.
     *
     * @return  array  The field option objects.
     */
    protected function getOptions()
    {
        $options = [];

        $excludeImages = (string) $this->element['excludeimages'];

        $defaultFields = [
            'title' => 'Title',
            'introtext' => 'Intro Text',
            'fulltext' => 'Full Text',
            'metadesc' => 'Meta Description'
        ];

        if (!$excludeImages) {
            $defaultFields += [
                'image_intro' => 'Intro Image',
                'image_fulltext' => 'Full Article Image'
            ];

            if (!empty($this->checkIfHelixInstalled())) {
                
                $defaultFields += ['image_helix' => 'Helix Article Image'];
                
                
            }
        }

        foreach ($defaultFields as $defaultField => $label) {
            $fieldTitle = $label . ' [Article Field]';

            if ($defaultField === 'image_helix_pro') {
                $options[] = HTMLHelper::_('select.option', $defaultField, $fieldTitle, 'value', 'text', true);
            } else {
                $options[] = HTMLHelper::_('select.option', $defaultField, $fieldTitle);
            }
        }

        $customFields = $this->getCustomFields();

        if (!empty($customFields)) {
            foreach ($customFields as $field) {
                $title = $field->title . ' [Custom Field]';
                $options[] = HTMLHelper::_('select.option', $field->id, $title);
            }
        }

        return array_merge(parent::getOptions(), $options);
    }

    /**
     * Get all custom fields.
     */
    protected function getCustomFields()
    {
        $db = $this->getDb();

        $query = $db->getQuery(true)
            ->select($db->quoteName(['title', 'id']))
            ->from($db->quoteName('#__fields'));

        $db->setQuery($query);

        try {
            return $db->loadObjectList() ?: [];
        } catch (Exception $e) {
            return [];
        }
    }

    /**
     * Check if Helix is installed.
     */
    protected function checkIfHelixInstalled()
    {
        $db = $this->getDb();

        $query = $db->getQuery(true)
            ->select($db->quoteName('extension_id'))
            ->from($db->quoteName('#__extensions'))
            ->where('element IN ("helixultimate", "helix3")');

        $db->setQuery($query);

        return $db->loadResult();
    }

    /**
     * Return database connection compatible with Joomla 3-6.
     */
    private function getDb()
    {
        if ($this->db) {
            return $this->db;
        }

        // Joomla 4+
        if (class_exists('Joomla\\CMS\\Factory')) {
            try {
                $this->db = Factory::getContainer()->get(DatabaseInterface::class);
            } catch (Throwable $e) {
                // Joomla 3 fallback
                $this->db = \JFactory::getDBO();
            }
        } else {
            $this->db = \JFactory::getDBO();
        }

        return $this->db;
    }

    /**
     * Simple getter with default.
     */
    private function get($val, $default = '')
    {
        return isset($this->params[$val]) && (string) $this->params[$val] !== ''
            ? (string) $this->params[$val]
            : $default;
    }
}
