<?php
/**
 * FancyList FormField
 * @package roosterz.nl
 * @copyright (C) 2014 roosterz.nl
 * @ All rights reserved
 * @ Joomla! is Free Software
 * @ Released under GNU/GPL v3.0 License : http://www.gnu.org/licenses/gpl-3.0.html
 */

defined('_JEXEC') or die;

use Joomla\CMS\Form\FormHelper;
use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Associations;

FormHelper::loadFieldClass('list');

class JFormFieldRH_FancyList4 extends ListField
{
    protected $type = 'FancyList4';

    /**
     * Get the field options
     *
     * @return array
     */
    protected function getOptions()
    {
        $options = [];

        foreach ($this->element->children() as $option)
        {
            // Only add <option /> elements
            if ($option->getName() !== 'option') {
                continue;
            }

            // Filter requirements
            $requires = explode(',', (string) $option['requires']);

            if (in_array('multilanguage', $requires) && !Multilanguage::isEnabled()) {
                continue;
            }

            if (in_array('associations', $requires) && !Associations::isEnabled()) {
                continue;
            }

            $value = (string) $option['value'];

            $disabled = in_array((string) $option['disabled'], ['true', 'disabled', '1']);
            $disabled = $disabled || ($this->readonly && $value != $this->value);

            // Create a new option object based on the <option /> element
            $tmp = HTMLHelper::_(
                'select.option',
                $value,
                Text::alt(trim((string) $option), preg_replace('/[^a-zA-Z0-9_\-]/', '_', $this->fieldname)),
                'value',
                'text',
                $disabled
            );

            // Set some option attributes
            $tmp->option_id = $value;
            $tmp->labels    = (string) $option['labels'];
            $tmp->class     = (string) $option['class'];
            $tmp->onclick   = (string) $option['onclick'];

            $options[] = $tmp;
        }

        return $options;
    }
}
