<?php
/**
 * @package     Ardhs
 * @subpackage  com_ardhs
 *
 * @author      Abdul waheed <info@abdulwaheed.pk>
 * @website		www.abdulwaheed.pk
 * @copyright   Copyright (C) abdulwaheed.pk All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Abdul\Component\Ardhs\Site\Model;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Associations;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Model\ListModel;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Table\Table;
use Joomla\CMS\Workflow\Workflow;
use Joomla\Component\Content\Administrator\Extension\ContentComponent;
use Joomla\Utilities\ArrayHelper;
use Joomla\Database\ParameterType;

/**
 *
 * @since  1.6
 */
class PropsModel extends ListModel
{
	/**
	 * Constructor.
	 *
	 * @param   array  $config  An optional associative array of configuration settings.
	 *
	 * @since   1.6
	 * @see     \Joomla\CMS\MVC\Controller\BaseController
	 */
	public function __construct($config = array())
	{
		if (empty($config['filter_fields']))
		{
			$config['filter_fields'] = array(
				'id', 'district',
'country',
'region',
'county',
'proptype',
'building',
'price',
'bedrooms',
'bathrooms',
'parking'
			);
		}

		parent::__construct($config);
	}

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @param   string  $ordering   An optional ordering field.
	 * @param   string  $direction  An optional direction (asc|desc).
	 *
	 * @return  void
	 *
	 * @since   1.6
	 */
	protected function populateState($ordering = 'id', $direction = 'asc')
	{
		$search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
		$this->setState('filter.search', $search);
		
$c_=$this->getUserStateFromRequest($this->context . '.filter.country', 'filter_country');
$this->setState('filter.country', $c_);

$region=$this->getUserStateFromRequest($this->context . '.filter.region', 'filter_region');
$this->setState('filter.region', $region);

$cou_=$this->getUserStateFromRequest($this->context . '.filter.county', 'filter_county');
$this->setState('filter.county', $cou_);

$proptype=$this->getUserStateFromRequest($this->context . '.filter.search', 'filter_proptype');
$this->setState('filter.proptype', $proptype);

$build_=$this->getUserStateFromRequest($this->context . '.filter.building', 'filter_building');
$this->setState('filter.building', $build_);

$price=$this->getUserStateFromRequest($this->context . '.filter.price', 'filter_price');
$this->setState('filter.price', $price);

$beds=$this->getUserStateFromRequest($this->context . '.filter.bedrooms', 'filter_bedrooms');
$this->setState('filter.bedrooms', $beds);

$baths=$this->getUserStateFromRequest($this->context . '.filter.bathrooms', 'filter_bathrooms');
$this->setState('filter.bathrooms', $baths);

$park=$this->getUserStateFromRequest($this->context . '.filter.park', 'filter_park');
$this->setState('filter.park', $park);


		// List state information
$app = Factory::getApplication();   // equivalent of $app = JFactory::getApplication();
$input = $app->input;
		$limit = $input->get('limit', $app->get('list_limit', 0), 'uint');
//		echo "<h1>$limit</h1>";
		$this->setState('list.limit', $limit);
		
		$value = $input->get('limitstart', 0, 'uint');
		$this->setState('list.start', $value);


		$published = $this->getUserStateFromRequest($this->context . '.filter.published', 'filter_published', '');
		$this->setState('filter.published', $published);

		// List state information.
		//parent::populateState($ordering, $direction);
	}

	/**
	 * Method to get a store id based on model configuration state.
	 *
	 * This is necessary because the model is used by the component and
	 * different modules that might need different sets of data or different
	 * ordering requirements.
	 *
	 * @param   string  $id  A prefix for the store id.
	 *
	 * @return  string  A store id.
	 *
	 * @since   1.6
	 */
	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id .= ':' . $this->getState('filter.search');
		$id .= ':' . $this->getState('filter.published');

		return parent::getStoreId($id);
	}

	/**
	 * Build an SQL query to load the list data.
	 *
	 * @return  \Joomla\Database\DatabaseQuery
	 *
	 * @since   1.6
	 */
	protected function getListQuery()
	{
		
		
		// Create a new query object.
		$db    = $this->getDbo();
		$app = Factory::getApplication();
		$query = $db->getQuery(true);

		// Select the required fields from the table.
		$query->select(
			$this->getState(
				'list.select',
				'*'
			)
		);
		$query->from('#__ardh_properties');

		
		// Filter by search in title.
		$search = $this->getState('filter.search');
		$input = $app->input;
		$title_mlsid= $input->get('title_mlsid', '', 'STRING');
		if (!empty($title_mlsid))
		{
			$title_mlsid = $db->quote('%' . str_replace(' ', '%', $db->escape(trim($title_mlsid), true) . '%'));
			$query->where('(title LIKE ' . $title_mlsid . ' OR mlsid LIKE ' . $title_mlsid . ')');
		}
		$proptype= $input->get('proptype', '', 'STRING');
		if (!empty($proptype)) {
			$query->where('(proptype ="' . $proptype . '")'); }

		$status= $input->get('status', '', 'STRING');
//echo $status . ":". Text::_($status);
		if (!empty($status)) {
			$query->where('(status ="' . Text::_($status) . '")'); }

		$region= $input->get('region', '', 'STRING');
		if (!empty($region)) {
			$query->where('(region ="' . $region . '")'); }
		$neighborhood= $input->get('neighborhood', '', 'STRING');
		if (!empty($neighborhood)) {
			$query->where('(neighborhood ="' . $neighborhood . '")'); }
		$bedrooms= $input->get('bedrooms', '', 'STRING');
		if (!empty($bedrooms)) {
			$query->where('(bedrooms ="' . $bedrooms . '")'); }
		$bathrooms= $input->get('bathrooms', '', 'STRING');
		if (!empty($bathrooms)) {
			$query->where('(bathrooms ="' . $bathrooms . '")'); }
		
		$min_lotsize= $input->get('min_lotsize', '', 'STRING');
		$max_lotsize= $input->get('max_lotsize', '', 'STRING');
//		echo $min_lotsize.'insdie propsmodel getlistquery() :'.$max_lotsize;
		if (!empty($min_lotsize)&&!empty($max_lotsize)) {
			$query->where('(CAST(REPLACE(lotsize, " m²", "") AS DECIMAL(10,2)) 
      BETWEEN "'.$min_lotsize.'" AND "'.$max_lotsize.'")'); }
//		
		$min_size= $input->get('min_size', '', 'STRING');
		$max_size= $input->get('max_size', '', 'STRING');
		if (!empty($min_size)&&!empty($max_size)) {
			$query->where('(size between "'.$min_size.'" AND "'.$max_size.'")'); }

		$minPrice= $input->get('minPrice', '', 'STRING');
		$maxPrice= $input->get('maxPrice', '', 'STRING');
		if (!empty($minPrice)&&!empty($maxPrice)) {
			$query->where('(CAST(REPLACE(REPLACE(price, "$", ""), ",", "") AS UNSIGNED) between "'.$minPrice.'" AND "'.$maxPrice.'")');
		}

		if (!empty($search))
		{
			$search = $db->quote('%' . str_replace(' ', '%', $db->escape(trim($search), true) . '%'));
			$query->where('(title LIKE ' . $search . ' OR mlsid LIKE ' . $search . ')');
		}
		// Filter by region in title.
		$region = $this->getState('filter.region');
		if (!empty($region))
		{
			$region = $db->quote('%' . str_replace(' ', '%', $db->escape(trim($region), true) . '%'));
			$query->where('(region LIKE ' . $region . ')');
		}
		// Filter by region in title.
		$country = $this->getState('filter.country');
		if (!empty($country))
		{
			$country= $db->quote('%' . str_replace(' ', '%', $db->escape(trim($country), true) . '%'));
			$query->where('(country LIKE ' . $country . ')');
		}
		// Filter by region in price.
		$price = $this->getState('filter.price');
		if (!empty($price))
		{
			$price= $db->quote('%' . str_replace(' ', '%', $db->escape(trim($price), true) . '%'));
			$query->where('(price LIKE ' . $price . ')');
		}
		
		$sitemenu = $app->getMenu();
		$activeMenuitem = $sitemenu->getActive();
		
		// Default language if no menu item is active
		$lang = $input->get('lang', 'en', 'STRING');
		// Check if $activeMenuitem exists before calling getParams()
		if ($activeMenuitem) {
			$menu_params = $activeMenuitem->getParams();
		//    $lang = $menu_params->get('lang', 'en'); // Fallback to 'en' if 'lang' param is not set
		}
		
		// Safely build the query condition
		$query->where('(lang LIKE "' . $lang . '")');
		// Add the list ordering clause.
		$orderCol  = $this->state->get('list.ordering', 'id');
		$orderDirn = $this->state->get('list.direction', 'ASC');

		$query->order($db->escape($orderCol) . ' ' . $db->escape($orderDirn));

		$query->order($db->escape("proptype") . ' ' . $db->escape("ASC"));
		$query->order($db->escape("region") . ' ' . $db->escape("ASC"));
		$query->order($db->escape("neighborhood") . ' ' . $db->escape("ASC"));
//   echo $query; //exit;
		return $query;


	}

	/**
	 * Method to get a list of walks.
	 * Overridden to add a check for access levels.
	 *
	 * @return  mixed  An array of data items on success, false on failure.
	 *
	 * @since   4.0.0
	 */
	public function getItems()
	{
		$limit = $this->getState('list.limit');
	//		echo "<h1>$limit</h1>";
		$items = parent::getItems();

		return $items;
	}
	
}
