<?php
/**
 * @package     Ardhs
 * @subpackage  com_ardhs
 *
 * @author      Abdul waheed <info@abdulwaheed.pk>
 * @website		www.abdulwaheed.pk
 * @copyright   Copyright (C) abdulwaheed.pk All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Factory;
// Import `ComponentHelper` class.
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Uri\Uri;

$sitebaseurl=Uri::base();//exit;

// Get current language
$currentLanguage = Factory::getLanguage();
$currentLangCode = $currentLanguage->getTag(); // Returns language tag like 'en-GB', 'ur-PK', etc.
$currentLangShort = substr($currentLangCode, 0, 2); // Gets short code like 'en', 'ur'

// Alternative method to get current menu language if you need menu-specific language
$app = Factory::getApplication();
$menu = $app->getMenu()->getActive();
$menuLanguage = $menu ? $menu->language : '*';

// Get all params of a specific component.
$params = ComponentHelper::getParams('com_ardhs');


// Example usage of the language variables:
//echo "Current Language Code: " . $currentLangCode . "<br>";
//echo "Current Short Language: " . $currentLangShort . "<br>";
//echo "Menu Language: " . $menuLanguage . "<br>";

// You can use these language variables in your logic
if ($currentLangShort === 'es') {
    // Do something for Urdu language
//    echo "Es language detected";
	// To get the value of the param.
	$allpropsmenu= $params->get('allpropsmenu_es');
	$singlepropmenu = $params->get('singlepropmenu_es');
} else {
    // Default to English or other languages
//    echo "English or other language detected";
	// To get the value of the param.
	$allpropsmenu= $params->get('allpropsmenu');
	$singlepropmenu = $params->get('singlepropmenu');
}
	$num_col = $params->get('num_col');

function cropText($text, $maxLength = 70) {
	return (strlen($text) > $maxLength)
	? substr($text, 0, $maxLength - 3) . '...'
	: $text;
}

// Default language if no menu item is active
$app = Factory::getApplication();
$input = $app->input;
$lang = $input->get('lang', 'en', 'STRING');
?>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

<form method="post" name="adminForm" id="adminForm" action="<?=Route::_("index.php?option=com_ardhs&view=props&lang=$lang&Itemid=$allpropsmenu")?>">

	<input type="hidden" name="task" id="task" value="">
	<input type="hidden" name="lang" id="lang" value="<?=$lang?>">

<?php //echo LayoutHelper::render('joomla.searchtools.default', ['view' => $this]); ?>

<div class="row">

<?php if (empty($this->items)) : ?>
    <div class="col-lg-12">
        <span class="fa fa-info-circle" aria-hidden="true"></span><span class="sr-only"><?php echo Text::_('INFO'); ?></span>
        <?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
    </div>
<?php else : ?>
<?php
//		echo '<pre>';print_r($this->items);exit;
$n = count($this->items);
$user  = Factory::getUser();
foreach ($this->items as $i => $item) :

    $main_image=($item->main_image!="")?$sitebaseurl.'images/mls/'.$item->main_image:"";
	$alias=strtolower(str_replace(" ","-",$item->title));
	$neighborhood=$item->neighborhood;
	$building=$item->building;
	$region=$item->region;
	$size=$item->size;
	$status=$item->status;
	$bedrooms=$item->bedrooms;
	$bathrooms=$item->bathrooms;
	$parking=$item->parking;
	$proptype=$item->proptype;
    $link=Route::_('index.php?option=com_ardhs&view=prop&id=' . $item->id."-".$alias.'&Itemid='.$singlepropmenu);
	//echo $singlepropmenu;exit;
	$price=$item->price;
	$district=$item->district;
	$country=$item->country;
    ?>
    <div class="col-12 col-md-<?=$num_col?> mb-2 position-relative" >
        <div id="propBlock_<?php echo $i?>" class="border p-1" style="min-height:400px; background-color:#fafafa;">
        
        <!-- IMAGE PART -->
        
        <div class=" position-relative">
        <a href="<?php echo $link; ?>" style="text-decoration:none;">
			<img src="<?php echo $main_image?>" alt="" class="img-fluid" />
			<div class="position-absolute ps-1 pe-1" style="top:10px; right:10px; background:#224faa; color:#FFFFFF; border-radius:3px;"><?=$proptype?></div>
			<div class="position-absolute ps-1 pe-1" style="top:40px; right:10px; background:#FF6E00; color:#FFFFFF; border-radius:3px;"><?=$status?></div>
            <div class=" position-absolute" style="bottom:10px; color:white; font-size:11px; left:10px;">
            <i class="fa-solid fa-location-dot"></i> 
			<!--<?=$neighborhood." ".$building." ".$region?>-->
            <?=$district.", ".$region.", ".$country?>
            </div>
        </a>
        </div>

        <!-- TITLE PART -->
        <p class="pt-2 ps-2 pb-2 m-0">
        	<a style="font-size:16px; font-weight:bold; text-decoration:none; " href="<?php echo $link; ?>"><?php echo $this->escape($item->title); ?></a>
        </p>

        <!-- PRICE PART -->
        <p class="ps-2 m-0 " style="color: #ec430f;"><?=$price?></p>

<!--        <div class="ps-2 pt-2 pb-1 m-0 pull-right"><i class="fa fa-square" aria-hidden="true"></i> <?=$proptype?></div>
		<div style="clear:both"></div>
-->        

        <!-- SHORT DESC(MEta) -->
        <p class="ps-2" style="font-size:16px; ">
			<?=cropText($item->meta_description)?>
		</p>

        <!-- BED BATHROOM, PARKING, PART -->
        <p class="ps-2" style="font-size:14px; ">
		<?php if($bedrooms!=""){?><i class="fa fa-bed" aria-hidden="true"></i> <?=$bedrooms?> | <?php }?>
		<?php if($bathrooms!=""){?><i class="fa fa-bath" aria-hidden="true"></i> <?=$bathrooms?> | <?php }?>
		<?php if($parking!=""){?><i class="fa fa-car"></i> <?=$parking?><?php }?>
        <?php if($size!=""){?><i class="fas fa-ruler"></i> <?=$size?> <?php }?>

			<!--
			<br>
            <div style='width: 85%; float: left'>&nbsp;</div>
			<div style='width: 14%;float: right;'><a href="<?=$link?>"><?php echo Text::_('COM_ARDSH_PROP_DETAILS')?></a></div>
			<div style="clear: both">&nbsp;</div>
            -->
		</p>

        </div>

        

    </div>

<script>
jQuery(document).ready(function(){

jQuery(".js-stools-btn-clear").click(function(e){
	jQuery("#filter_search").val("");
	jQuery("#adminForm").submit();
});

jQuery("#courseData_<?php echo $i?>").hover(function(e){
   // jQuery("#short_desc_<?php echo $i?>").show();
}, function(){
    jQuery("#short_desc_<?php echo $i?>").hide();
});
jQuery("#short_desc_<?php echo $i?>").hover(function(e){
   // jQuery("#short_desc_<?php echo $i?>").show();
}, function(){
    jQuery("#short_desc_<?php echo $i?>").hide();
});

});
</script>

<?php endforeach; ?>
<?php 
$app = Factory::getApplication();
$input = $app->input;
$title_mlsid= $input->get('title_mlsid', '', 'STRING');
if (!empty($title_mlsid)) 
	$this->pagination->setAdditionalUrlParam('title_mlsid',$title_mlsid);

$proptype= $input->get('proptype', '', 'STRING');
if (!empty($proptype)) 
	$this->pagination->setAdditionalUrlParam('proptype',$proptype);

$region= $input->get('region', '', 'STRING');
if (!empty($region)) 
	$this->pagination->setAdditionalUrlParam('region',$region);

$neighborhood= $input->get('neighborhood', '', 'STRING');
if (!empty($neighborhood)) 
	$this->pagination->setAdditionalUrlParam('neighborhood',$neighborhood);

$bedrooms= $input->get('bedrooms', '', 'STRING');
if (!empty($bedrooms)) 
	$this->pagination->setAdditionalUrlParam('bedrooms',$bedrooms);

$bathrooms= $input->get('bathrooms', '', 'STRING');
if (!empty($bathrooms)) 
	$this->pagination->setAdditionalUrlParam('bathrooms',$bathrooms);

$min_lotsize= $input->get('min_lotsize', '', 'STRING');
$max_lotsize= $input->get('max_lotsize', '', 'STRING');
if (!empty($min_lotsize)&&!empty($max_lotsize)) {
	$this->pagination->setAdditionalUrlParam('min_lotsize',$min_lotsize);
	$this->pagination->setAdditionalUrlParam('max_lotsize',$max_lotsize);
}	
$min_size= $input->get('min_size', '', 'STRING');
$max_size= $input->get('max_size', '', 'STRING');
if (!empty($min_size)&&!empty($max_size)) {
	$this->pagination->setAdditionalUrlParam('min_size',$min_size);
	$this->pagination->setAdditionalUrlParam('max_size',$max_size);
}

$minPrice= $input->get('minPrice', '', 'STRING');
$maxPrice= $input->get('maxPrice', '', 'STRING');
if (!empty($minPrice)&&!empty($maxPrice)) {
	$this->pagination->setAdditionalUrlParam('minPrice',$minPrice);
	$this->pagination->setAdditionalUrlParam('maxPrice',$maxPrice);
}

if (!empty($allpropsmenu)) {
	$this->pagination->setAdditionalUrlParam('Itemid',$allpropsmenu);
}


echo $this->pagination->getListFooter();

?>


<?php endif; ?>
</div><!-- <div class="row"> -->

</form>

<style>
.checked {
color: orange;
}
.btnmaroon_red {
	color:black;
}
.btnmaroon {
	color: white;
}
.btnmaroon, .btnmaroon_red {
	font-weight:bold;
    border-color: #ec430f;
    background-color: #ec430f;
	height: 35px;
    padding-top: 6px;
    padding-bottom: 6px;
    border-radius: 0;
	display:block;
    box-shadow: none;
    box-sizing: border-box;
    -moz-box-sizing: border-box;
    -webkit-box-sizing: border-box;
}

.short_desc_ { 
	min-height:400px;
	display:none;
	left: 250px;
	width: 300px;
	background: white; 
	z-index: 9999; 
	top:-75px 
}
.arrow {
    border: solid #dfe3e7;
    border-width: 1px 0px 0px 1px;
    display: inline-block;
    padding: 12px;
    background: white;
}

.right {
  transform: rotate(-45deg);
  -webkit-transform: rotate(-45deg);
}

/* Base (applies to all sizes) */
.position-static     { position: static !important; }
.position-relative   { position: relative !important; }
.position-absolute   { position: absolute !important; }
.position-fixed      { position: fixed !important; }
.position-sticky     { position: sticky !important; }

/* Small (≥576px) */
@media (min-width: 576px) {
  .position-sm-static     { position: static !important; }
  .position-sm-relative   { position: relative !important; }
  .position-sm-absolute   { position: absolute !important; }
  .position-sm-fixed      { position: fixed !important; }
  .position-sm-sticky     { position: sticky !important; }
}

/* Medium (≥768px) */
@media (min-width: 768px) {
  .position-md-static     { position: static !important; }
  .position-md-relative   { position: relative !important; }
  .position-md-absolute   { position: absolute !important; }
  .position-md-fixed      { position: fixed !important; }
  .position-md-sticky     { position: sticky !important; }
}

/* Large (≥992px) */
@media (min-width: 992px) {
  .position-lg-static     { position: static !important; }
  .position-lg-relative   { position: relative !important; }
  .position-lg-absolute   { position: absolute !important; }
  .position-lg-fixed      { position: fixed !important; }
  .position-lg-sticky     { position: sticky !important; }
}

/* Extra Large (≥1200px) */
@media (min-width: 1200px) {
  .position-xl-static     { position: static !important; }
  .position-xl-relative   { position: relative !important; }
  .position-xl-absolute   { position: absolute !important; }
  .position-xl-fixed      { position: fixed !important; }
  .position-xl-sticky     { position: sticky !important; }
}

/* Extra Extra Large (≥1400px) */
@media (min-width: 1400px) {
  .position-xxl-static     { position: static !important; }
  .position-xxl-relative   { position: relative !important; }
  .position-xxl-absolute   { position: absolute !important; }
  .position-xxl-fixed      { position: fixed !important; }
  .position-xxl-sticky     { position: sticky !important; }
}

</style>