<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

/**
 * Layout variables
 *
 * @var \OSL\Config\Config $config
 * @var stdClass           $item
 */

use Joomla\CMS\Factory;

?>
<div class="hdp-ticket-message">
	<?php
        if ($config->process_bb_code)
        {
            echo HelpdeskProHelper::processBBCode($item->message);
        }
        else
        {
            if ($config->use_html_editor)
            {
                echo $item->message;
            }
            else
            {
                echo nl2br($item->message);
            }
        }

        if ($item->attachments)
        {
	        $assetVersion = HelpdeskProHelper::getInstalledVersion();

	        // Load luminous library
	        Factory::getApplication()
		        ->getDocument()
		        ->getWebAssetManager()
		        ->registerAndUseScript('com_helpdeskpro.luminous', 'media/com_helpdeskpro/assets/js/luminous/luminous.min.js', ['defer' => true, 'version' => $assetVersion])
		        ->registerAndUseStyle('com_helpdeskpro.luminous', 'media/com_helpdeskpro/assets/js/luminous/luminous-basic.min.css', ['version' => $assetVersion]);

	        echo HelpdeskProHelperHtml::loadCommonLayout('common/tmpl/ticket_attachments.php', ['item' => $item]);
        }
	?>
</div>
