<?php
/**
 * @package JMAP::SITEMAP::components::com_jmap
 * @subpackage views
 * @subpackage viewer
 * @subpackage tmpl
 * @author Joomla! Extensions Store
 * @copyright (C) 2025
 * @license GNU/GPLv2
 */
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;
?>

<div id="content" class="videos_sitemap">
	<h1><?php echo Text::_('COM_JMAP_VIEWER_VIDEOS_SITEMAP'); ?></h1>

	<div class="leftinfo">
		<div class="expl">
			<p>
				<?php echo Text::sprintf(
					'COM_JMAP_VIEWER_GENERATED_BY',
					'<strong><a target="_blank" rel="noopener" href="https://storejextensions.org/extensions/jsitemap_professional.html">JSitemap Pro</a></strong>'
				); ?>
			</p>
			<p>
				<?php echo Text::sprintf(
					'COM_JMAP_VIEWER_SITEMAP_INFO',
					'<a href="https://www.sitemaps.org" target="_blank" rel="noopener">sitemaps.org</a>'
				); ?>
			</p>
			<p>
				<?php echo Text::sprintf(
					'COM_JMAP_VIEWER_SITEMAP_CONTAINS',
					'<span class="expl_details"><span id="urls_count_label">0</span> URLs</span>'
				); ?>
			</p>
			<p>
				<?php echo
					Text::sprintf(
						'COM_JMAP_VIEWER_SITEMAP_CONTAINS',
						'<span id="url-count" class="expl_details"><span id="videos_count_label">0</span> ' . Text::_('COM_JMAP_VIEWER_SITEMAP_CONTAINS_VIDEOS') . '</span>'
					);
				?>
			</p>
		</div>
	</div>

	<div class="rightchart">
		<canvas id="chart_canvas"></canvas>
	</div>

	<table id="sitemap" class="videos">
		<thead>
			<tr>
				<th style="width:20%"><?php echo Text::_('COM_JMAP_VIEWER_COL_URL'); ?></th>
				<th style="width:10%"><?php echo Text::_('COM_JMAP_VIEWER_COL_VIDEO_THUMBNAIL'); ?></th>
				<th style="width:15%"><?php echo Text::_('COM_JMAP_VIEWER_COL_PREVIEW'); ?></th>
				<th style="width:15%"><?php echo Text::_('COM_JMAP_VIEWER_COL_VIDEO_TITLE'); ?></th>
				<th style="width:20%"><?php echo Text::_('COM_JMAP_VIEWER_COL_VIDEO_DESCRIPTION'); ?></th>
				<th style="width:5%"><?php echo Text::_('COM_JMAP_VIEWER_COL_VIDEO_VIEWS'); ?></th>
				<th style="width:5%"><?php echo Text::_('COM_JMAP_VIEWER_COL_VIDEO_DURATION'); ?></th>
				<th style="width:10%"><?php echo Text::_('COM_JMAP_VIEWER_COL_VIDEO_PUBLICATION_DATE'); ?></th>
				<th style="width:10%"><?php echo Text::_('COM_JMAP_VIEWER_COL_VIDEO_AUTHOR'); ?></th>
				<th style="width:5%"><?php echo Text::_('COM_JMAP_VIEWER_COL_VIDEOS_COUNT'); ?></th>
			</tr>
		</thead>
		<tbody id="sitemap-body" class="videos"></tbody>
	</table>

	<!-- REQUIRED for chart -->
	<div id="sitemap_type" class="hidden">videos</div>
	<div id="urls_count" class="hidden">0</div>
	<div id="videos_count" class="hidden">0</div>
</div>

<?php
// Set the document title
$title = Text::_('COM_JMAP_VIEWER_VIDEOS_SITEMAP');
$this->setDocumentTitle($title);
?>