<?php
/*------------------------------------------------------------------------
# OsCalendar.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2012 joomdonation.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/
// no direct access
defined('_JEXEC') or die;

error_reporting(E_ERROR | E_PARSE | E_COMPILE_ERROR);
//error_reporting(E_ALL);
define('DS', DIRECTORY_SEPARATOR);
$document = JFactory::getDocument();
$document->addScript(JURI::root()."components/com_oscalendar/js/ajax.js");
$document->addScript(JURI::root()."components/com_oscalendar/js/paymentmethods.js");
$document->addStyleSheet(JURI::root()."components/com_oscalendar/style/style.css");
$document->addStyleSheet("//code.jquery.com/ui/1.10.4/themes/smoothness/jquery-ui.css");
$document->addStyleSheet(JURI::root()."components/com_osproperty/style/frontend_style.css");

JTable::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_oscalendar/tables');
require_once(JPATH_ROOT."/components/com_osproperty/helpers/common.php");
require_once(JPATH_ROOT."/components/com_osproperty/helpers/helper.php");
require_once(JPATH_ROOT."/components/com_osproperty/helpers/jquery.php");
require_once(JPATH_ROOT."/components/com_osproperty/helpers/bootstrap.php");
require_once JPATH_ROOT.'/components/com_oscalendar/plugins/os_payment.php';
require_once JPATH_ROOT.'/components/com_oscalendar/plugins/os_payments.php';
jimport('joomla.filesystem.folder');
//Include files from classes folder
$dir = JFolder::files(JPATH_COMPONENT."/classes");
if(count($dir) > 0){
	for($i=0;$i<count($dir);$i++){
		require_once(JPATH_COMPONENT."/classes".DS.$dir[$i]);
	}
}
$dir = JFolder::files(JPATH_COMPONENT."/helpers");
if(count($dir) > 0){
	for($i=0;$i<count($dir);$i++){
		if($dir[$i]!= "ipn_log.txt"){
			require_once(JPATH_COMPONENT."/helpers".DS.$dir[$i]);
		}
	}
}
global $_jversion,$configs,$configClass,$cClass,$symbol,$mainframe;
OSPHelper::generateBoostrapVariables();
$mainframe = JFactory::getApplication();
$db = JFactory::getDBO();
$db->setQuery("Select * from #__osrs_configuration");
$configs = $db->loadObjectList();
$configClass = array();
foreach ($configs as $config) {
	$configClass[$config->fieldname] = $config->fieldvalue;
}
$general_currency_default = $configClass['general_currency_default'];
if($general_currency_default > 0){
	$db->setQuery("Select currency_code from #__osrs_currencies where id = '$general_currency_default'");
	$configClass['currency_format'] = $db->loadResult();
}else{
	$configClass['currency_format'] = "USD";
}


$db->setQuery("Select currency_symbol from #__osrs_currencies where currency_code like '".$configClass['currency_format']."'");
$currency_symbol = $db->loadResult();

$configClass['currency_symbol'] = $currency_symbol;

$db->setQuery("Select * from #__oscalendar_configuration");
$configs = $db->loadObjectList();
$cClass = array();
foreach ($configs as $config) {
	$cClass[$config->config_key] = $config->config_value;
}
$use_ssl = $cClass['use_ssl'];
$domain_post = strpos(JURI::root(),"://");
$domain = substr(JURI::root(),$domain_post);
if($use_ssl == 1){
	$root_url = "https".$domain;
}else{
	$root_url = "http".$domain;
}
$cClass['root_link'] = $root_url;

global $lang_suffix,$languages;
$languages = OSPHelper::getLanguages();
$translatable = JLanguageMultilang::isEnabled() && count($languages);
OSCHelper::loadThemeStyle();
if($translatable){
	//generate the suffix
	$lang_suffix = OSPHelper::getFieldSuffix();
}

$task = $mainframe->input->getString('task','');
if($task == ""){
	$view = $mainframe->input->getString('view');
	switch ($view){
		default:
			$task = "default_bookinglist";
		break;
	}
}

if (version_compare(JVERSION, '3.0', 'lt')) {
	OSPHelper::loadBootstrap(true);	
}else{
	if($configClass['load_bootstrap']  == 1){
		OSPHelper::loadBootstrap(true);
	}else{
		OSPHelper::loadBootstrap(false);	
	}
}

$task = $mainframe->input->getString('task','');
if($task == ""){
	$view = $mainframe->input->getString('view');
	switch ($view){
		case "manageorders":
			$task = "default_bookinglist";
		break;
		case "myorders":
			$task = "customer_default";
		break;
	}
}
if($task != ""){
	$taskArr = explode("_",$task);
	$maintask = $taskArr[0];
}else{
	//cpanel
	$maintask = "";
}
switch ($maintask){
	case "ajax":
		OsCalendarAjax::display($option,$task);
	break;
	case "form":
		OsCalendarForm::display($option,$task);
	break;
	case "customer":
		OsCalendarCustomer::display($option,$task);
	break;
	case "room":
		OsCalendarRoom::display($option,$task);
	break;
	case "price":
		OsCalendarPrice::display($option,$task);
	break;
	default:
		OsCalendarDefault::display($option,$task);
	break;
}
?>