<?php
/**
 * @package     Joomla.RAD
 * @subpackage  View
 * @author      Ossolution Team
 * @license     GNU General Public License version 2 or later; see LICENSE
 */

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use OSL\Utils\Html as HtmlUtils;

/**
 * Layout variables
 *
 * @var string $title
 * @var string $input
 * @var string $description
 */
?>

<div class="control-group">
	<div class="control-label">
		<?php
			if (strlen($description) > 0)
			{
				echo HtmlUtils::getFieldLabel('', Text::_($title), Text::_($description));
			}
			else
			{
				echo Text::_($title);
			}
		?>
	</div>
	<div class="controls">
		<?php echo $input; ?>
	</div>
</div>