<?php
/*------------------------------------------------------------------------
# showcase.php - mod_ospropertyrandom
# ------------------------------------------------------------------------
# author    Dang Thuc Dam
# copyright Copyright (C) 2025 joomdonation.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/

defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

$moduleId = 'osp-showcase-' . $module->id;
?>

<div class="osp-showcase-wrapper osp-showcase-mobile-optimized" id="<?php echo $moduleId; ?>">
	<div class="osp-showcase-container">
		<div class="osp-showcase-grid">
			<?php
			$k = 0;
			foreach ($properties as $property) {
				$itemid = modOSpropertyramdomHelper::getItemid($property->id);
				
				if($property->photo != '') {
					$propertyLink = Route::_('index.php?option=com_osproperty&task=property_details&id='.$property->id.'&Itemid='.$itemid);
					?>
					
					<article class="osp-showcase-card" id="osp-showcase-card-<?php echo $property->id; ?>">
						<a href="<?php echo $propertyLink; ?>" 
						   class="osp-showcase-card-link" 
						   title="<?php echo htmlspecialchars($property->pro_name); ?>"
						   aria-label="<?php echo htmlspecialchars($property->pro_name); ?>">
							
							<!-- Image Container -->
							<div class="osp-showcase-image-wrapper">
								<?php OSPHelper::showPropertyPhoto($property->photo,'medium',$property->id,'','','',0); ?>
								
								<!-- Gradient Overlay -->
								<div class="osp-showcase-overlay"></div>
								
								<!-- Badges -->
								<div class="osp-showcase-badges">
									<?php if($property->isFeatured == 1): ?>
										<span class="osp-showcase-badge osp-showcase-badge-featured">
											<svg class="osp-showcase-badge-icon" viewBox="0 0 24 24" fill="currentColor">
												<path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
											</svg>
											<?php echo Text::_('OS_FEATURED'); ?>
										</span>
									<?php endif; ?>
									
									<?php if(($configClass['active_market_status'] == 1) && ($property->isSold > 0)): ?>
										<span class="osp-showcase-badge osp-showcase-badge-status">
											<?php echo OSPHelper::returnMarketStatus($property->isSold); ?>
										</span>
									<?php endif; ?>
									
									<?php if($show_type == 1): ?>
										<span class="osp-showcase-badge osp-showcase-badge-type">
											<?php echo OSPHelper::loadTypeName($property->pro_type); ?>
										</span>
									<?php endif; ?>
								</div>
							</div>
							
							<!-- Content Overlay -->
							<div class="osp-showcase-content">
								<div class="osp-showcase-content-inner">
									
									<!-- Title -->
									<h3 class="osp-showcase-title">
										<?php
										if($property->ref != "" && $configClass['show_ref'] == 1) {
											echo '<span class="osp-showcase-ref">' . htmlspecialchars($property->ref) . '</span> ';
										}
										
										$arr_title_word = explode(' ', $property->pro_name);
										if (!$limit_title_word || $limit_title_word > count($arr_title_word)) {
											echo htmlspecialchars($property->pro_name);
										} else {
											$tmp_title = [];
											for ($i=0; $i < $limit_title_word; $i++) {
												$tmp_title[] = $arr_title_word[$i];
												if ($i > 2*count($arr_title_word)/3 && stristr($arr_title_word[$i],'.')) break;
											}
											echo htmlspecialchars(implode(' ', $tmp_title)) . '...';
										}
										?>
									</h3>
									
									<!-- Price -->
									<?php if ($show_price): ?>
										<div class="osp-showcase-price">
											<?php
											$priceText = OSPHelper::getLanguageFieldValue($property,'price_text');
											if($priceText != "") {
												echo OSPHelper::showPriceText($priceText);
											} elseif($property->price_call == 1) {
												echo Text::_('OSPROPERTY_CALL_FOR_PRICE');
											} else {
												if($property->price > 0) {
													echo OSPHelper::generatePrice($property->curr, $property->price);
												}
												if($property->rent_time != "") {
													echo ' <span class="osp-showcase-price-period">/' . Text::_($property->rent_time) . '</span>';
												}
											}
											?>
										</div>
									<?php endif; ?>
									
									<!-- Property Features -->
									<?php
									$features = [];
									
									if(($show_bedrooms == 1) && ($property->bed_room > 0)) {
										$features[] = '<span class="osp-showcase-feature" title="' . Text::_('Bedrooms') . '">
											<svg class="osp-showcase-feature-icon" viewBox="0 0 24 24" fill="currentColor">
												<path d="M7 13c1.66 0 3-1.34 3-3S8.66 7 7 7s-3 1.34-3 3 1.34 3 3 3zm12-6h-8v7H3V5H1v15h2v-3h18v3h2v-9c0-2.21-1.79-4-4-4z"/>
											</svg>
											<span class="osp-showcase-feature-value">' . $property->bed_room . '</span>
											<span class="osp-showcase-feature-label">bd</span>
										</span>';
									}
									
									if(($show_bathrooms == 1) && ($property->bath_room > 0)) {
										$features[] = '<span class="osp-showcase-feature" title="' . Text::_('Bathrooms') . '">
											<svg class="osp-showcase-feature-icon" viewBox="0 0 24 24" fill="currentColor">
												<path d="M20 2H4c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zM7 3c1.1 0 2 .9 2 2s-.9 2-2 2-2-.9-2-2 .9-2 2-2zm13 17H4v-2h16v2zm0-5H4V8h16v7z"/>
											</svg>
											<span class="osp-showcase-feature-value">' . OSPHelper::showBath($property->bath_room) . '</span>
											<span class="osp-showcase-feature-label">ba</span>
										</span>';
									}
									
									if(($show_parking == 1) && ($property->parking != "")) {
										$features[] = '<span class="osp-showcase-feature" title="' . Text::_('Parking') . '">
											<svg class="osp-showcase-feature-icon" viewBox="0 0 24 24" fill="currentColor">
												<path d="M13 3H6v18h4v-6h3c3.31 0 6-2.69 6-6s-2.69-6-6-6zm.2 8H10V7h3.2c1.1 0 2 .9 2 2s-.9 2-2 2z"/>
											</svg>
											<span class="osp-showcase-feature-value">' . $property->parking . '</span>
											<span class="osp-showcase-feature-label">pa</span>
										</span>';
									}
									
									if(($show_square == 1) && ($property->square_feet > 0)) {
										$features[] = '<span class="osp-showcase-feature" title="' . Text::_('Square Feet') . '">
											<svg class="osp-showcase-feature-icon" viewBox="0 0 24 24" fill="currentColor">
												<path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V5h14v14z"/>
											</svg>
											<span class="osp-showcase-feature-value">' . OSPHelper::showSquare($property->square_feet) . '</span>
											<span class="osp-showcase-feature-label">' . OSPHelper::showSquareSymbol() . '</span>
										</span>';
									}
									
									if(count($features) > 0):
									?>
										<div class="osp-showcase-features">
											<?php echo implode('', $features); ?>
										</div>
									<?php endif; ?>
									
									<!-- Address (Optional) -->
									<?php if ($show_address && $property->show_address == 1): ?>
										<div class="osp-showcase-address">
											<svg class="osp-showcase-address-icon" viewBox="0 0 24 24" fill="currentColor">
												<path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"/>
											</svg>
											<span><?php echo OSPHelper::generateAddress($property); ?></span>
										</div>
									<?php endif; ?>
									
								</div>
							</div>
							
							<!-- Hover View More Button -->
							<div class="osp-showcase-hover-action">
								<span class="osp-showcase-view-btn">
									<?php echo Text::_('View Details'); ?>
									<svg class="osp-showcase-arrow-icon" viewBox="0 0 24 24" fill="currentColor">
										<path d="M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8z"/>
									</svg>
								</span>
							</div>
							
						</a>
					</article>
					
				<?php
				}
			}
			?>
		</div>
	</div>
</div>
