<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Plugin\Content\HelpdeskPro\Extension;

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\DispatcherInterface;
use Joomla\Event\Event;
use Joomla\Event\SubscriberInterface;
use OSL\Container\Container;
use OSL\Controller\Controller;
use OSL\Input\Input;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;

defined('_JEXEC') or die;


class HelpdeskPro extends CMSPlugin implements SubscriberInterface
{
	public function __construct(
		DispatcherInterface $dispatcher,
		array $config,
		CMSApplicationInterface $application
	) {
		parent::__construct($dispatcher, $config);

		$this->setApplication($application);
	}


	/**
	 * Returns an array of events this subscriber will listen to.
	 *
	 * @return array
	 *
	 */
	public static function getSubscribedEvents(): array
	{
		return [
			'onContentPrepare' => 'onContentPrepare',
		];
	}

	/**
	 * Prepare content
	 *
	 * @param   Event  $event
	 *
	 * @return void
	 */
	public function onContentPrepare(Event $event): void
	{
		[$context, $article, $params, $limitstart] = array_values($event->getArguments());

		$app = $this->getApplication();

		if ($app->getName() != 'site')
		{
			return;
		}

		if (!str_contains($article->text, '{helpdeskpro'))
		{
			return;
		}

		$regex = '#{helpdeskpro}#s';

		$article->text = preg_replace_callback($regex, [&$this, 'displaySubmitTicketForm'], $article->text);
	}

	/**
	 * Replace callback function
	 *
	 * @param   array  $matches
	 *
	 * @return string
	 */
	private function displaySubmitTicketForm($matches): string
	{
		// Bootstrap the component libraries
		require_once JPATH_ADMINISTRATOR . '/components/com_helpdeskpro/init.php';

		// Get component config data
		$config = require JPATH_ADMINISTRATOR . '/components/com_helpdeskpro/config.php';

		// Creating component container
		$container = Container::getInstance('com_helpdeskpro', $config);

		$defaultCategoryId = $this->params->get('default_category_id', 0);

		// Generate new input for the container to pass it to controller
		$Itemid = HelpdeskProHelper::getItemid();
		$input  = new Input(['view' => 'ticket', 'layout' => 'form', 'Itemid' => $Itemid]);

		if ($defaultCategoryId > 0)
		{
			$input->set('category_id', $defaultCategoryId);
		}

		// Load component language
		HelpdeskProHelper::loadLanguage();

		// Create the Controller and Execute the request
		$controller = Controller::getInstance($container);

		$oldInput = $controller->setInput($input);

		ob_start();

		$controller->execute();

		$controller->setInput($oldInput);

		return '<div class="clearfix"></div>' . ob_get_clean();
	}
}