<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Plugin\HelpdeskPro\PreReply\Extension;

use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Database\DatabaseInterface;
use Joomla\Event\DispatcherInterface;
use Joomla\Event\Event;
use Joomla\Event\SubscriberInterface;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;

defined('_JEXEC') or die;


class PreReply extends CMSPlugin implements SubscriberInterface
{
	use DatabaseAwareTrait;

	/**
	 * The application object. This is added here for backward compatible purpose
	 *
	 * @var CMSApplication
	 */
	protected $app;

	public function __construct(
		DispatcherInterface $dispatcher,
		array $config,
		CMSApplicationInterface $application,
		DatabaseInterface $db
	) {
		parent::__construct($dispatcher, $config);

		$this->setApplication($application);
		$this->setDatabase($db);
	}


	/**
	 * Returns an array of events this subscriber will listen to.
	 *
	 * @return array
	 *
	 */
	public static function getSubscribedEvents(): array
	{
		return [
			'onViewTicket' => 'onViewTicket',
		];
	}

	/**
	 * Display list of pre-defined reply to allow adding to the ticket response
	 *
	 * @param   Event  $event
	 *
	 * @return void
	 */
	public function onViewTicket(Event $event): void
	{
		$role = HelpdeskProHelper::getUserRole();

		if ($role == 'user')
		{
			return;
		}

		[$row] = array_values($event->getArguments());

		$db    = $this->getDatabase();
		$query = $db->getQuery(true)
			->select('id AS value, title AS text')
			->from('#__helpdeskpro_replies')
			->whereIn('category_id', [0, (int) $row->category_id])
			->where('published = 1')
			->order('ordering');
		$db->setQuery($query);
		$rowReplies = $db->loadObjectList();

		if (!count($rowReplies))
		{
			return;
		}

		ob_start();

		require PluginHelper::getLayoutPath('helpdeskpro', 'prereply');

		$output = ob_get_clean();

		HelpdeskProHelper::addEventListenerResult($event, $output);
	}
}