<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2012 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Uri\Uri;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;

class plgInstallerHelpdeskPro extends CMSPlugin
{
	public function onInstallerBeforePackageDownload(&$url, &$headers)
	{
		$uri = Uri::getInstance($url);

		$host       = $uri->getHost();
		$validHosts = ['joomdonation.com', 'www.joomdonation.com'];

		if (!in_array($host, $validHosts))
		{
			return true;
		}

		$documentId = $uri->getVar('document_id');

		if ($documentId != 67)
		{
			return true;
		}

		if (!file_exists(JPATH_ADMINISTRATOR . '/components/com_helpdeskpro/init.php'))
		{
			return true;
		}

		// Get Download ID and append it to the URL
		require_once JPATH_ADMINISTRATOR . '/components/com_helpdeskpro/init.php';
		require_once JPATH_ROOT . '/components/com_helpdeskpro/Helper/Helper.php';

		$config = HelpdeskProHelper::getConfig();

		// Append the Download ID to the download URL
		if (!empty($config->download_id))
		{
			$uri->setVar('download_id', $config->download_id);
			$url = $uri->toString();

			// Append domain to URL for logging
			$siteUri = Uri::getInstance();
			$uri->setVar('domain', $siteUri->getHost());

			$uri->setVar('version', HelpdeskProHelper::getInstalledVersion());
			$uri->setVar('php_version', PHP_VERSION);
			$uri->setVar('joomla_version', JVERSION);
			
			$url = $uri->toString();
		}

		return true;
	}
}
