<?php
/**
 * 4LOGS
 *
 * @author       Yannick Gaultier - Weeblr llc
 * @copyright    Copyright Weeblr llc - 2021
 * @package      4LOGS
 * @license      GNU General Public License version 3; see LICENSE.md
 * @version      1.1.2.217
 * @date        2021-08-20
 */

use Joomla\CMS\Language\Text;
use Joomla\CMS\Form;

defined('_JEXEC') or die;

/**
 * Form Field class for the Joomla Platform.
 * Supports a generic list of options.
 *
 * @package     Joomla.Platform
 * @subpackage  Form
 */
class JFormFieldWbspacer extends Form\FormField
{
	/**
	 * The form field type.
	 *
	 * @var    string
	 */
	protected $type = 'wbspacer';

	public function getInput()
	{
		$class = 'wbspacer';
		if (!empty($this->element['class']))
		{
			$class .= ' ' . $this->element['class'];
		}
		$html   = array();
		$html[] = '<h3 class="' . $class . '">' . Text::_($this->element['label']) . '</h3>';

		return implode("\n", $html);
	}

	public function getLabel()
	{
		return '';
	}
}
