<?php
/**
 * @package     Ardhs
 * @subpackage  com_ardhs
 *
 * @author      Abdul waheed <info@abdulwaheed.pk>
 * @website		www.abdulwaheed.pk
 * @copyright   Copyright (C) abdulwaheed.pk All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Abdul\Component\Ardhs\Administrator\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\MVC\Controller\AdminController;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;


/**
 * Ardhs list controller class.
 *
 * @since  1.6
 */
class PropsController extends AdminController
{
	public function __construct($config = [], $factory = null, $app = null, $input = null)
    {
        parent::__construct($config, $factory, $app, $input);
		$this->registerTask( 'unpublish'  , 	'unpublish' );

    }
	/**
	 * Proxy for getModel.
	 *
	 * @param   string  $name    The model name. Optional.
	 * @param   string  $prefix  The class prefix. Optional.
	 * @param   array   $config  The array of possible config values. Optional.
	 *
	 * @return  \Joomla\CMS\MVC\Model\BaseDatabaseModel
	 *
	 * @since   1.6
	 */
	public function getModel($name = 'Ardhs', $prefix = 'Administrator', $config = array('ignore_request' => true))
	{
		return parent::getModel($name, $prefix, $config);
	}


    /**
     * Remove all associated data with for the user name
     *
     * @param   array    $bldg_id
     */
   
	
	public function delete()	{

		$app = Factory::getApplication();
		$input = $app->input;
		$cids= $input->get('cid', '', 'array');
		$db = Factory::getDBO();
		$q1="DELETE FROM #__ardh_properties  where id in(".implode(",",$cids).")";
//	echo $q1;exit;
        try {
            $db->setQuery($q1)->execute();
			$msg="Record(s) deleted successfully.";
        } catch (ExecutionFailureException $e) {
            // Do nothing.
			$msg="Error with following query <br /> $q1".$e;
		}
//		echo $msg;exit;
		
		$this->setRedirect( 'index.php?option=com_ardhs&view=props',$msg);
		return true;
	}

}