<?php
/**
* ChronoForms 8
* Copyright (c) 2023 ChronoEngine.com, All rights reserved.
* Author: (ChronoEngine.com Team)
* license:     GNU General Public License version 2 or later; see LICENSE.txt
* Visit http://www.ChronoEngine.com for regular updates and information.
**/
defined('_JEXEC') or die('Restricted access');

$model = new ChronoModel();
?>

<form class="nui form" action="<?php echo ChronoApp::$instance->current_url; ?>" method="post" enctype="multipart/form-data" accept-charset="UTF-8">
<?php
	Chrono::loadAsset("/assets/ace.min.js");
	new MenuBar(title: "Run SQL", buttons: [
		new MenuButton(name: "save", title: "Run", icon: "play", color: "blue"),
		new MenuButton(name: "close", link: true, title: "Close", icon: "xmark", color: "red", url: "action=ma.tables"),
	]);
	new FormField(name: "sql", type:"textarea", label: "SQL code", rows:20, hint:"The SQL code to run.", code:"data-codeeditor='1'");
?>
</form>
<?php

if (ChronoApp::$instance->isPost && !empty($this->data("sql"))) {
	$sql = $this->data("sql");

	if(str_starts_with(strtolower($sql), "select ") || str_starts_with(strtolower($sql), "show ")){
		$rows = $model->Select(sql:$sql);

		if (!empty($rows)) {
			ChronoSession::setFlash("success", Chrono::l("Query executed successfully."));
		}

		$columns = [];
		if(!empty($rows)){
			foreach($rows[0] as $k => $v){
				$columns[] = new TableColumn(name:$k, title:$k);
			}

			new DataTable($rows, $columns, wide:true);
		}
		
	}else{
		$result = $model->Execute($sql);

		if ($result === true) {
			ChronoSession::setFlash("success", Chrono::l("Query executed successfully."));
		}else{
			ChronoSession::setFlash("error", Chrono::l("Error updating table"));
		}
	}
}
?>