<?php

/**
 * @package         Convert Forms
 * @version         5.1.0 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            https://www.tassos.gr
 * @copyright       Copyright © 2024 Tassos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Button\PublishedButton;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Uri\Uri;

$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn  = $this->escape($this->state->get('list.direction'));

$user    = Factory::getUser();
$columns = $this->state->get('filter.columns');

$doc = Factory::getDocument();

$doc->addStyleDeclaration('
    .js-stools .js-stools-container-filters .chzn-container.active:not(.chzn-with-drop) .chzn-single {
        border: 1px solid rgba(0,0,0,0.2);
    }
    .js-stools .js-stools-container-filters .chzn-container.active .chzn-single {
        border: 1px solid #2384D3;
    }
');

$doc->addScriptDeclaration('
document.addEventListener("DOMContentLoaded", function() {
    Joomla.submitbutton = function(task) {
        let form = document.getElementById("adminForm");
        Joomla.submitform(task, form);
        
        // Since the export runs in the background and without reloading the page we need to manually reset the task input.
        if (task == "conversions.export") {
            form.task.value = "";
        }
    }
});
');
?>
<form action="<?php echo Route::_('index.php?option=com_convertforms&view=conversions'); ?>" class="clearfix" method="post" name="adminForm" id="adminForm">
    <div id="j-main-container">
    <?php
        echo LayoutHelper::render('joomla.searchtools.default', array('view' => $this));
    ?>

    <table class="adminlist nrTable scroll table">
        <thead>
            <tr>
                <th width="2%" class="center"><?php echo HTMLHelper::_('grid.checkall'); ?></th>
                <th width="3%" class="nowrap hidden-phone" align="center">
                    <?php echo HTMLHelper::_('searchtools.sort', 'JSTATUS', 'a.state', $listDirn, $listOrder); ?>
                </th>
                <?php foreach ($columns as $key => $column) { ?>
                    <th class="nowrap col_<?php echo $column; ?>">
                        <?php 
                            $isParam = (strpos($column, 'param_') !== false);
                            $columnLabel = $isParam ? ucfirst(str_replace('param_', '', $column)) : 'COM_CONVERTFORMS_' . strtoupper($column);

                            // Temporary workaround to translate the Submission Notes option
                            if ($column == 'param_leadnotes')
                            {
                                $columnLabel = Text::_('COM_CONVERTFORMS_NOTES');
                            }

                            echo HTMLHelper::_('searchtools.sort', $columnLabel, 'a.' . $column, $listDirn, $listOrder); 
                        ?>
                    </th>                            
                <?php } ?>
            </tr>
        </thead>
        <tbody>
            <?php if (count($this->items)) { ?>
                <?php foreach($this->items as $i => $item): ?>
                    <?php 
                        $canChange = $user->authorise('core.edit.state', 'com_convertforms.conversion.' . $item->id);
                        $canEdit   = $user->authorise('core.edit',       'com_convertforms.conversion.' . $item->id);
                    ?>
                    <tr class="row<?php echo $i % 2; ?> <?php echo isset($item->params->sync_error) ? 'error' : '' ?>">
                        <td class="center"><?php echo HTMLHelper::_('grid.id', $i, $item->id); ?></td>
                        <td class="text-center">
                            <?php
                                $options = [
                                    'task_prefix' => 'conversions.',
                                    'disabled' => !$canChange,
                                    'id' => 'state-' . $item->id
                                ];

                                echo (new PublishedButton)->render((int) $item->state, $i, $options);
                            ?>
                        </td>
                        <?php $i = 0; foreach ($columns as $key => $column) { 
                                // Convert to lower case to always match the field in case it has been renamed.
                                $column = strtolower($column);
                                $params = [];

                                if (!is_null($item->params))
                                {
                                    foreach ($item->params as $key => $value)
                                    {
                                        $params[strtolower($key)] = $value;
                                    }
                                }

                                $isParam = (strpos($column, 'param_') !== false);
                                $columnName = $isParam ? str_replace('param_', '' , $column) : $column;

                                $value = false;
                                $col_class = !$isParam ? 'nowrap col_' . $column : $column;

                                $submission_user = Factory::getUser($item->user_id);
                                $submission_user_edit_url = $submission_user->id > 0 ? Uri::base() . '/index.php?option=com_users&task=user.edit&id=' . $submission_user->id : '';
                            ?>
                            <td class="<?php echo $col_class; ?>">
                                <?php 
                                    switch ($columnName)
                                    {
                                        case 'id':
                                            if ($canEdit)
                                            {
                                                $url = Route::_('index.php?option=com_convertforms&task=conversion.edit&id=' . $item->id);
                                                $value = '<a href="' . $url . '">' . $item->$columnName . '</a>';
                                            } else 
                                            {
                                                $value = $item->$columnName;
                                            }

                                            break;
                                        case 'user_username':
                                            if ($item->user_id > 0)
                                            {
                                                $value = '<a href="' . $submission_user_edit_url . '">' . $submission_user->username . '</a>';
                                            }
                                            break;
                                            
                                        case 'user_id':
                                            $value = '';

                                            if ($item->user_id > 0)
                                            {
                                                $value = '<a href="' . $submission_user_edit_url . '">' . $submission_user->id . '</a>';       
                                            }
                                            break;

                                        // Temporary workaround to get the value of a fake param field
                                        case 'leadnotes':
                                            $value = isset($item->params->leadnotes) ? $item->params->leadnotes : '';
                                            break;

                                        default:
                                            if ($isParam)
                                            {
                                                if (isset($item->prepared_fields[$columnName]))
                                                {
                                                    $value = $item->prepared_fields[$columnName]->value_html;
                                                }
                                            } else 
                                            {
                                                if (isset($item->$columnName))
                                                {
                                                    $value = $item->$columnName;
                                                }
                                            }
                                            break;
                                    }
                                ?>

                                <?php echo $value; ?>

                                <?php if ($i == 0 && isset($item->params->sync_service) && isset($item->params->sync_error) && $key == 0) { ?>
                                    <span class="hasPopover icon icon-info" 
                                        data-placement="top"
                                        data-title="<?php echo Text::_("PLG_CONVERTFORMS_" . $item->params->sync_service . "_ALIAS"); ?>"
                                        data-content="<?php echo $item->params->sync_error ?>"
                                        style="color:red;">
                                    </span>
                                <?php } ?>

                                <?php $i++; ?>
                            </td>                            
                        <?php } ?>
                    </tr>
                <?php endforeach; ?>  
            <?php } else { ?>
                <tr>
                    <td align="center" colspan="<?php echo count($columns) + 2 ?>">
                        <div align="center">
                            <?php echo ConvertForms\Helper::noItemsFound(); ?>
                        </div>
                    </td>
                </tr>
            <?php } ?>  
        </tbody>
    </table>

        <div class="pagination"><?php echo $this->pagination->getListFooter(); ?></div>

        <div>
            <input type="hidden" name="task" value="" />
            <input type="hidden" name="boxchecked" value="0" />
            <?php echo HTMLHelper::_('form.token'); ?>
        </div>
    </div>
</form>
<?php include_once(JPATH_COMPONENT_ADMINISTRATOR . '/layouts/footer.php'); ?>