<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

$rootUri = Uri::root();

echo HTMLHelper::_('uitab.addTab', 'email', 'translation-page', Text::_('HDP_TRANSLATION', true));
echo HTMLHelper::_('uitab.startTabSet', 'email-translation', ['active' => 'translation-page-'.$this->languages[0]->sef]);

foreach ($this->languages as $language)
{
	$sef = $language->sef;
	echo HTMLHelper::_('uitab.addTab', 'email-translation', 'translation-page-' . $sef, $language->title . ' <img src="' . $rootUri . '/media/mod_languages/images/' . $language->image . '.gif" />');
	?>
    <div class="control-group">
        <div class="control-label">
			<?php echo Text::_('HDP_NEW_TICKET_ADMIN_EMAIL_SUBJECT'); ?>
        </div>
        <div class="controls">
			<?php
			$fieldName = 'new_ticket_admin_email_subject_' . $sef;
			?>
            <input type="text" name="<?php echo $fieldName; ?>" class="input-xxlarge form-control"
                   value="<?php echo $this->item->{$fieldName}; ?>" size="50"/>
        </div>
    </div>
    <div class="control-group">
        <div class="control-label">
			<?php echo Text::_('HDP_NEW_TICKET_ADMIN_EMAIL_BODY'); ?>
        </div>
        <div class="controls">
			<?php $fieldName = 'new_ticket_admin_email_body_' . $sef; ?>
			<?php echo $editor->display($fieldName, $this->item->{$fieldName}, '100%', '350', '75', '8'); ?>
        </div>
    </div>
    <div class="control-group">
        <div class="control-label">
			<?php echo Text::_('HDP_NEW_TICKET_USER_EMAIL_SUBJECT'); ?>
        </div>
        <div class="controls">
			<?php $fieldName = 'new_ticket_user_email_subject_' . $sef; ?>
            <input type="text" name="<?php echo $fieldName; ?>" class="input-xxlarge form-control"
                   value="<?php echo $this->item->{$fieldName}; ?>" size="50"/>
        </div>
    </div>
    <div class="control-group">
        <div class="control-label">
			<?php echo Text::_('HDP_NEW_TICKET_USER_EMAIL_BODY'); ?>
        </div>
        <div class="controls">
			<?php $fieldName = 'new_ticket_user_email_body_' . $sef; ?>
			<?php echo $editor->display($fieldName, $this->item->{$fieldName}, '100%', '350', '75', '8'); ?>
        </div>
    </div>
    <div class="control-group">
        <div class="control-label">
			<?php echo Text::_('HDP_TICKET_UPDATED_ADMIN_EMAIL_SUBJECT'); ?>
        </div>
        <div class="controls">
			<?php $fieldName = 'ticket_updated_admin_email_subject_' . $sef; ?>
            <input type="text" name="<?php echo $fieldName; ?>" class="input-xxlarge form-control"
                   value="<?php echo $this->item->{$fieldName}; ?>" size="50"/>
        </div>
    </div>
    <div class="control-group">
        <div class="control-label">
			<?php echo Text::_('HDP_TICKET_UPDATED_ADMIN_EMAIL_BODY'); ?>
        </div>
        <div class="controls">
			<?php $fieldName = 'ticket_updated_admin_email_body_' . $sef; ?>
			<?php echo $editor->display($fieldName, $this->item->{$fieldName}, '100%', '350', '75', '8'); ?>
        </div>
    </div>
    <div class="control-group">
        <div class="control-label">
			<?php echo Text::_('HDP_TICKET_UPDATED_USER_EMAIL_SUBJECT'); ?>
        </div>
        <div class="controls">
			<?php $fieldName = 'ticket_updated_user_email_subject_' . $sef; ?>
            <input type="text" name="<?php echo $fieldName; ?>" class="input-xxlarge form-control"
                   value="<?php echo $this->item->{$fieldName}; ?>" size="50"/>
        </div>
    </div>
    <div class="control-group">
        <div class="control-label">
			<?php echo Text::_('HDP_TICKET_UPDATED_USER_EMAIL_BODY'); ?>
        </div>
        <div class="controls">
			<?php $fieldName = 'ticket_updated_user_email_body_' . $sef; ?>
			<?php echo $editor->display($fieldName, $this->item->{$fieldName}, '100%', '350', '75', '8'); ?>
        </div>
    </div>
	<div class="control-group">
		<div class="control-label">
			<?php echo Text::_('HDP_INTERNAL_COMMENT_ADDED_EMAIL_SUBJECT'); ?>
		</div>
		<div class="controls">
			<?php $fieldName = 'internal_comment_added_email_subject_' . $sef; ?>
			<input type="text" name="<?php echo $fieldName; ?>" class="input-xxlarge form-control"
			       value="<?php echo $this->item->{$fieldName}; ?>" size="50"/>
		</div>
	</div>
	<div class="control-group">
		<div class="control-label">
			<?php echo Text::_('HDP_INTERNAL_COMMENT_ADDED_EMAIL_BODY'); ?>
		</div>
		<div class="controls">
			<?php $fieldName = 'internal_comment_added_email_body_' . $sef; ?>
			<?php echo $editor->display($fieldName, $this->item->{$fieldName}, '100%', '350', '75', '8'); ?>
		</div>
	</div>
    <div class="control-group">
        <div class="control-label">
			<?php echo Text::_('HDP_TICKET_ASSIGN_EMAIL_SUBJECT'); ?>
        </div>
        <div class="controls">
			<?php $fieldName = 'ticket_assiged_email_subject_' . $sef; ?>
            <input type="text" name="<?php echo $fieldName; ?>" class="input-xxlarge form-control"
                   value="<?php echo $this->item->{$fieldName}; ?>" size="50"/>
        </div>
    </div>
    <div class="control-group">
        <div class="control-label">
			<?php echo Text::_('HDP_TICKET_ASSIGN_EMAIL_BODY'); ?>
        </div>
        <div class="controls">
			<?php $fieldName = 'ticket_assiged_email_body_' . $sef; ?>
			<?php echo $editor->display($fieldName, $this->item->{$fieldName}, '100%', '350', '75', '8'); ?>
        </div>
    </div>
    <div class="control-group">
        <div class="control-label">
			<?php echo Text::_('HDP_CUSTOMER_TICKET_ASSIGN_EMAIL_SUBJECT'); ?>
        </div>
        <div class="controls">
			<?php $fieldName = 'customer_ticket_assigned_email_subject_' . $sef; ?>
            <input type="text" name="<?php echo $fieldName; ?>" class="input-xxlarge form-control"
                   value="<?php echo $this->item->{$fieldName}; ?>" size="50"/>
        </div>
    </div>
    <div class="control-group">
        <div class="control-label">
			<?php echo Text::_('HDP_CUSTOMER_TICKET_ASSIGN_EMAIL_BODY'); ?>
        </div>
        <div class="controls">
			<?php $fieldName = 'customer_ticket_assigned_email_body_' . $sef; ?>
			<?php echo $editor->display($fieldName, $this->item->{$fieldName}, '100%', '350', '75', '8'); ?>
        </div>
    </div>
    <div class="control-group">
        <div class="control-label">
			<?php echo Text::_('HDP_CUSTOMER_TICKET_CLOSED_EMAIL_SUBJECT'); ?>
        </div>
        <div class="controls">
			<?php $fieldName = 'customer_ticket_closed_email_subject_' . $sef; ?>
            <input type="text" name="<?php echo $fieldName; ?>" class="input-xxlarge form-control"
                   value="<?php echo $this->item->{$fieldName}; ?>" size="50"/>
        </div>
    </div>
    <div class="control-group">
        <div class="control-label">
			<?php echo Text::_('HDP_CUSTOMER_TICKET_CLOSED_EMAIL_BODY'); ?>
        </div>
        <div class="controls">
			<?php $fieldName = 'customer_ticket_closed_email_body_' . $sef; ?>
			<?php echo $editor->display($fieldName, $this->item->{$fieldName}, '100%', '350', '75', '8'); ?>
        </div>
    </div>
    <div class="control-group">
        <div class="control-label">
			<?php echo Text::_('HDP_MANAGER_TICKET_CLOSED_EMAIL_SUBJECT'); ?>
        </div>
        <div class="controls">
			<?php $fieldName = 'manager_ticket_closed_email_subject_' . $sef; ?>
            <input type="text" name="<?php echo $fieldName; ?>" class="input-xxlarge form-control"
                   value="<?php echo $this->item->{$fieldName}; ?>" size="50"/>
        </div>
    </div>
    <div class="control-group">
        <div class="control-label">
			<?php echo Text::_('HDP_MANAGER_TICKET_CLOSED_EMAIL_BODY'); ?>
        </div>
        <div class="controls">
			<?php $fieldName = 'manager_ticket_closed_email_body_' . $sef; ?>
			<?php echo $editor->display($fieldName, $this->item->{$fieldName}, '100%', '350', '75', '8'); ?>
        </div>
    </div>
    <div class="control-group">
        <div class="control-label">
			<?php echo Text::_('HDP_CUSTOMER_TICKET_STATUS_CHANGED_EMAIL_SUBJECT'); ?>
        </div>
        <div class="controls">
			<?php $fieldName = 'customer_ticket_status_changed_email_subject_' . $sef; ?>
            <input type="text" name="<?php echo $fieldName; ?>" class="input-xxlarge form-control"
                   value="<?php echo $this->item->{$fieldName}; ?>" size="50"/>
        </div>
    </div>
    <div class="control-group">
        <div class="control-label">
			<?php echo Text::_('HDP_CUSTOMER_TICKET_STATUS_CHANGED_EMAIL_BODY'); ?>
        </div>
        <div class="controls">
			<?php $fieldName = 'customer_ticket_status_changed_email_body_' . $sef; ?>
			<?php echo $editor->display($fieldName, $this->item->{$fieldName}, '100%', '350', '75', '8'); ?>
        </div>
    </div>
    <div class="control-group">
        <div class="control-label">
			<?php echo Text::_('HDP_MANAGER_TICKET_STATUS_CHANGED_EMAIL_SUBJECT'); ?>
        </div>
        <div class="controls">
			<?php $fieldName = 'manager_ticket_status_changed_email_subject_' . $sef; ?>
            <input type="text" name="<?php echo $fieldName; ?>" class="input-xxlarge form-control"
                   value="<?php echo $this->item->{$fieldName}; ?>" size="50"/>
        </div>
    </div>
    <div class="control-group">
        <div class="control-label">
			<?php echo Text::_('HDP_MANAGER_TICKET_STATUS_CHANGED_EMAIL_BODY'); ?>
        </div>
        <div class="controls">
			<?php $fieldName = 'manager_ticket_status_changed_email_body_' . $sef; ?>
			<?php echo $editor->display($fieldName, $this->item->{$fieldName}, '100%', '350', '75', '8'); ?>
        </div>
    </div>
	<?php
	echo HTMLHelper::_('uitab.endTab');
}

echo HTMLHelper::_('uitab.endTabSet');
echo HTMLHelper::_('uitab.endTab');