<?php
/**
 * Supports a custom field which display a heading
 *
 * @package     Joomla.HDP
 * @subpackage  Form
 */

class HDPFormFieldHeading extends HDPFormField
{
	/**
	 * The form field type.
	 *
	 * @var    string
	 *
	 */
	protected $type = 'Heading';

	/**
	 * Method to get the field input markup.
	 *
	 * @param   HelpdeskProHelperBootstrap  $bootstrapHelper
	 *
	 * @return  string  The field input markup.
	 *
	 */
	protected function getInput($bootstrapHelper = null)
	{
		$controlGroupAttributes = 'id="field_' . $this->id . '"';

		if (!$this->visible)
		{
			$controlGroupAttributes .= ' style="display:none;" ';
		}

		$data = [
			'controlGroupAttributes' => $controlGroupAttributes,
			'title'                  => $this->title,
			'row'                    => $this->row,
		];

		return HelpdeskProHelperHtml::loadCommonLayout('fieldlayout/heading.php', $data);
	}

	/**
	 * Get control group used to display on form
	 *
	 * @param   bool                        $tableLess
	 * @param   HelpdeskProHelperBootstrap  $bootstrapHelper
	 *
	 * @return string
	 */
	public function getControlGroup($tableLess = true, $bootstrapHelper = null)
	{
		return $this->getInput();
	}

	/**
	 * Get output used for displaying on email and the detail page
	 *
	 * @param   bool                        $tableLess
	 * @param   HelpdeskProHelperBootstrap  $bootstrapHelper
	 *
	 * @see HDPFormField::getOutput()
	 */
	public function getOutput($tableLess = true, $bootstrapHelper = null)
	{
		if ($tableLess)
		{
			return $this->getInput();
		}

		return '<tr>' . '<td class="eb-heading" colspan="2">' . $this->title . '</td></tr>';
	}
}