<?php

/**
 * @see https://github.com/laminas/laminas-serializer for the canonical source repository
 */

declare(strict_types=1);

namespace _JchOptimizeVendor\V91\Laminas\Serializer\Adapter;

use _JchOptimizeVendor\V91\Laminas\Serializer\Exception\ExceptionInterface;

interface AdapterInterface
{
    /**
     * Generates a storable representation of a value.
     *
     * @param  mixed $value Data to serialize
     * @return string
     * @throws ExceptionInterface
     */
    public function serialize($value);
    /**
     * Creates a PHP value from a stored representation.
     *
     * @param  string $serialized Serialized string
     * @return mixed
     * @throws ExceptionInterface
     */
    public function unserialize($serialized);
}
