<?php
/*------------------------------------------------------------------------
# emails.html.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/
// no direct access
defined('_JEXEC') or die;

class HTML_OSappscheduleEmails
{
	static function emailListForm($option, $rows, $pageNav)
	{
		JToolBarHelper::title(JText::_('OS_MANAGE_EMAIL_TEMPLATES'), 'envelope');
		JToolbarHelper::editList('emails_edit');
		JToolbarHelper::publish('emails_publish');
		JToolbarHelper::unpublish('emails_unpublish');
		JToolBarHelper::cancel('goto_index');
		JToolbarHelper::custom('cpanel_list', 'featured.png', 'featured.png', JText::_('OS_DASHBOARD'), false);
?>
		<form method="POST" action="index.php" name="adminForm" id="adminForm">
			<table width="100%" class="adminlist table table-striped">
				<thead>
					<tr>
						<th width="5%" style="text-align:center;"><?php echo JText::_('#') ?></th>
						<th width="5%" style="text-align:center;">
							<input type="checkbox" name="checkall-toggle" value=""
								title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
						</th>
						<th width="40%"><?php echo JText::_('OS_MANAGE_EMAIL_KEY') ?></th>
						<th width="45"><?php echo JText::_('OS_MANAGE_EMAIL_SUBJECT') ?></th>
						<th width="5%" align="center"><?php echo JText::_('OS_PUBLISH') ?></th>
					</tr>
				</thead>
				<tfoot>
					<tr>
						<td width="100%" colspan="5" style="text-align:center;">
							<?php
							echo $pageNav->getListFooter();
							?>
						</td>
					</tr>
				</tfoot>
				<tbody>
					<?php
					$k = 0;
					for ($i = 0, $n = count($rows); $i < $n; $i++) {
						$row 		= $rows[$i];
						$checked 	= JHtml::_('grid.id', $i, $row->id);
						$link 		= JRoute::_('index.php?option=' . $option . '&task=emails_edit&cid[]=' . $row->id);
						$published 	= JHTML::_('jgrid.published', $row->published, $i, 'emails_');
					?>
						<tr class="<?php echo "row$k"; ?>">
							<td align="center" style="text-align:center;"><?php echo $pageNav->getRowOffset($i); ?></td>
							<td align="center" style="text-align:center;"><?php echo $checked; ?></td>
							<td align="left">
								<a href="<?php echo $link ?>">
									<?php echo $row->email_key; ?>
								</a>
							</td>
							<td align="left">
								<a href="<?php echo $link ?>">
									<?php echo $row->email_title; ?>
								</a>
							</td>
							<td style="text-align:center;">
								<?php echo $published; ?>
							</td>
						</tr>
					<?php
						$k = 1 - $k;
					}
					?>
				</tbody>
			</table>
			<input type="hidden" name="option" value="<?php echo $option; ?>" />
			<input type="hidden" name="task" value="emails_list" />
			<input type="hidden" name="boxchecked" value="0" />
		</form>
	<?php
	}

	static function editEmailTemplate($option, $row, $lists, $translatable)
	{
		global $languages;

		JToolBarHelper::title(JText::_('OS_EMAIL_TEMPLATE') . " [Edit]");
		JToolBarHelper::save('emails_save');
		JToolBarHelper::apply('emails_apply');
		JToolBarHelper::cancel('emails_gotolist');
		$editor = JEditor::getInstance(JFactory::getConfig()->get('editor'));
	?>
		<form method="POST" action="index.php" name="adminForm" id="adminForm">

			<?php
			if ($translatable) {
				echo JHtml::_('bootstrap.startTabSet', 'emailTabs', array('active' => 'general-page'));
				echo JHtml::_('bootstrap.addTab', 'emailTabs', 'general-page', JText::_('OS_GENERAL', true));
			}
			?>
			<table width="100%" class="admintable" style="background-color:white;">
				<tr>
					<td class="key"><?php echo JText::_('OS_KEY') ?></td>
					<td><input type="text" name="email_key" id="email_key" disabled="disabled" size="40"
							value="<?php echo $row->email_key ?>" class="input-large form-control"></td>
				</tr>
				<tr>
					<td class="key"><?php echo JText::_('OS_SUBJECT'); ?></td>
					<td><input type="text" name="email_title" id="email_title" size="40" value="<?php echo $row->email_title ?>"
							class="input-large form-control"></td>
				</tr>
				<tr>
					<td class="key"><?php echo JText::_('OS_PUBLISHED'); ?></td>
					<td><?php echo $lists['published']; ?></td>
				</tr>

				<tr>
					<td class="key" valign="top"><?php echo JText::_('OS_CONTENT'); ?></td>
					<td>
						<?php
						$editor = JEditor::getInstance(JFactory::getConfig()->get('editor'));
						echo $editor->display('email_content',  stripslashes($row->email_content), '95%', '250', '75', '20');
						?>
					</td>
				</tr>
			</table>
			<?php
			if ($translatable) {
				echo JHtml::_('bootstrap.endTab');
				echo JHtml::_('bootstrap.addTab', 'emailTabs', 'translation-page', JText::_('OS_TRANSLATION', true));
			?>
				<ul class="nav nav-tabs">
					<?php
					$i = 0;
					foreach ($languages as $language) {
						$sef = $language->sef;
					?>
						<li <?php echo $i == 0 ? 'class="active"' : ''; ?>><a href="#translation-page-<?php echo $sef; ?>"
								data-toggle="tab"><?php echo $language->title; ?>
								<img src="<?php echo JURI::root(); ?>media/com_osproperty/flags/<?php echo $sef . '.png'; ?>" /></a>
						</li>
					<?php
						$i++;
					}
					?>
				</ul>
				<div class="tab-content">
					<?php
					$i = 0;
					foreach ($languages as $language) {
						$sef = $language->sef;
					?>
						<div class="tab-pane<?php echo $i == 0 ? ' active' : ''; ?>" id="translation-page-<?php echo $sef; ?>">
							<table width="100%" class="admintable" style="background-color:white;">
								<tr>
									<td class="key"><?php echo JText::_('OS_SUBJECT'); ?></td>
									<td><input type="text" name="email_title_<?php echo $sef; ?>" id="email_title_<?php echo $sef; ?>"
											size="40" value="<?php echo $row->{'email_title_' . $sef} ?>" class="input-large"></td>
								</tr>
								<tr>
									<td class="key" valign="top"><?php echo JText::_('OS_CONTENT'); ?></td>
									<td>
										<?php
										echo $editor->display('email_content_' . $sef,  stripslashes($row->{'email_content_' . $sef}), '95%', '250', '75', '20');
										?>
									</td>
								</tr>
							</table>
						</div>
					<?php
						$i++;
					}
					?>
				</div>
				</div>
			<?php
				echo JHtml::_('bootstrap.endTab');
				echo JHtml::_('bootstrap.endTabSet');
			}
			?>
			<input type="hidden" name="option" id="option" value="<?php echo $option ?>" />
			<input type="hidden" name="task" value="" id="task" />
			<input type="hidden" name="id" value="<?php echo $row->id ?>" />
			<input type="hidden" name="boxchecked" value="0" />
		</form>
<?php
	}
}
?>