<?php
/*------------------------------------------------------------------------
# emails.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/
// no direct access
defined('_JEXEC') or die;

class OSappscheduleEmails{
	/**
	 * Default function
	 *
	 * @param unknown_type $option
	 */
	static function display($option,$task){
		global $mainframe,$languages;
		require_once(JPATH_ROOT.'/components/com_osproperty/helpers/helper.php');
		$languages = OSPHelper::getLanguages();
		require_once(JPATH_COMPONENT_ADMINISTRATOR.DS."tables".DS."emails.php");
		$mainframe = JFactory::getApplication();
		$cid = $mainframe->input->get( 'cid', array(0),'array');
		\Joomla\Utilities\ArrayHelper::toInteger($cid, array(0));
		switch ($task){
			default:
			case "emails_list":
				OSappscheduleEmails::emails_list($option);
			break;
			case "emails_edit":
				OSappscheduleEmails::email_modify($option,$cid[0]);
			break;
			case "emails_apply":
				OSappscheduleEmails::email_save($option,0);
			break;
			case "emails_save":
				OSappscheduleEmails::email_save($option,1);
			break;
			case "emails_gotolist":
				$mainframe = JFactory::getApplication();
				$mainframe->redirect("index.php?option=com_oscalendar&task=emails_list");
			break;
			case "emails_unpublish":
				OSappscheduleEmails::email_state($option,$cid,0);
			break;
			case "emails_publish":
				OSappscheduleEmails::email_state($option,$cid,1);
			break;	
		}
	}
	
	/**
	 * Email change state
	 *
	 * @param unknown_type $option
	 * @param unknown_type $cid
	 * @param unknown_type $state
	 */
	static function email_state($option,$cid,$state){
		global $mainframe;
		$db 		= JFactory::getDBO();
		if(count($cid)>0)	{
			$cids 	= implode(",",$cid);
			$db->setQuery("UPDATE #__oscalendar_emails SET `published` = '$state' WHERE id IN ($cids)");
			$db->execute();
		}
		$mainframe->enqueueMessage(JText::_("OS_ITEMS_STATUS_HAS_BEEN_CHANGED"),'message');
		OSappscheduleEmails::emails_list($option);
	}
	
	/**
	 * Emails list
	 *
	 * @param unknown_type $option
	 */
	static function emails_list($option){
		global $mainframe;
		$db = JFactory::getDbo();
		$limit = $mainframe->input->getInt('limit',20);
		$limitstart = $mainframe->input->getInt('limitstart',0);
		$query = "Select count(id) from #__oscalendar_emails";
		$db->setQuery($query);
		$total = $db->loadResult();
		
		jimport('joomla.html.pagination');
		$pageNav = new JPagination($total,$limitstart,$limit);
		
		$query = "Select * from #__oscalendar_emails";
		$db->setQuery($query,$pageNav->limitstart,$pageNav->limit);
		$rows = $db->loadObjectList();
		HTML_OSappscheduleEmails::emailListForm($option,$rows,$pageNav);
	}
	
	/**
	 * Email modify
	 *
	 * @param unknown_type $option
	 * @param unknown_type $id
	 */
	static function email_modify($option,$id){
		global $languages;
		$row = &JTable::getInstance('Emails','OsCalendarTable');
		if($id > 0){
			$row->load((int)$id);
		}else{
			$row->published = 1;
		}
		
		// creat published
		//$lists['published'] = JHTML::_('select.booleanlist', 'published', '', $row->published);
		$optionArr = array();
		$optionArr[] = JHTML::_('select.option',1,JText::_('OS_YES'));
		$optionArr[] = JHTML::_('select.option',0,JText::_('OS_NO'));
		$lists['published']   = JHTML::_('select.genericlist',$optionArr,'published','class="input-mini form-control form-select"','value','text',$row->published);
		
		$translatable = JLanguageMultilang::isEnabled() && count($languages); 	
		
		HTML_OSappscheduleEmails::editEmailTemplate($option,$row,$lists,$translatable);
	}
	
	/**
	 * Email save
	 *
	 * @param unknown_type $option
	 * @param unknown_type $save
	 */
	static function email_save($option,$save){
		global $mainframe,$languages;
		$mainframe = JFactory::getApplication();
		$row = &JTable::getInstance('Emails','OsCalendarTable');
		$post = $mainframe->input->post->getArray();
		$row->bind($post);
		$email_content = $_POST['email_content'];
		$row->email_content = $email_content;
		foreach ($languages as $language){												
			$sef = $language->sef;
			$email_content_name    		= 'email_content_'.$sef;
			$email_content_value   		= $_POST[$email_content_name];
			$row->{$email_content_name} = $email_content_value;
		}
		$row->store();
		$mainframe->enqueueMessage(JText::_('OS_EMAIL_TEMPLATE_HAS_BEEN_SAVED'));
		if($save == 1){
			$mainframe->redirect("index.php?option=$option&task=emails_list");
		}else{
			$mainframe->redirect("index.php?option=$option&task=emails_edit&cid[]=$row->id");
		}
	}
}
?>