<?php
/*------------------------------------------------------------------------
# price.html.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/
// no direct access
defined('_JEXEC') or die;

/**
 * Enter description here...
 *
 */

class HTML_OSappschedulePrice{
	/**
	 * List seasons
	 *
	 * @param unknown_type $option
	 * @param unknown_type $rows
	 * @param unknown_type $pageNav
	 */
	static function listPrices($property,$room,$rows,$pageNav,$lists){
		global $mainframe,$configClass,$cClass;
		$title = "";
		if($property->ref != ""){
			$title .= $property->ref.", ";
		}
		$title .= $property->pro_name;
        if($cClass['allow_room'] == 1){
            $title .= " > ".$room->room_name;
        }
        $title .= " > ".JText::_('OS_MANAGE_PRICE');
		JToolbarHelper::title($title);
		JToolbarHelper::addNew('price_addnew');
		JToolbarHelper::editList('price_edit');
		JToolbarHelper::deleteList(JText::_('OS_ARE_YOU_SURE_TO_REMOVE_ITEM'),'price_remove');
        if($cClass['allow_room'] == 1) {
            JToolbarHelper::cancel('price_cancel', JText::_('OS_GO_ROOMS'));
        }else{
            JToolbarHelper::cancel('price_cancel');
        }
		JToolbarHelper::cancel('price_propertycancel',JText::_('OS_GO_PROPERTIES'));
		JToolbarHelper::custom('cpanel_list','featured.png', 'featured.png',JText::_('OS_DASHBOARD'),false);
		?>
		<form method="POST" action="index.php?option=com_oscalendar&task=price_setup" name="adminForm" id="adminForm">
		<table  width="100%" border="0">
			<tr>
				<td align="left">
				</td>
				<td align="right">
					<div style="float:right;padding:10px;padding-top:25px;">
						<input type="submit" class="btn btn-warning" value="<?php echo JText::_('OS_SUBMIT')?>" />
					</div>
					<div style="float:right;padding:10px;padding-top:25px;">
					<?php echo JText::_('OS_TO')?>&nbsp;
					<?php echo JHtml::_('calendar',$mainframe->input->getString('end'),'end','end','%Y-%m-%d','onchange="this.form.submit();" style="width:100px;"')?>
					</div>
					<div style="float:right;padding:10px;padding-top:25px;">
					<?php echo JText::_('OS_FROM')?>&nbsp;
					<?php echo JHtml::_('calendar',$mainframe->input->getString('start'),'start','start','%Y-%m-%d','onchange="this.form.submit();" style="width:100px;"')?>
					</div>
				</td>
			</tr>
		</table>
		<?php
        if(count($rows) > 0){
        ?>
		<table  width="100%" class="adminlist table table-striped">
			<thead>
				<tr>
					<th width="5%" style="text-align:center;">#</th>
					<th width="5%" style="text-align:center;">
						<input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
					</th>
					<th width="25%" style="text-align:center;">
						<?php echo JHTML::_('grid.sort',   JText::_('OS_TITLE'), 'title', @$lists['order_Dir'], @$lists['order'] ,'price_setup'); ?>
					</th>
					<th width="15%" style="text-align:center;">
						<?php echo JHTML::_('grid.sort',   JText::_('OS_START'), 'price_from', @$lists['order_Dir'], @$lists['order'] ,'price_setup'); ?>
					</th>
					<th width="15%" style="text-align:center;">
						<?php echo JHTML::_('grid.sort',   JText::_('OS_END'), 'price_to', @$lists['order_Dir'], @$lists['order'] ,'price_setup'); ?>
					</th>
					<th width="15%" style="text-align:center;">
						<?php echo JHTML::_('grid.sort',   JText::_('OS_PRICE'), 'price', @$lists['order_Dir'], @$lists['order'] ,'price_setup'); ?>
					</th>
					<th width="20%" style="text-align:center;">
						<?php echo JText::_('OS_CURRENCY');?>
					</th>								
				</tr>
			</thead>
			<tfoot>
				<tr>
					<td width="100%" colspan="7" style="text-align:center;">
						<?php
							echo $pageNav->getListFooter();
						?>
					</td>
				</tr>
			</tfoot>
			<tbody>
				<?php
				$db = JFactory::getDbo();
				$k = 0;
				for ($i=0, $n=count($rows); $i < $n; $i++) {
					$row 		= $rows[$i];
					$checked 	= JHtml::_('grid.id', $i, $row->id);
					$link 		= JRoute::_( 'index.php?option=com_oscalendar&task=price_edit&cid[]='. $row->id.'&pid='.$property->id.'&rid='.$room->id );
					?>
					<tr class="<?php echo "row$k"; ?>">
						<td align="center" style="text-align:center;"><?php echo $pageNav->getRowOffset( $i ); ?></td>
						<td align="center" style="text-align:center;"><?php echo $checked; ?></td>
						<td style="text-align:left;padding-left:20px;"><a href="<?php echo $link?>"><?php echo $row->title?></a></td>
						<td style="text-align:center;"><?php echo $row->price_from?></td>
						<td style="text-align:center;"><?php echo $row->price_to?></td>
						<td style="text-align:center;"><?php echo HelperOspropertyCommon::showPrice($row->price);?></td>
						<td style="text-align:center;">
							<?php
							echo OSCHelper::showCurrency($row->curr);
							?>
						</td>
					</tr>
				<?php
					$k = 1 - $k;	
				}
				?>
			</tbody>
		</table>
        <?php
        }else{
            ?>
            <div class="alert alert-no-items"><?php echo Jtext::_('OS_NO_MATCHING_RESULTS');?></div>
        <?php
        }
        ?>
		<input type="hidden" name="option" value="com_oscalendar" />
		<input type="hidden" name="task" value="price_setup" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="pid" id="pid" value="<?php echo $property->id; ?>" />
		<input type="hidden" name="rid" id="rid" value="<?php echo $room->id; ?>" />
		<input type="hidden" name="price_type" id="price_type" value="<?php echo $property->price_type; ?>" />
		</form>
		<?php
	}
	
	/**
	 * Edit Season
	 *
	 * @param unknown_type $option
	 * @param unknown_type $row
	 * @param unknown_type $lists
	 */
	static function editPropertyPrice($option,$row,$lists){
		global $mainframe;
		JHTML::_('behavior.tooltip');
		$db = JFactory::getDBO();
		if($row->id > 0){
			$edit = JText::_('OS_EDIT');
		}else{
			$edit = JText::_('OS_ADD');
		}
		JToolBarHelper::title(JText::_('OS_SEASON').JText::_(' ['.$edit.']'));
		JToolBarHelper::save('price_save');
		JToolBarHelper::apply('price_apply');
		JToolBarHelper::cancel('price_gotolist');
		?>
		<form method="POST" action="index.php" name="adminForm" id="adminForm">
		<table  width="100%" class="admintable" style="background-color:white;">
			<tr>
				<td class="key">
					<?php echo JText::_('OS_price_NAME')?>:
				</td>
				<td>
					<input type="text" name="price_name" id="price_name" class="input-large" size="40" value="<?php echo $row->price_name?>" />
				</td>
			</tr>
			<tr>
				<td class="key">
					<?php echo JText::_('OS_START')?>:
				</td>
				<td>
					<?php echo JHtml::_('calendar',$row->start_date,'start_date','start_date','%Y-%m-%d','style="width:100px;"')?>
				</td>
			</tr>
			<tr>
				<td class="key">
					<?php echo JText::_('OS_END')?>:
				</td>
				<td>
					<?php echo JHtml::_('calendar',$row->end_date,'end_date','end_date','%Y-%m-%d','style="width:100px;"')?>
				</td>
			</tr>
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('OS_NIGHTS')?>::<?php echo JText::_('OS_NIGHTS_EXPLAIN')?>">
						<?php echo JText::_('OS_NIGHTS')?>:
					</span>
				</td>
				<td>
					<input type="text" name="nights" id="nights" class="input-mini form-control" value="<?php echo $row->nights?>" />
				</td>
			</tr>
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('OS_MINIMUM_STAY')?>::<?php echo JText::_('OS_MINIMUM_STAY_EXPLAIN')?>">
						<?php echo JText::_('OS_MINIMUM_STAY')?>:
					</span>
				</td>
				<td>
					<input type="text" name="min_book" id="min_book" class="input-mini form-control" value="<?php echo $row->min_book?>" />
				</td>
			</tr>
			<tr>
				<td class="key">
					<?php echo JText::_('OS_STATE')?>:
				</td>
				<td>
					<?php echo $lists['state'];?>
				</td>
			</tr>
		</table>
		<input type="hidden" name="option" value="com_oscalendar" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="id" value="<?php echo $row->id?>" />
		</form>
		<script language="javascript">
		Joomla.submitbutton = function(task) {
			var form = document.adminForm;
			price_name = form.price_name;
			start_date = form.start_date;
			end_date = form.end_date;
			if((task == "price_save") || (task == "price_apply")){
				if(price_name.value == ""){
					alert("<?php echo JText::_('OS_PLEASE_ENTER_price_NAME')?>");
					price_name.focus();
				}else if(start_date.value == ""){
					alert("<?php echo JText::_('OS_PLEASE_ENTER_START_DATE')?>");
				}else if(end_date.value == ""){
					alert("<?php echo JText::_('OS_PLEASE_ENTER_END_DATE')?>");
				}else{
					Joomla.submitform(task);
				}
			}else{
				Joomla.submitform(task);
			}
		}
		</script>
		<?php
	}
	
	
	/**
	 * Show property price
	 *
	 * @param unknown_type $property
	 * @param unknown_type $room
	 * @param unknown_type $room_prices
	 */
	static function showPropertyPrice($property,$room,$room_prices){
		global $mainframe,$configClass,$cClass,$bootstrapHelper;
		$title = "";
		if($property->ref != ""){
			$title .= $property->ref.", ";
		}
		$title .= $property->pro_name;
        if($cClass['allow_room'] == 1){
            $title .= " > ".$room->room_name;
        }
        $title .=  " > ".JText::_('OS_SETUP_PRICE');
		JToolbarHelper::title($title);
		JToolbarHelper::save('price_save');
		JToolbarHelper::apply('price_apply');
        if($cClass['allow_room'] == 1) {
            JToolbarHelper::cancel('price_cancel', JText::_('OS_GO_ROOMS'));
        }else{
            JToolbarHelper::cancel('price_cancel');
        }
		JToolbarHelper::cancel('price_propertycancel',JText::_('OS_GO_PROPERTIES'));
		$rowFluidClass = $bootstrapHelper->getClassMapping('row-fluid');
		$span12Class = $bootstrapHelper->getClassMapping('span12');
		$span6Class = $bootstrapHelper->getClassMapping('span6');
		$span3Class = $bootstrapHelper->getClassMapping('span3');
		?>
		<form method="POST" action="index.php?option=com_oscalendar" id="adminForm" name="adminForm" class="form-horizontal">
			<div class="<?php echo $rowFluidClass;?>">
				<div class="<?php echo $span6Class;?>">
					<div class="control-group">
						<label class="control-label" ><?php echo JText::_('OS_FROM')?></label>
						<div class="controls">
							<?php
							echo JHTML::_('calendar','', 'price_from', 'price_from', '%Y-%m-%d', array('class'=>'input-small form-control', 'size'=>'19',  'maxlength'=>'19','style'=>'width:80px;','readonly'=> 'true'));
							?>
						</div>
					</div>
					<div class="control-group">
						<label class="control-label" ><?php echo JText::_('OS_TO')?></label>
						<div class="controls">
							<?php
							echo JHTML::_('calendar','', 'price_to', 'price_to', '%Y-%m-%d', array('class'=>'input-small form-control', 'size'=>'19',  'maxlength'=>'19','style'=>'width:80px;','readonly'=> 'true'));
							?>
						</div>
					</div>
					<div class="control-group">
						<label class="control-label" ><?php echo JText::_('OS_PRICE')?></label>
						<div class="controls">
							<input type="text" class="input-mini form-control" name="price" id="price"/>
						</div>
					</div>
					<div class="control-group">
						<label class="control-label" ><?php echo JText::_('OS_CURRENCY')?></label>
						<div class="controls">
							<?php
							echo OSappschedulePrice::generatePriceDropdownList(0,$property->curr);
							?>
						</div>
					</div>
					<div class="control-group">
						<label class="control-label" ><?php echo JText::_('OS_MINIMUM_STAY')?></label>
						<div class="controls">
							<input type="text" class="input-mini form-control" name="min_booking" id="min_booking"/>
						</div>
					</div>
				</div>
				<div class="<?php echo $span3Class;?>" style="padding-bottom:10px;">
					<strong><?php echo JText::_('OS_PRICE_FOR')?></strong>
					<BR />
					<hr /> 
					<input type="checkbox" name="allday" id="allday" value="1" checked onclick="javascript:clearAllDays();"> &nbsp; <?php echo JText::_('OS_ALL_DAYS');?>
					<br />
					<hr>
					<?php echo JText::_('OS_ONE_MORE_DAYS');?>
					<br />
					<?php
					$dateArr = array('mon','tue','wed','thu','fri','sat','sun');
					for($i=0;$i<count($dateArr);$i++){
						?>
						<input type="checkbox" name="<?php echo $dateArr[$i];?>" id="<?php echo $dateArr[$i];?>" value="0" onclick="javascript:changeValueDateInWeek('<?php echo $dateArr[$i];?>');"> &nbsp; <?php echo JText::_('OS_'.strtoupper($dateArr[$i]));?>
						<BR />
						<?php
					}
					?>
				</div>
				<div class="<?php echo $span3Class;?>" style="padding-bottom:10px;">
					<strong><?php echo JText::_('Allow Check-in on')?></strong>
					<BR />
					<hr /> 
					<input type="checkbox" name="allow_book_all" id="allow_book_all" value="1" checked onclick="javascript:clearAllAllowDays();"> &nbsp; <?php echo JText::_('OS_ALL_DAYS');?>
					<br />
					<hr>
					<?php echo JText::_('OS_ONE_MORE_DAYS');?>
					<br />
					<?php
					$dateArr1 = array('mon','tue','wed','thu','fri','sat','sun');
					$dateArr = array('allow_mon','allow_tue','allow_wed','allow_thu','allow_fri','allow_sat','allow_sun');
					for($i=0;$i<count($dateArr);$i++){
						?>
						<input type="checkbox" name="<?php echo $dateArr[$i];?>" id="<?php echo $dateArr[$i];?>" value="0" onclick="javascript:changeValueAllowDateInWeek('<?php echo $dateArr[$i];?>');"> &nbsp; <?php echo JText::_('OS_'.strtoupper($dateArr1[$i]));?>
						<BR />
						<?php
					}
					?>
				</div>
			</div>
			<div class="<?php echo $rowFluidClass;?>">
				<div class="<?php echo $span12Class;?>">
					<div class="navbar">
						<div class="navbar-inner" style="padding:5px;">
							<?php
							$current_year = date("Y",time());
							?>
							<?php echo JText::_('OS_SELECTED_YEAR')?>:
							<select name="select_year" id="select_year" class="input-small form-control form-select" onChange="javascript:loadPriceCalendarDiv(<?php echo $room->id?>,<?php echo $property->id?>);">
							<?php
								for($i=$current_year;$i<=$current_year + 6;$i++){
									?>
									<option value="<?php echo $i;?>"><?php echo $i;?></option>
									<?php
								}
							?>
							</select>
						</div>
					</div>
				</div>
			</div>
			<div class="<?php echo $rowFluidClass;?>">
				<div class="<?php echo $span12Class;?>" id="price_calendar_div">
					<?php
					for($i=intval(date("m",time()));$i<=12;$i++){
						HelperOsCalendarCalendar::showCalendarWithPriceBackend($room->id,$property->id,date("Y",time()),$i);
						echo "<BR />";
					}
					?>
				</div>
			</div>
			<input type="hidden" name="option" value="com_oscalendar" />
			<input type="hidden" name="task" value="room_list" />
			<input type="hidden" name="pid" id="pid" value="<?php echo $property->id; ?>" />
			<input type="hidden" name="rid" id="rid" value="<?php echo $room->id; ?>" />
			<input type="hidden" name="price_type" id="price_type" value="<?php echo $property->price_type; ?>" />
			<input type="hidden" name="live_site" id="live_site" value="<?php echo JURI::root();?>" />
			<input type="hidden" name="boxchecked" value="0" />
		</form>
		<script language="javascript">
		function clearAllDays(){
			var temp;
			var allday = document.getElementById('allday');
			if(allday.value == 1){
				allday.value = 0;
			}else{
				allday.value = 1;
				arr = new Array('mon','tue','wed','thu','fri','sat','sun');
				for(i=0;i<arr.length;i++){
					temp = arr[i];
					temp = document.getElementById(temp);
					temp.value = 0;
					temp.checked = false;
				}
			}
		}
		
		function changeValueDateInWeek(id){
			var temp;
			var temp = document.getElementById(id);
			var allday = document.getElementById('allday');
			if(temp.value == 1){
				temp.value = 0;
			}else{
				allday.value = 0;
				allday.checked = false;
				temp.value = 1;
			}
		}
		
		function changeValueAllowDateInWeek(id){
			var temp;
			var temp = document.getElementById(id);
			var allday = document.getElementById('allow_book_all');
			if(temp.value == 1){
				temp.value = 0;
			}else{
				allday.value = 0;
				allday.checked = false;
				temp.value = 1;
			}
		}
		
		function clearAllAllowDays(){
			var temp;
			var allday = document.getElementById('allow_book_all');
			if(allday.value == 1){
				allday.value = 0;
			}else{
				allday.value = 1;
				arr = new Array('allow_mon','allow_tue','allow_wed','allow_thu','allow_fri','allow_sat','allow_sun');
				for(i=0;i<arr.length;i++){
					temp = arr[i];
					temp = document.getElementById(temp);
					temp.value = 0;
					temp.checked = false;
				}
			}
		}
		</script>
		<?php
	}
	
	/**
	 * Edit price
	 *
	 * @param unknown_type $row
	 * @param unknown_type $property
	 * @param unknown_type $room
	 */
	static function editPrice($row,$property,$room){
		global $mainframe,$configClass,$cClass,$languages;
		JHTML::_('behavior.tooltip');
		$db = JFactory::getDBO();
		if($row->id > 0){
			$edit = JText::_('OS_EDIT');
		}else{
			$edit = JText::_('OS_ADD');
		}
		$title = "";
		if($property->ref != ""){
			$title .= $property->ref.", ";
		}
		$title .= $property->pro_name;
        if($cClass['allow_room'] == 1){
            $title .= " > ".$room->room_name;
        }
        $title .=  " > ".JText::_('OS_SETUP_PRICE');
		JToolbarHelper::title($title ." > ".JText::_($edit));
		JToolBarHelper::save('price_save');
		JToolBarHelper::apply('price_apply');
		JToolbarHelper::cancel('price_pricecancel');
        if($cClass['allow_room'] == 1) {
            JToolbarHelper::cancel('price_cancel', JText::_('OS_GO_ROOMS'));
        }else{
            JToolbarHelper::cancel('price_cancel');
        }
		JToolbarHelper::cancel('price_propertycancel',JText::_('OS_GO_PROPERTIES'));
		?>
		<form method="POST" action="index.php" name="adminForm" id="adminForm" enctype="multipart/form-data">
		<table width="100%" class="admintable">
			<tr>
				<td class="key">
					<?php echo JText::_('OS_TITLE')?>:
				</td>
				<td>
					<input type="text" name="title" id="title" class="input-large" size="40" value="<?php echo $row->title;?>" />
				</td>
			</tr>
			<tr>
				<td class="key">
					<?php echo JText::_('OS_START')?>:
				</td>
				<td>
					<?php
					echo JHTML::_('calendar',$row->price_from, 'price_from', 'price_from', '%Y-%m-%d', array('class'=>'input-small', 'size'=>'19',  'maxlength'=>'19','style'=>'width:80px;','readonly'=> 'true'));
					?>
				</td>
			</tr>
			<tr>
				<td class="key">
					<?php echo JText::_('OS_END')?>:
				</td>
				<td>
					<?php
					echo JHTML::_('calendar',$row->price_to, 'price_to', 'price_to', '%Y-%m-%d', array('class'=>'input-small', 'size'=>'19',  'maxlength'=>'19','style'=>'width:80px;','readonly'=> 'true'));
					?>
				</td>
			</tr>
			<tr>
				<td class="key">
					<?php echo JText::_('OS_PRICE')?>:
				</td>
				<td>
					<input type="text" name="price" id="price" class="input-mini" value="<?php echo $row->price;?>" />
				</td>
			</tr>
			<tr>
				<td class="key">
					<?php echo JText::_('OS_CURRENCY')?>:
				</td>
				<td>
					<?php
					echo OSappschedulePrice::generatePriceDropdownList($row->curr,$property->curr);
					?>
				</td>
			</tr>
		</table>
		<input type="hidden" name="MAX_FILE_SIZE" value="90000000" />
		<input type="hidden" name="option" value="com_oscalendar" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="id" value="<?php echo $row->id?>" />
		<input type="hidden" name="pid" id="pid" value="<?php echo $property->id; ?>" />
		<input type="hidden" name="rid" id="rid" value="<?php echo $room->id; ?>" />
		<input type="hidden" name="price_type" id="price_type" value="<?php echo $property->price_type; ?>" />
		</form>
		<?php
	}
}
?>