<?php
/*------------------------------------------------------------------------
# property.html.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/

// no direct access
defined('_JEXEC') or die;

class HTML_OSappscheduleProperty{
	
	static function calendarManage($property,$room){
        global $cClass,$mainframe;
		$db = JFactory::getDbo();
		$title = "";
		if($property->ref != ""){
			$title .= $property->ref.", ";
		}
		$title .= $property->pro_name;
        if($cClass['allow_room'] == 1){
            $title .= " > ".$room->room_name;
        }
        $title .= " > ".JText::_('OS_MANAGE_AVAIABILITY_CALENDAR');
		JToolBarHelper::title( $title );
		JToolBarHelper::custom('property_available','publish.png','publish.png',JText::_('OS_AVAIABLE') ,0);
		JToolBarHelper::custom('property_unavailable','unpublish.png','unpublish.png', JText::_('OS_UNAVAIABLE'),0);
        if($cClass['allow_room'] == 1) {
            JToolbarHelper::cancel('price_cancel', JText::_('OS_GO_ROOMS'));
        }else{
            JToolbarHelper::cancel('price_cancel');
        }
		JToolbarHelper::cancel('price_propertycancel',JText::_('OS_GO_PROPERTIES'));
		JToolbarHelper::custom('cpanel_list','featured.png', 'featured.png',JText::_('OS_DASHBOARD'),false);
		?>
		<form method="POST" action="index.php?option=com_oscalendar" name="adminForm" id="adminForm">
		
		<table width="100%" classf="admintable">
			<tr>
				<td width="100%" style="padding-bottom:10px;">
					<div class="btn-toolbar">
		            	<div class="btn-group">
							<span class="btn btn-info">
								<?php echo JText::_('OS_PROPERTY_AVAILABILITY_CAENDAR_MANAGE')?>
							</span>
							<a href="index.php?option=com_oscalendar&task=property_availability&rid=<?php echo $room->id?>&pid=<?php echo $property->id?>" title="<?php echo JText::_('OS_AVAILABILITY')?>" class="btn">
								<?php echo JText::_('OS_AVAILABILITY')?>
							</a>
						</div>
					</div>
				</td>
			</tr>
		</table>
		<table width="100%">
			<tr>
				<td width="100%">
					<?php
					$year = $mainframe->input->getString('year',date("Y",OSCHelper::getRealTime()));
					$month = $mainframe->input->getString('month',date("m",OSCHelper::getRealTime()));
					HelperOsCalendarCalendar::initCalendarInBackend($property->id,$room->id,$year,$month);
					?>
				</td>
			</tr>
		</table>
		<input type="hidden" name="year"  id="year" value="<?php echo $year;?>" />
		<input type="hidden" name="month"  id="month" value="<?php echo $month;?>" />
		<input type="hidden" name="option" value="com_oscalendar" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="pid" value="<?php echo $property->id?>" />
		<input type="hidden" name="rid" value="<?php echo $room->id?>" />
		<script language="javascript">
		function calendarMoving(pid,rid){
			var ossmh = document.getElementById('ossm');
			var ossyh  = document.getElementById('ossy');
			sm     = ossmh.value;
			sy      = ossyh.value;
			document.getElementById('month').value = sm;
			document.getElementById('year').value = sy;
			
			//loadCalendarAjax(sm,sy,pid,item,"<?php echo JURI::root()?>");
			location.href = "index.php?option=com_oscalendar&task=property_calendarmanage&month=" +  sm  + "&year=" + sy + "&pid=" + pid + "&rid=" + rid;
		}
		function next(pid,rid){
			var month = document.getElementById('month');
			var year  = document.getElementById('year');
			month 	  = month.value;
			year	  = year.value;
			if(month < 12){
				month = parseInt(month) + 1;
			}else{
				year  = parseInt(year) + 1;
				month = 1;
			}
			document.getElementById('month').value = month;
			document.getElementById('year').value = year;
			
			//loadCalendarAjax(month,year,pid,item,"<?php echo JURI::root()?>");
			location.href = "index.php?option=com_oscalendar&task=property_calendarmanage&month=" +  month  + "&year=" + year + "&pid=" + pid + "&rid=" + rid;
		}
		function prev(pid,rid){
			var month = document.getElementById('month');
			var year  = document.getElementById('year');
			month 	  = month.value;
			year	  = year.value;
			if(month > 1){
				month = parseInt(month) - 1;
			}else{
				year  = parseInt(year) - 1;
				month = 12;
			}
			document.getElementById('month').value = month;
			document.getElementById('year').value = year;
			
			//loadCalendarAjax(month,year,pid,item,"<?php echo JURI::root()?>");
			
			location.href = "index.php?option=com_oscalendar&task=property_calendarmanage&month=" +  month  + "&year=" + year + "&pid=" + pid + "&rid=" + rid;
		}
		</script>
		</form>
		<?php
	}

	/**
	 * Edit config HTML
	 *
	 * @param unknown_type $property
	 * @param unknown_type $config
	 * @param unknown_type $prices
	 */
	static function editConfigHTML($property,$seasons){
		global $mainframe,$configClass;
		$db = JFactory::getDbo();
		$pname = $property->pro_name;
		if($property->ref != ""){
			$pname = $property->ref.", ".$pname;
		}
		JToolBarHelper::title(JText::_('OS_RENTAL_INFOMATION')."[".$pname." #".$property->id."]");
		JToolBarHelper::apply('property_saveinfo');
		JToolBarHelper::cancel('property_cancel');
		?>
		<form method="POST" action="index.php" name="adminForm" id="adminForm">
		<table width="100%" class="admintable">
			<tr>
				<td width="100%" style="padding-bottom:10px;">
					<div class="btn-toolbar">
		            	<div class="btn-group">
		            		<span class="btn btn-info">
							<?php echo JText::_('OS_MANAGE_PRICES');?>
							</span>
							<a href="index.php?option=com_oscalendar&task=property_calendarmanage&pid=<?php echo $property->id?>" title="<?php echo JText::_('OS_MANAGE_AVAILABLITY_CALENDAR_FOR_THIS_PROPERTY')?>" class="btn">
								<?php echo JText::_('OS_PROPERTY_AVAILABILITY_CAENDAR_MANAGE')?>
							</a>
							<a href="index.php?option=com_oscalendar&task=property_availability&pid=<?php echo $property->id?>" title="<?php echo JText::_('OS_AVAILABILITY')?>" class="btn">
								<?php echo JText::_('OS_AVAILABILITY')?>
							</a>
						</div>
					</div>
				</td>
			</tr>
			<tr>
				<td width="100%">
					<div class="row-fluid">
						<div class="span12">
							<?php
							if(count($seasons) > 0){
							?>
							<table class="table table-striped">
								<thead>
									<tr>
										<th>
											<?php echo JText::_('OS_SEASON')?>
										</th>
										<th style="text-align:center;">
											<?php echo JText::_('OS_START')?>
										</th>
										<th style="text-align:center;">
											<?php echo JText::_('OS_END')?>
										</th>
										<th style="text-align:center;">
											<?php echo JText::_('OS_NIGHTS')?>
										</th>
										<th style="text-align:center;">
											<?php echo JText::_('OS_PRICE')?>
										</th>
									</tr>
								</thead>
								<tbody>
									<?php
									$k = 0;
									for($i=0;$i<count($seasons);$i++){
										$season = $seasons[$i];
										$db->setQuery("Select price from #__oscalendar_property_seasons_prices where pid = '$property->id' and season_id = '$season->id'");
										$price = $db->loadResult();
										?>
										<tr class="row<?php echo $k?>">
											<td style="text-align:left;">
												<?php echo $season->season_name;?>
											</td>
											<td style="text-align:center;">
												<?php echo $season->start_date;?>
											</td>
											<td style="text-align:center;">
												<?php echo $season->end_date;?>
											</td>
											<td style="text-align:center;">
												<?php echo $season->nights;?>
											</td>
											<td style="text-align:center;">
												<input type="text" class="input-mini" name="season_price<?php echo $season->id;?>" id="season_price<?php echo $season->id;?>" value="<?php echo $price;?>" />
												<?php
												echo $configClass['currency_format'];
												?>
											</td>
										</tr>
										<?php
										$k = 1 - $k;
									}
									?>
								</tbody>
							</table>
							<?php
							}else{
								?>
								<strong>
									<?php echo JText::_('OS_NO_SEASON_AVAILABLE');?>
								</strong>
								<?php
							}
							?>
							</table>
						</div>
					</div>
				</td>
			</tr>
		</table>
		<input type="hidden" name="option" value="com_oscalendar">
		<input type="hidden" name="task" value="">
		<input type="hidden" name="boxchecked" value="0">
		<input type="hidden" name="pid" value="<?php echo $property->id?>">
		</form>
		<?php
	}
	
	/**
	 * Availability Calendar
	 *
	 * @param unknown_type $property
	 * @param unknown_type $month
	 * @param unknown_type $year
	 */
	static function availabilityCalendar($property,$room,$month,$year){
		global $mainframe,$configClass;
		$db = JFactory::getDbo();
		$pname = $property->pro_name;
		if($property->ref != ""){
			$pname = $property->ref.", ".$pname;
		}
		JToolBarHelper::title(JText::_('OS_AVAILABILITY_INFOMATION')." [".$pname." #".$property->id." > ".$room->room_name."]");
		JToolbarHelper::cancel('price_cancel',JText::_('OS_GO_ROOMS'));
		JToolbarHelper::cancel('price_propertycancel',JText::_('OS_GO_PROPERTIES'));
		JToolbarHelper::custom('cpanel_list','featured.png', 'featured.png',JText::_('OS_DASHBOARD'),false);
		?>
		<form method="POST" action="index.php?option=com_oscalendar" name="adminForm" id="adminForm">
		<div class="row-fluid">
			<div class="span12">
				<div class="btn-toolbar">
		        	<div class="btn-group">
						<a href="index.php?option=com_oscalendar&task=property_calendarmanage&rid=<?php echo $room->id;?>&pid=<?php echo $property->id?>" title="<?php echo JText::_('OS_MANAGE_AVAILABLITY_CALENDAR_FOR_THIS_PROPERTY')?>" class="btn">
							<?php echo JText::_('OS_PROPERTY_AVAILABILITY_CAENDAR_MANAGE')?>
						</a>
						<span class="btn btn-info">
							<?php echo JText::_('OS_AVAILABILITY')?>
						</span>
					</div>
				</div>
			</div>
		</div>
		<div class="row-fluid">
			<div class="span12 nomarginleft">
				<div class="span3 nomarginleft">
					<table>
						<tr>
							<td width="30%" style="background-color:#2D9B35;width:50px;">
								
							</td>
							<td width="70%" style="padding-left:5px;">
								<?php echo JText::_('OS_FULL_AVAILABLE');?>
							</td>
						</tr>
					</table>
				</div>
				<div class="span3 nomarginleft">
					<table>
						<tr>
							<td width="30%" style="background-color:#7CC2EA;width:50px;">
								
							</td>
							<td width="70%" style="padding-left:5px;">
								<?php echo JText::_('OS_AVAILABLE');?>
							</td>
						</tr>
					</table>
				</div>
				<div class="span3 nomarginleft">
					<table>
						<tr>
							<td width="30%" style="background-color:#C28D25;width:50px;">
								
							</td>
							<td width="70%" style="padding-left:5px;">
								<?php echo JText::_('OS_UNAVAILABLE');?>
							</td>
						</tr>
					</table>
				</div>
				<div class="span3 nomarginleft">
					<table>
						<tr>
							<td width="30%" style="background-color:#FF0000;width:50px;">
								
							</td>
							<td width="70%" style="padding-left:5px;">
								<?php echo JText::_('OS_BOOKED');?>
							</td>
						</tr>
					</table>
				</div>
			</div>
		</div>
		<div class="clearfix"></div>
		<div class="row-fluid">
			<div class="span12" id="availability_calendar_div">
				<?php
				$k = 0;
				$m = intval($month);
				$y = intval($year);
				for($i=0;$i<6;$i++){
					$k++;
					$m = $month + $i;
					if($m > 12){
						$m = $m - 12;
						$y = $year + 1;
					}
					?>
					<div class="span4" style="margin-left:0px;padding-right:10px;padding-bottom:20px;">
						<?php HelperOsCalendarCalendar::initAvailabilityCalendar($property->id,$room->id,$y,$m,'');?>
					</div>
					<?php
					if($k == 3)	{
						?>
						<div class="clearfix"></div>
						<?php
						$k = 0;
					}
				}
				?>
			</div>
		</div>
		<input type="hidden" name="option" value="com_oscalendar" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="pid" id="pid" value="<?php echo $property->id?>" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="live_site" id="live_site" value="<?php echo JURI::root()?>" />
		</form>
		<script language="javascript">
		function loadAvailabilityCalendar(pid,rid,year,month){
			ajaxLoadAvailabilityCalendar("<?php echo JURI::root()?>",pid,rid,year,month);
		}
		</script>
		<?php
	}
}
?>