<?php

/**
 * @package   OSDownloads-Pro
 * @contact   www.joomlashack.com, help@joomlashack.com
 * @copyright 2005-2025 Joomlashack.com. All rights reserved
 * @license   https://www.gnu.org/licenses/gpl.html GNU/GPL
 *
 * This file is part of OSDownloads-Pro.
 *
 * OSDownloads-Pro is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * OSDownloads-Pro is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSDownloads-Pro.  If not, see <https://www.gnu.org/licenses/>.
 */

namespace Alledia\OSDownloads\Pro\Joomla\Model;

use Alledia\OSDownloads\Factory;
use Alledia\OSDownloads\Free\Joomla\Model\Emails as FreeEmails;
use Joomla\CMS\Language\Text;

// phpcs:disable PSR1.Files.SideEffects
defined('_JEXEC') or die();
// phpcs:enable PSR1.Files.SideEffects
// phpcs:disable PSR1.Classes.ClassDeclaration.MissingNamespace

class Emails extends FreeEmails
{
    /**
     * @inheritDoc
     */
    public function __construct($config = [])
    {
        $config['filter_fields'] = [
            'confirmed',
        ];

        parent::__construct($config);
    }

    /**
     * @inheritDoc
     */
    protected function getListQuery()
    {
        $db    = $this->getDbo();
        $query = parent::getListQuery();

        $confirmed = $this->getState('filter.confirmed');
        if ($confirmed != '') {
            $query->where('confirmed = ' . (int)$confirmed);
        }

        $subQuery = $db->getQuery(true)
            ->select('COUNT(*) > 0')
            ->from('#__fields_values AS val')
            ->innerJoin(
                sprintf(
                    '#__fields AS field ON (%s)',
                    join(' AND ', [
                        'field.context = ' . $db->quote('com_osdownloads.download'),
                        'val.field_id = field.id',
                    ])
                )
            )
            ->where('val.item_id = email.id');

        $query->select(sprintf('(%s) AS has_custom_fields', $subQuery));

        return $query;
    }

    /**
     * Get the values of custom fields for the givem item.
     *
     * @param object $item
     *
     * @return array
     */
    public function getCustomFieldsValues(object $item): array
    {
        $db = Factory::getDbo();

        $query = $db->getQuery(true)
            ->select([
                'val.value AS value',
                'field.name AS name',
                'field.title AS title',
            ])
            ->from('#__fields_values AS val')
            ->innerJoin(
                sprintf(
                    '#__fields AS field ON (%s)',
                    join(' AND ', [
                        'field.context = ' . $db->quote('com_osdownloads.download'),
                        'val.field_id = field.id',
                    ])
                )
            )
            ->where('val.item_id = ' . $db->quote($item->id));

        return $db->setQuery($query)->loadObjectList();
    }

    /**
     * Get the values of custom fields for the givem item, returning as string.
     *
     * @param object $item
     *
     * @return string
     */
    public function getCustomFieldsValuesAsString(object $item): string
    {
        $values = $this->getCustomFieldsValues($item);

        $output = [];
        if (is_array($values)) {
            foreach ($values as $value) {
                $output[] = Text::_($value->title) . ': ' . $value->value;
            }
        }

        return implode('<br>', $output);
    }

    /**
     * Get the list of custom fields
     *
     * @return array
     */
    public function getCustomFieldsNames(): array
    {
        $db = Factory::getDbo();

        $query = $db->getQuery(true)
            ->select('field.name AS name')
            ->from('#__fields AS field')
            ->where('field.context = "com_osdownloads.download"');

        return $db->setQuery($query)->loadObjectList();
    }

    /**
     * Get the values of custom fields for the givem item, by the field name.
     *
     * @param object $item
     *
     * @return array
     */
    public function getCustomFieldsValuesByFieldName(object $item): array
    {
        $data = $this->getCustomFieldsValues($item);

        $processedList = [];

        if (!empty($data)) {
            foreach ($data as $row) {
                $processedList[$row->name] = $row->value;
            }
        }

        return $processedList;
    }
}
