<?php
/**
 * @package   OSDownloads-Pro
 * @contact   www.joomlashack.com, help@joomlashack.com
 * @copyright 2005-2025 Joomlashack.com. All rights reserved
 * @license   https://www.gnu.org/licenses/gpl.html GNU/GPL
 *
 * This file is part of OSDownloads-Pro.
 *
 * OSDownloads-Pro is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * OSDownloads-Pro is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSDownloads-Pro.  If not, see <https://www.gnu.org/licenses/>.
 */

use Alledia\OSDownloads\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

defined('_JEXEC') or die();

HTMLHelper::_('script', 'com_osdownloads/clipboard.min.js', ['relative' => true]);

static $installClipboard = true;
if ($installClipboard) :
    $jscript = <<<JSCRIPT
    document.addEventListener('DOMContentLoaded', function() {
        new ClipboardJS('.osdownloads-copy-btn');    
    });
JSCRIPT;

    Factory::getDocument()->addScriptDeclaration($jscript);

    $installClipboard = false;
endif;
?>
<script>
</script>
<td class="center text-center">
    <?php if ($this->item->confirmed) :
        echo '<span class="icon-publish"></span>';
    else :
        echo '<span class="icon-cancel"></span>';
    endif; ?>
</td>
<td class="center text->center">
    <?php if ($this->item->synced) :
        echo '<span class="icon-publish"></span>';
    else :
        echo '<span class="icon-cancel"></span>&nbsp;' . $this->item->sync_error;
    endif; ?>
</td>

<td class="center text-center">
    <?php if ($this->item->has_custom_fields) : ?>
        <?php
        $data = $this->model->getCustomFieldsValuesAsString($this->item);

        echo sprintf(
            '%s&nbsp;%s',
            HTMLHelper::_(
                'link',
                '#',
                '<span class="icon-eye" style="font-size: 16px;"></span>',
                [
                    'class'        => 'hasPopover',
                    'title'        => HTMLHelper::_('tooltipText', 'COM_OSDOWNLOADS_FIELD_CUSTOM_FIELDS_LABEL', $data),
                ]
            ),
            HTMLHelper::_(
                'link',
                '#',
                '<span class="icon-copy" style="font-size: 16px;"></span>',
                [
                    'class'               => 'osdownloads-copy-btn hasPopover',
                    'data-clipboard-text' => str_replace('<br>', "\n", $data),
                    'title'               => Text::_('COM_OSDOWNLOADS_COPY_TO_CLIPBOARD'),
                    'data-content'        => Text::_('COM_OSDOWNLOADS_COPY_TO_CLIPBOARD_DESC')
                ]
            )
        );

    else :
        echo '-';
    endif; ?>
</td>
