<?php 
/*------------------------------------------------------------------------
# general.php - Ossolution Property
# ------------------------------------------------------------------------
# author    Dang Thuc Dam
# copyright Copyright (C) 2025 joomdonation.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

global $languages;
$db = Factory::getContainer()->get('db');
$controlGroupClass = $bootstrapHelper->getClassMapping('control-group');
$controlLabelClass = $bootstrapHelper->getClassMapping('control-label');
$controlsClass     = $bootstrapHelper->getClassMapping('controls');
$inputLargeClass   = $bootstrapHelper->getClassMapping('input-large');
$inputSmallClass   = $bootstrapHelper->getClassMapping('input-small');
$inputMiniClass    = $bootstrapHelper->getClassMapping('input-mini') . ' smallSizeBox';
?>

<div class="row">
    <div class="col-md-6">
        
        <!-- ============================================ -->
        <!-- BUSINESS SETTINGS -->
        <!-- ============================================ -->
        <fieldset class="form-horizontal options-form">
            <legend><?php echo TextOs::_('Business Setting')?></legend>
            
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('general_bussiness_name', TextOs::_( 'System bussiness name' ), TextOs::_('The name of your real estate business shown on the component header and elsewhere, eg. the print page and email pages.')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <input type="text" class="<?php echo $inputLargeClass;?> ilarge" size="40" name="configuration[general_bussiness_name]" value="<?php echo isset($configs['general_bussiness_name'])? $configs['general_bussiness_name']:''; ?>">
                </div>
            </div>
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('general_bussiness_address', TextOs::_( 'Business Address' ), Text::_('Your business address. This appears in the header of the print page.')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <input type="text" class="<?php echo $inputLargeClass;?> ilarge" size="40" name="configuration[general_bussiness_address]" value="<?php echo isset($configs['general_bussiness_address'])? $configs['general_bussiness_address']:''; ?>">
                </div>
            </div>
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('general_bussiness_phone', Text::_( 'OS_BUSINESS_PHONE_NUMBER' ), Text::_('OS_BUSINESS_PHONE_NUMBER_EXPLAIN')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <input type="text" class="<?php echo $inputLargeClass;?> ilarge" size="40" name="configuration[general_bussiness_phone]" value="<?php echo isset($configs['general_bussiness_phone'])? $configs['general_bussiness_phone']:''; ?>">
                </div>
            </div>
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('general_bussiness_email', TextOs::_( 'Business Email' ), TextOs::_('Email address to use with the property inspection and mailing list request forms.')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <input type="text" class="<?php echo $inputLargeClass;?> ilarge" size="40" name="configuration[general_bussiness_email]" value="<?php echo isset($configs['general_bussiness_email'])? $configs['general_bussiness_email']:''; ?>">
                </div>
            </div>
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('notify_email', TextOs::_( 'Notify Email' ), TextOs::_('NOTIFY_EMAIL_EXPLAIN')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <input type="text" class="<?php echo $inputLargeClass;?> ilarge" size="40" name="configuration[notify_email]" value="<?php echo isset($configs['notify_email'])? $configs['notify_email']:''; ?>" />
                </div>
            </div>
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('show_footer', Text::_( 'OS_SHOW_COPYRIGHT' ), TextOs::_('SHOW_FOOTER_EXPLAIN')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <?php
                    OspropertyConfiguration::showCheckboxfield('show_footer',$configs['show_footer']);
                    ?>
                </div>
            </div>
        </fieldset>

        <!-- ============================================ -->
        <!-- CURRENCY SETTINGS -->
        <!-- ============================================ -->
        <fieldset class="form-horizontal options-form">
            <legend><?php echo TextOs::_('Currency Setting')?></legend>
            
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('general_currency_default', TextOs::_( 'Default currency' ), TextOs::_('DEFAULT_CURRENCY_EXPLAIN')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <?php
                    $db = Factory::getContainer()->get('db');
                    $db->setQuery("Select id as value, concat(currency_name,' - ',currency_code,' - ',currency_symbol) as text from #__osrs_currencies where published = '1' order by currency_name");
                    $currencies = $db->loadObjectList();
                    if (!isset($configs['general_currency_default'])) $configs['general_currency_default'] = 57;
                    echo OSPHelper::getChoicesJsSelect(HTMLHelper::_('select.genericlist',$currencies,'configuration[general_currency_default]','class="inputbox  ilarge form-select"','value','text',$configs['general_currency_default']));
                    ?>
                </div>
            </div>
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('show_convert_currency', TextOs::_( 'Show convert currencies' ), TextOs::_('Show convert currencies explain')." ".Text::_( 'OS_CONVERT_CURRENCY_NOTICE' )); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <?php
                    OspropertyConfiguration::showCheckboxfield('show_convert_currency',$configs['show_convert_currency']);
                    ?>
                </div>
            </div>
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('convert_api', Text::_( 'Currency convert API' ), Text::_('Register API key through this page: https://free.currconv.com/login')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <input type="text" class="<?php echo $inputSmallClass; ?> ilarge" name="configuration[convert_api]" value="<?php echo isset($configs['convert_api'])?$configs['convert_api']:'' ?>" />
                </div>
            </div>
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('general_currency_money_format', TextOs::_( 'Money format' ), TextOs::_('Show convert currencies explain')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <?php
                    $option_moneyformat = array();
                    $option_moneyformat[] = HTMLHelper::_('select.option',0,TextOs::_('Select Money format'));
                    $option_moneyformat[] = HTMLHelper::_('select.option',1,'1.000.000,00');
                    $option_moneyformat[] = HTMLHelper::_('select.option',2,'1 000 000,00');
                    $option_moneyformat[] = HTMLHelper::_('select.option',3,'1,000,000.00');
                    $option_moneyformat[] = HTMLHelper::_('select.option',4,'1.000.000');
                    $option_moneyformat[] = HTMLHelper::_('select.option',5,'1 000 000');
                    $option_moneyformat[] = HTMLHelper::_('select.option',6,'1,000,000');
                    echo HTMLHelper::_('select.genericlist',$option_moneyformat,'configuration[general_currency_money_format]','class="form-select input-large ilarge"','value','text',isset($configs['general_currency_money_format'])? $configs['general_currency_money_format']:0);
                    ?>
                </div>
            </div>
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('currency_position', Text::_( 'OS_CURRENCY_POSITION' ), Text::_('OS_CURRENCY_POSITION_EXPLAIN')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <?php
                    $option_order = array();
                    $option_order[] = HTMLHelper::_('select.option','0',Text::_('OS_BEFORE_PRICE'));
                    $option_order[] = HTMLHelper::_('select.option','1',Text::_('OS_AFTER_PRICE'));
                    echo HTMLHelper::_('select.genericlist',$option_order,'configuration[currency_position]','class="form-select input-large ilarge"','value','text',$configs['currency_position']);
                    ?>
                </div>
            </div>
        </fieldset>

        <!-- ============================================ -->
        <!-- REPORT -->
        <!-- ============================================ -->
        <fieldset class="form-horizontal options-form">
            <legend><?php echo Text::_('OS_REPORT')?></legend>
            
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('enable_report', Text::_('OS_REPORT'), Text::_('OS_REPORT_EXPLAIN')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <?php
                    OspropertyConfiguration::showCheckboxfield('enable_report',(int)$configs['enable_report']);
                    ?>
                </div>
            </div>
        </fieldset>

        <!-- ============================================ -->
        <!-- PRIVACY POLICY (GDPR) SETTINGS -->
        <!-- ============================================ -->
        <fieldset class="form-horizontal options-form">
            <legend><?php echo Text::_('OS_PRIVACY_POLICY_GDPR_SETTINGS')?></legend>
            
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('use_privacy_policy', Text::_( 'OS_SHOW_PRIVACY_POLICY' ), Text::_('OS_SHOW_PRIVACY_POLICY_EXPLAIN')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <?php
                    OspropertyConfiguration::showCheckboxfield('use_privacy_policy',(int)$configs['use_privacy_policy']);
                    ?>
                </div>
            </div>
            <div class="<?php echo $controlGroupClass; ?>" data-showon='<?php echo HelperOspropertyCommon::renderShowon(array('configuration[use_privacy_policy]' => '1')); ?>'>
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('privacy_policy_article_id', Text::_( 'OS_PRIVACY_ARTICLE' ), Text::_('OS_PRIVACY_ARTICLE_EXPLAIN')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <?php echo OSPHelper::getArticleInput($configs['privacy_policy_article_id'], 'configuration[privacy_policy_article_id]'); ?>
                </div>
            </div>
            <div class="<?php echo $controlGroupClass; ?>" data-showon='<?php echo HelperOspropertyCommon::renderShowon(array('configuration[use_privacy_policy]' => '1')); ?>'>
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('allow_user_profile_optin', Text::_( 'OS_TURNON_PROFILE_OPTIN' ), Text::_('OS_TURNON_PROFILE_OPTIN_EXPLAIN')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <?php
                    OspropertyConfiguration::showCheckboxfield('allow_user_profile_optin',(int)$configs['allow_user_profile_optin']);
                    ?>
                </div>
            </div>
        </fieldset>

    </div>

    <div class="col-md-6">
        <fieldset class="form-horizontal options-form">
            <legend><?php echo Text::_('OS_DOWNLOAD_ID')?></legend>
            <div class="download-id-section">
                <div class="form-group">
                    <input type="text" 
                        class="form-control" 
                        id="download_id" 
                        name="configuration[download_id]" 
                        value="<?php echo isset($configClass['download_id']) ? htmlspecialchars($configClass['download_id']) : ''; ?>"
                        placeholder="<?php echo Text::_('OS_ENTER_DOWNLOAD_ID'); ?>">
                </div>
                
                <div class="alert alert-info">
                    <div class="alert-heading">
                        <i class="icon-info-circle"></i>
                        <strong><?php echo Text::_('OS_HOW_TO_GET_DOWNLOAD_ID'); ?></strong>
                    </div>
                    <p class="mb-2">
                        <?php echo Text::_('OS_DOWNLOAD_ID_DESCRIPTION'); ?>
                    </p>
                    <ol class="mb-2">
                        <li>
                            <?php echo Text::_('OS_DOWNLOAD_ID_STEP_1'); ?> 
                            <a href="https://www.joomdonation.com" target="_blank" rel="noopener noreferrer">
                                <strong>www.joomdonation.com</strong>
                            </a>
                        </li>
                        <li>
                            <?php echo Text::_('OS_DOWNLOAD_ID_STEP_2'); ?> 
                            <a href="https://www.joomdonation.com/download-ids.html" target="_blank" rel="noopener noreferrer">
                                <strong><?php echo Text::_('OS_DOWNLOAD_ID_MENU'); ?></strong>
                            </a>
                        </li>
                    </ol>
                    <p class="mb-0">
                        <i class="icon-warning"></i>
                        <strong><?php echo Text::_('OS_NOTICE'); ?>:</strong> 
                        <?php echo Text::_('OS_DOWNLOAD_ID_NOTICE'); ?>
                    </p>
                </div>
            </div>

            <style>
            .download-id-section {
                max-width: 100%;
            }

            .download-id-section .form-group {
                margin-bottom: 1rem;
            }

            .download-id-section .form-label {
                display: block;
                margin-bottom: 0.5rem;
                font-size: 14px;
            }

            .download-id-section .alert {
                padding: 1rem;
                border-radius: 0.375rem;
                border-left: 4px solid #0dcaf0;
                background-color: #cff4fc;
                color: #055160;
            }

            .download-id-section .alert-heading {
                display: flex;
                align-items: center;
                gap: 0.5rem;
                margin-bottom: 0.75rem;
                font-size: 15px;
            }

            .download-id-section .alert-heading i {
                font-size: 18px;
            }

            .download-id-section .alert p {
                font-size: 14px;
                line-height: 1.6;
            }

            .download-id-section .alert ol {
                padding-left: 1.5rem;
                font-size: 14px;
                line-height: 1.8;
            }

            .download-id-section .alert ol li {
                margin-bottom: 0.5rem;
            }

            .download-id-section .alert a {
                color: #0a58ca;
                text-decoration: none;
                transition: color 0.2s ease;
            }

            .download-id-section .alert a:hover {
                color: #084298;
                text-decoration: underline;
            }

            .download-id-section .alert .icon-warning {
                color: #856404;
            }

            @media (max-width: 768px) {
                .download-id-section .alert {
                    padding: 0.75rem;
                }
                
                .download-id-section .alert-heading {
                    font-size: 14px;
                }
                
                .download-id-section .alert p,
                .download-id-section .alert ol {
                    font-size: 13px;
                }
            }
            </style>

        </fieldset>
        <!-- ============================================ -->
        <!-- GENERAL SETTINGS -->
        <!-- ============================================ -->
        <fieldset class="form-horizontal options-form">
            <legend><?php echo Text::_('General Setting')?></legend>
            
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('twitter_bootstrap_version', Text::_( 'OS_BOOTSTRAP_VERSION' ), Text::_('OS_BOOTSTRAP_VERSION_EXPLAIN')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <?php
                    //OspropertyConfiguration::showCheckboxfield('twitter_bootstrap_version',(int)$configs['twitter_bootstrap_version'],'Bootstrap version 3','Bootstrap version 2');
                    $options   = array();
                    $options[] = HTMLHelper::_('select.option', 4, Text::_('OS_VERSION_4'));
                    $options[] = HTMLHelper::_('select.option', 5, Text::_('OS_VERSION_5'));
                    echo HTMLHelper::_('select.genericlist', $options, 'configuration[twitter_bootstrap_version]', 'class="form-select input-large ilarge"', 'value', 'text', $configs['twitter_bootstrap_version'] ? (int)$configs['twitter_bootstrap_version'] : 2);
                    ?>
                </div>
            </div>
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('load_bootstrap_css', Text::_( 'OS_LOAD_BOOTSTRAP_CSS' ), Text::_('OS_LOAD_BOOTSTRAP_CSS_EXPLAIN')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <?php
                    OspropertyConfiguration::showCheckboxfield('load_bootstrap_css',$configs['load_bootstrap_css']);
                    ?>
                </div>
            </div>
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('load_chosen', Text::_( 'OS_LOAD_CHOSEN' ), Text::_('OS_LOAD_CHOSEN_EXPLAIN')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <?php
                    OspropertyConfiguration::showCheckboxfield('load_chosen',$configs['load_chosen']);
                    ?>
                </div>
            </div>
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('load_lazy', Text::_( 'OS_USE_LAZY' ), Text::_('OS_USE_LAZY_EXPLAIN')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <?php
                    OspropertyConfiguration::showCheckboxfield('load_lazy',$configs['load_lazy']);
                    ?>
                </div>
            </div>
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('general_date_format', TextOs::_( 'Date format' ), Text::_('OS_SELECT_THE_DATE_FORMAT_FOR_PAGE_DISPLAY')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <?php
                    $option_format_date = array();
                    $option_format_date[] =  HTMLHelper::_('select.option','d-m-Y H:i:s','d-m-Y H:i:s');
                    $option_format_date[] =  HTMLHelper::_('select.option','m-d-Y H:i:s','m-d-Y H:i:s');
                    $option_format_date[] =  HTMLHelper::_('select.option','Y-m-d H:i:s','Y-m-d H:i:s');
                    $option_format_date[] =  HTMLHelper::_('select.option','d-m-Y h:i A','d-m-Y h:i A');
                    echo HTMLHelper::_('select.genericlist',$option_format_date,'configuration[general_date_format]','class="form-select input-large ilarge"','value','text',isset($configs['general_date_format'])? $configs['general_date_format']:'');
                    ?>
                </div>
            </div>
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('general_date_format', Text::_( 'OS_DEFAULT_COUNTRIES' ), TextOs::_('SELECT_COUNTRY_EXPLAIN')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <?php
                    $db->setQuery("Select id as value, country_name as text from #__osrs_countries order by country_name");
                    $countries = $db->loadObjectList();
                    $checkbox_show_country_id = array();
                    if (isset($configs['show_country_id'])){
                        $checkbox_show_country_id = explode(',',$configs['show_country_id']);
                    }
                    if($configs['show_country_id'] == ""){
                        $checkbox_show_country_id[] = 194;
                    }
                    echo OSPHelper::getChoicesJsSelect(HTMLHelper::_('select.genericlist',$countries,'configuration[show_country_id][]','multiple class="inputbox"','value','text',$checkbox_show_country_id));
                    ?>
                </div>
            </div>

            <?php
            $query = $db->getQuery(true);
            $query->clear();
            $rows = array();
            $query->select('a.id AS value, a.title AS text, a.level');
            $query->from('#__menu AS a');
            $query->join('LEFT', $db->quoteName('#__menu').' AS b ON a.lft > b.lft AND a.rgt < b.rgt');

            $query->where('a.menutype != '.$db->quote(''));
            $query->where('a.component_id IN (SELECT extension_id FROM #__extensions WHERE element="com_osproperty")');
            $query->where('a.client_id = 0');
            $query->where('a.published = 1');

            $query->group('a.id, a.title, a.level, a.lft, a.rgt, a.menutype, a.parent_id, a.published');
            $query->order('a.lft ASC');

            // Get the options.
            $db->setQuery($query);
            $rows = $db->loadObjectList();

            // Pad the option text with spaces using depth level as a multiplier.
            for ($i = 0, $n = count($rows); $i < $n; $i++)
            {
                $rows[$i]->text = str_repeat('- ', $rows[$i]->level).$rows[$i]->text;
            }
            $options = array();
            $options[] = HTMLHelper::_('select.option', 0, Text::_('-- None --'), 'value', 'text');
            $rows = array_merge($options, $rows);

            $lists['default_menu_item'] = HTMLHelper::_('select.genericlist', $rows, 'configuration[default_itemid]',
                array(
                    'option.text.toHtml'	=> false,
                    'option.text'			=> 'text',
                    'option.value'			=> 'value',
                    'list.attr'				=> ' class="form-select input-large ilarge" ',
                    'list.select'			=> $configs['default_itemid']));
            ?>
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('load_lazy', Text::_( 'OS_DEFAULT_ITEMID' ), Text::_('OS_DEFAULT_ITEMID_EXPLAIN')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <?php echo $lists['default_menu_item']; ?>
                </div>
            </div>
        </fieldset>

        <!-- ============================================ -->
        <!-- MAP SETTINGS -->
        <!-- ============================================ -->
        <fieldset class="form-horizontal options-form">
            <legend><?php echo Text::_('OS_MAP')?></legend>
            
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('map_type', Text::_( 'OS_SELECT_MAP_TYPE' ), Text::_('OS_SELECT_MAP_TYPE_EXPLAIN')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <?php
                    OspropertyConfiguration::showCheckboxfield('map_type',(int)$configs['map_type'] ,'Google Map' , 'OpenStreetMap');
                    ?>
                </div>
            </div>
            <div class="<?php echo $controlGroupClass; ?>" data-showon='<?php echo HelperOspropertyCommon::renderShowon(array('configuration[map_type]' => '0')); ?>'>
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('goole_aip_key', Text::_( 'OS_GOOGLE_API_KEY' ), ''); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <input type="text" class="<?php echo $inputLargeClass;?> ilagre" name="configuration[goole_aip_key]" value="<?php echo isset($configs['goole_aip_key'])?$configs['goole_aip_key']:'' ?>" />
                    <BR />
                    You can register new Google API key through this <strong><a href="https://console.developers.google.com/flows/enableapi?apiid=maps_backend,geocoding_backend,directions_backend,distance_matrix_backend,elevation_backend&keyType=CLIENT_SIDE&reusekey=true" target="_blank" title="To get started using the Google Maps JavaScript API, click the button below, which takes you to the Google Developers Console.">link</a></strong>. You can read more details <strong><a href="https://developers.google.com/maps/documentation/javascript/get-api-key#get-an-api-key">here</a></strong>
                </div>
            </div>
            
            <div class="<?php echo $controlGroupClass; ?>" data-showon='<?php echo HelperOspropertyCommon::renderShowon(array('configuration[map_type]' => '0')); ?>'>
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('goole_map_overlay', TextOs::_( 'Map Overlay' ), ''); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <?php
                    if (!isset($configs['goole_map_overlay'])) $configs['goole_map_overlay'] = 'ROADMAP';
                    $option_map_overlay = array();
                    $option_map_overlay[] = HTMLHelper::_('select.option','ROADMAP',TextOs::_('Normal'));
                    $option_map_overlay[] = HTMLHelper::_('select.option','SATELLITE',TextOs::_('Satellite'));
                    $option_map_overlay[] = HTMLHelper::_('select.option','HYBRID',TextOs::_('Hybrid'));
                    echo HTMLHelper::_('select.genericlist',$option_map_overlay,'configuration[goole_map_overlay]','class="form-select input-large ilarge"','value','text',$configs['goole_map_overlay']);
                    ?>
                </div>
            </div>
            <div class="<?php echo $controlGroupClass; ?>" data-showon='<?php echo HelperOspropertyCommon::renderShowon(array('configuration[map_type]' => '0')); ?>'>
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('goole_use_map',Text::_( 'OS_SHOW_STREET_VIEW_IN_DETAILS' ), Text::_('OS_SHOW_STREET_VIEW_MAP_EXPLAIN')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <?php
                    OspropertyConfiguration::showCheckboxfield('show_streetview',$configs['show_streetview']);
                    ?>
                </div>
            </div>
            <div class="<?php echo $controlGroupClass; ?>">
                <?php echo HelperOspropertyCommon::showLabel('', TextOs::_( 'Default coordinates' ), TextOs::_('DEFAULT_COORDINATES_EXPLAIN')); 
                global $configClass;
                if($configClass['map_type'] == 0)
                {
                    include(JPATH_ROOT . "/components/com_osproperty/helpers/googlemap.lib.php");
                    if (($configClass['goole_default_lat'] == "") && ($configClass['goole_default_long'] == ""))
                    {
                        //find the default lat long
                        $default_address = $configClass['general_bussiness_address'];
                        $defaultGeocode = HelperOspropertyGoogleMap::getLatlongAdd($default_address);
                        $configClass['goole_default_lat'] = $defaultGeocode[0]->lat;
                        $configClass['goole_default_long'] = $defaultGeocode[0]->long;
                    }

                    $thedeclat = $configClass['goole_default_lat'];
                    $thedeclong = $configClass['goole_default_long'];

                    $geoCodeArr = array();
                    $tmp		= new \stdClass();
                    $tmp->lat = $thedeclat;
                    $tmp->long = $thedeclong;
                    $geoCodeArr[0]	= $tmp;
                    HelperOspropertyGoogleMap::loadGMapinEditProperty($geoCodeArr, 'map', 'er_declat', 'er_declong');
                    ?>
                    <br />
                    <body onload="initialize()">
                    <div id="map" style="width: 100%; height: 200px"></div>
                    </body>
                    <?php
                }
                else
                {
                    include(JPATH_ROOT . "/components/com_osproperty/helpers/openstreetmap.lib.php");
                    if (($configClass['goole_default_lat'] == "") && ($configClass['goole_default_long'] == ""))
                    {
                        //find the default lat long
                        $default_address = $configClass['general_bussiness_address'];
                        $defaultGeocode = HelperOspropertyOpenStreetMap::getLatlongAdd($default_address);
                        $configClass['goole_default_lat'] = $defaultGeocode[0];
                        $configClass['goole_default_long'] = $defaultGeocode[1];
                    }

                    $thedeclat = $configClass['goole_default_lat'];
                    $thedeclong = $configClass['goole_default_long'];

                    $geoCodeArr = array();
                    $tmp		= new \stdClass();
                    $tmp->lat = $thedeclat;
                    $tmp->long = $thedeclong;
                    $geoCodeArr[0]	= $tmp;
                    ?>
                    <div id="map" style="width: 100%; height: 200px"></div>
                    <?php
                    HelperOspropertyOpenStreetMap::loadGMapinEditProperty($geoCodeArr, 'map', 'er_declat', 'er_declong');
                }
                ?>

                <br />
                <table>
                    <tr>
                        <td class="key" width="50%" style="border:1px solid #DDD;background-color:#efefef;">
                            <?php echo Text::_( 'Latitude' ); ?>
                            <input size="10" class="form-control" type="text" name="configuration[goole_default_lat]" id="er_declat" size="25" maxlength="100" value="<?php echo $thedeclat;?>" />
                        </td>
                        <td class="key" style="padding-left:10px;border:1px solid #DDD;background-color:#efefef;" width="50%">
                            <?php echo Text::_( 'Longitude' ); ?>
                            <input size="10" class="form-control" type="text" name="configuration[goole_default_long]" id="er_declong" size="25" maxlength="100" value="<?php echo $thedeclong;?>" />
                        </td>
                    </tr>
                </table>
            </div>
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('goole_use_map', Text::_( 'OS_SHOW_MAP_IN_DETAILS' ), Text::_('OS_SHOW_MAP_IN_DETAILS_EXPLAIN')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <?php
                    OspropertyConfiguration::showCheckboxfield('goole_use_map',$configs['goole_use_map']);
                    ?>
                </div>
            </div>
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('goole_map_resolution', Text::_( 'OS_DEFAULT_MAP_ZOOM' ), Text::_('OS_DEFAULT_MAP_ZOOM_EXPLAIN')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <input type="text" class="<?php echo$inputMiniClass; ?>" name="configuration[goole_map_resolution]" value="<?php echo isset($configs['goole_map_resolution'])?$configs['goole_map_resolution']:'' ?>" size="2">
                </div>
            </div>
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>">
                    <?php echo HelperOspropertyCommon::showLabel('limit_zoom', Text::_( 'OS_LIMIT_ZOOM_LEVEL' ), Text::_('OS_LIMIT_ZOOM_LEVEL_EXPLAIN')); ?>
                </div>
                <div class="<?php echo $controlsClass; ?>">
                    <input type="text" class="<?php echo$inputMiniClass; ?>" name="configuration[limit_zoom]" value="<?php echo isset($configs['limit_zoom'])?$configs['limit_zoom']:'15' ?>" size="2">
                </div>
            </div>
        </fieldset>

    </div>
</div>

<?php
// Map initialization script
if ($configClass['map_type'] == 0)
{
    // Google Maps
    ?>
    <script type="text/javascript">
    var map;
    var marker;
    function initialize() {
        var mapOptions = {
            zoom: <?php echo $map_zoom; ?>,
            center: new google.maps.LatLng(<?php echo $map_center_lat; ?>, <?php echo $map_center_long; ?>),
            mapTypeId: google.maps.MapTypeId.<?php echo $configs['goole_map_overlay']; ?>
        };
        map = new google.maps.Map(document.getElementById('map_canvas'), mapOptions);
        
        marker = new google.maps.Marker({
            position: new google.maps.LatLng(<?php echo $map_center_lat; ?>, <?php echo $map_center_long; ?>),
            map: map,
            draggable: true
        });
        
        google.maps.event.addListener(marker, 'dragend', function(event) {
            document.getElementById('map_center_lat').value = event.latLng.lat();
            document.getElementById('map_center_long').value = event.latLng.lng();
        });
        
        google.maps.event.addListener(map, 'zoom_changed', function() {
            document.getElementById('map_zoom').value = map.getZoom();
        });
    }
    
    if (typeof google !== 'undefined') {
        google.maps.event.addDomListener(window, 'load', initialize);
    }
    </script>
    <?php
}
else
{
    // OpenStreetMap
    ?>
    <script type="text/javascript">
    document.addEventListener('DOMContentLoaded', function() {
        var map = L.map('map_canvas').setView([<?php echo $map_center_lat; ?>, <?php echo $map_center_long; ?>], <?php echo $map_zoom; ?>);
        
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
        }).addTo(map);
        
        var marker = L.marker([<?php echo $map_center_lat; ?>, <?php echo $map_center_long; ?>], {draggable: true}).addTo(map);
        
        marker.on('dragend', function(event) {
            var position = marker.getLatLng();
            document.getElementById('map_center_lat').value = position.lat;
            document.getElementById('map_center_long').value = position.lng;
        });
        
        map.on('zoomend', function() {
            document.getElementById('map_zoom').value = map.getZoom();
        });
    });
    </script>
    <?php
}
?>
