<?php
/**
 * @package        Joomla
 * @subpackage     Membership Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2012 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\MembershipPro\Module\Statistics\Administrator\Dispatcher;

use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use Joomla\CMS\Factory;

defined('_JEXEC') or die;

/**
 * Dispatcher class for mod_mp_statistics
 */
class Dispatcher extends AbstractModuleDispatcher
{
	/**
	 * Get layout data for module
	 *
	 * @return array
	 */
	protected function getLayoutData()
	{
		$data = parent::getLayoutData();

		$data['data'] = $this->getStatisticsData();

		return $data;
	}

	/**
	 * The module uses component language files, so we override loadLanguage method to
	 * load component language
	 *
	 * @return void
	 */
	protected function loadLanguage()
	{
		Factory::getApplication()->getLanguage()
			->load('com_osmembership', JPATH_ADMINISTRATOR);
	}

	/**
	 * Get statistics data
	 *
	 * @return array
	 */
	private function getStatisticsData(): array
	{
		require_once JPATH_ADMINISTRATOR . '/components/com_osmembership/loader.php';

		\JLoader::register(
			'OSmembershipModelStatistics',
			JPATH_ADMINISTRATOR . '/components/com_osmembership/model/statistics.php'
		);

		/* @var \OSMembershipModelStatistics $model */
		$model = \MPFModel::getTempInstance('Statistics', 'OSMembershipModel');

		return $model->getData();
	}
}
