<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Editor\Editor;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;
use OSSolution\HelpdeskPro\Site\Helper\Route as HelpdeskProHelperRoute;

$app = Factory::getApplication();

$wa = $app->getDocument()
	->addScriptOptions('ticketsUrl', Route::_(HelpdeskProHelperRoute::getTicketsRoute(), false))
	->getWebAssetManager()
	->useScript('keepalive');

$assetVersion = HelpdeskProHelper::getInstalledVersion();

$editor = Editor::getInstance($app->get('editor'));

if (!$this->config->use_html_editor && $this->config->process_bb_code)
{
	$wa->registerAndUseScript(
		'com_helpdeskpro.helpdeskpro.bbcode',
		'media/com_helpdeskpro/assets/js/helpdeskpro.bbcode.js',
		['version' => $assetVersion]
	);
}

$wa->registerAndUseScript('com_helpdeskpro.site-ticket-form', 'media/com_helpdeskpro/js/site-ticket-form.js', ['version' => $assetVersion]);

$role = HelpdeskProHelper::getUserRole($this->userId);

/* @var $bootstrapHelper HelpdeskProHelperBootstrap */
$bootstrapHelper     = $this->bootstrapHelper;
$formHorizontalClass = $bootstrapHelper->getClassMapping('form form-horizontal');
$controlGroupClass   = $bootstrapHelper->getClassMapping('control-group');
$controlLabelClass   = $bootstrapHelper->getClassMapping('control-label');
$controlsClass       = $bootstrapHelper->getClassMapping('controls');
$btnClass            = $bootstrapHelper->getClassMapping('btn');
$btnPrimaryClass     = $bootstrapHelper->getClassMapping('btn btn-primary');
$clearFix            = $bootstrapHelper->getClassMapping('clearfix');
$formControl         = $bootstrapHelper->getClassMapping('form-control');
?>
<div id="hdp-container" class="hdp-container hpd-joomla4-container">
<h1 class="hdp-page-title"><?php echo $this->params->get('page_heading') ?: Text::_('HDP_NEW_TICKET'); ?></h1>
	<?php
		if (HelpdeskProHelper::isValidMessage($this->params->get('intro_text')))
		{
		?>
			<div class="hdp-intro-text <?php echo $clearFix; ?>"><?php echo $this->params->get('intro_text'); ?></div>
		<?php
		}
	?>
    <form class="<?php echo $formHorizontalClass; ?>" name="hdp_form" id="hdp_form" action="<?php echo Route::_('index.php?option=com_helpdeskpro&Itemid='.$this->Itemid); ?>" method="post" enctype="multipart/form-data">
    <?php
        if (!$this->userId)
        {
        ?>
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>"><?php echo Text::_('HDP_NAME'); ?><span class="required">*</span></div>
                <div class="<?php echo $controlsClass; ?>">
                    <input type="text" id="name" name="name" class="form-control uk-input validate[required]" value="<?php echo $this->escape($this->input->getString('name')); ?>" />
                </div>
            </div>
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>"><?php echo Text::_('HDP_EMAIL'); ?><span class="required">*</span></div>
                <div class="<?php echo $controlsClass; ?>">
                    <input type="text" id="email" name="email" class="form-control uk-input validate[required,custom[email]]" value="<?php echo $this->escape($this->input->getString('email')); ?>" />
                </div>
            </div>
        <?php
        }

        if (count($this->rowCategories) > 1)
        {
        ?>
            <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>"><?php echo Text::_('HDP_CATEGORY'); ?><span class="required">*</span></div>
                <div class="<?php echo $controlsClass; ?>">
                    <?php echo $this->lists['category_id'] ; ?>
                </div>
            </div>
        <?php
        }
    ?>
        <div class="<?php echo $controlGroupClass; ?>">
                <div class="<?php echo $controlLabelClass; ?>"><?php echo Text::_('HDP_SUBJECT'); ?><span class="required">*</span></div>
                <div class="<?php echo $controlsClass; ?>">
                       <input type="text" id="subject" name="subject" class="form-control uk-input validate[required]" value="<?php echo $this->escape($this->input->getString('subject')); ?>" size="50" />
                </div>
        </div>
        <?php
            if (isset($this->lists['priority_id']))
            {
            ?>
                <div class="<?php echo $controlGroupClass; ?>">
                    <div class="<?php echo $controlLabelClass; ?>"><?php echo Text::_('HDP_PRIORITY'); ?><span class="required">*</span></div>
                    <div class="<?php echo $controlsClass; ?>">
                        <?php echo $this->lists['priority_id'] ; ?>
                    </div>
                </div>
            <?php
            }

            $fields = $this->form->getFields();

            /* @var HDPFormField $field*/
            foreach ($fields as $field)
            {
                echo $field->getControlGroup(true, $this->bootstrapHelper);
            }
        ?>
        <div class="<?php echo $controlGroupClass; ?>">
            <div class="<?php echo $controlLabelClass; ?>"><?php echo Text::_('HDP_MESSAGE'); ?><span class="required">*</span></div>
            <div class="<?php echo $controlsClass; ?>">
                <?php
                    if ($this->config->use_html_editor)
                    {
                        echo $editor->display( 'message',  $this->input->getHtml('message'), '100%', '250', '75', '10', false);
                    }
                    else
                    {
                    ?>
                        <textarea rows="10" cols="70" class="hdp_fullwidth form-control uk-textarea validate[required]" name="message" id="message"><?php echo $this->escape($this->input->getString('message')); ?></textarea>
                    <?php
                    }
                ?>
            </div>
        </div>

        <?php
            if ($this->config->enable_attachment)
            {
            ?>
                <div class="<?php echo $controlGroupClass; ?>">
                    <div class="<?php echo $controlLabelClass; ?>"><?php echo Text::_('HDP_ATTACHMENTS'); ?></div>
                    <div class="<?php echo $controlsClass; ?>">
	                    <?php echo HelpdeskProHelperHtml::loadCommonLayout('common/tmpl/ticket_upload_attachments_form.php'); ?>
                    </div>
                </div>
            <?php
            }

			echo $this->loadCommonLayout('captcha');
        ?>
        <div class="form-actions">
            <input type="submit" name="btnSubmit" id="btnSubmitButton" class="<?php echo $btnPrimaryClass; ?>" value="<?php echo Text::_('HDP_SUBMIT_TICKET'); ?>" />
            <input type="button" name="btnCancel" id="btnCancelButton" class="<?php echo $btnPrimaryClass; ?>" value="<?php echo Text::_('HDP_CANCEL'); ?>" onclick="HDP.ticketList();" />
        </div>
        <?php
            if ($this->config->enable_attachment)
            {
                echo HelpdeskProHelperHtml::loadCommonLayout('common/tmpl/ticket_upload_attachments.php');
            }
        ?>
        <input type="hidden" name="option" value="com_helpdeskpro" />
        <input type="hidden" name="task" value="ticket.save" />
        <input type="hidden" name="Itemid" value="<?php echo $this->Itemid; ?>" />
	    <input type="text" name="<?php echo $this->config->get('honeypot_fieldname', 'hdp_my_own_website_name'); ?>" value="" autocomplete="off" class="<?php echo $this->config->get('honeypot_field_css_class', 'hpp-invisible-to-visitors'); ?>" />
	    <input type="hidden" name="<?php echo HelpdeskProHelper::getHashedFieldName(); ?>" value="<?php echo time(); ?>" />
        <?php
            if (count($this->rowCategories) == 1)
            {
                $categoryId = $this->rowCategories[0]->id;
            ?>
                <input type="hidden" name="category_id" value="<?php echo $categoryId; ?>" />
            <?php
            }

            echo HTMLHelper::_( 'form.token' );
        ?>
    </form>
</div>