<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;

/**
 * Layout variables
 * @var stdClass              $item
 * @var array                 $messages
 * @var \Joomla\CMS\User\User $user
 * @var \OSL\Config\Config    $config
 */

defined('_JEXEC') or die;

if (!count($messages))
{
    return;
}

$app = Factory::getApplication();

/* @var $bootstrapHelper HelpdeskProHelperBootstrap */
if ($app->isClient('site'))
{
	$bootstrapHelper     = HelpdeskProHelperBootstrap::getInstance();
}
else
{
	$bootstrapHelper     = HelpdeskProHelperBootstrap::getInstance();
}

$clearFix        = $bootstrapHelper->getClassMapping('clearfix');
$iconEdit        = $bootstrapHelper->getClassMapping('icon-edit');
$iconTrash       = $bootstrapHelper->getClassMapping('icon-trash');
$btn             = $bootstrapHelper->getClassMapping('btn');
$btnSmall        = $bootstrapHelper->getClassMapping('btn-small');
$rootUri         = Uri::root(true);
$currentUri      = Uri::getInstance()->toString();

$role = HelpdeskProHelper::getUserRole();

$defaultAvatarUrl = $rootUri . '/media/com_helpdeskpro/assets/images/avatars/person.svg';
?>
<div class="hdp_ticket_comments hdp-ticket-comments">
    <?php
        $hasAttachments = false;

        foreach ($messages as $message)
        {
	        if ($message->user_id)
	        {
		        $name = $message->name;
	        }
	        else
	        {
		        $name =  $item->name;
	        }
	        
	        $avatarUrl = $defaultAvatarUrl;

	        if ($message->user_id)
	        {
		        $avatar = HelpdeskProHelper::getUserAvatar($message->user_id);

		        if ($avatar && $avatar !=  'media/com_helpdeskpro/assets/images/avatars/icon-user.jpeg')
		        {
			        $avatarUrl = $rootUri . '/' . $avatar;
		        }
	        }
        ?>
            <div class="hdp-ticket-comment <?php echo $clearFix; ?>">
                <div class="hdp-ticket-comment-header <?php echo $clearFix; ?>>">
                    <span class="hpd-ticket-comment-user">
                        <img src="<?php echo $avatarUrl; ?>" class="hdp-user-avatar" alt="<?php echo $name; ?>" />
                        <?php echo $name; ?> - <a id="<?php echo $message->id; ?>" href="#<?php echo $message->id; ?>">[#<?php echo $message->id; ?>]</a>
                    </span>
                    <span class="hdp-ticket-comment-time <?php echo $bootstrapHelper->getClassMapping('pull-right'); ?>">
                        <?php
                        echo  HTMLHelper::_('date.relative', $message->date_added, $config->date_format);

                        if ($message->internal)
                        {
                        ?>
	                        <span class="hdp-internal-badge"><?php echo Text::_('HDP_INTERNAL_BADGE'); ?></span>
	                    <?php
                        }

                        if (HelpdeskProHelper::canUpdateComment($user, $message->id))
                        {
                        ?>
                            <button type="button" class="<?php echo $btn . ' ' . $btnSmall; ?>  hdp-edit-comment-button" data-comment-id="<?php echo $message->id; ?>" title="<?php echo Text::_('HDP_EDIT_THIS_COMMENT'); ?>"><i class="<?php echo $iconEdit; ?>"></i></button>
                        <?php
                        }

                        if (HelpdeskProHelper::canDeleteComment($user, $message->id))
                        {
                        ?>
                            <button type="button" class="<?php echo $btn . ' ' . $btnSmall; ?> hdp-delete-comment-button" data-comment-id="<?php echo $message->id; ?>" title="<?php echo Text::_('HDP_DELETE_THIS_COMMENT'); ?>"><i class="<?php echo $iconTrash; ?>"></i></button>
                        <?php
                        }
                        ?>
                    </span>
                </div>
                <div class="hdp-ticket-comment-message" id="ticket-comment-<?php echo $message->id; ?>">
	                <?php
	                if ($config->process_bb_code)
	                {
		                echo HelpdeskProHelper::processBBCode($message->message);
	                }
	                else
	                {
		                if ($config->use_html_editor)
		                {
			                echo $message->message;
		                }
		                else
		                {
			                echo nl2br($message->message);
		                }
	                }
	                ?>
                </div>
                <?php
                    if ($message->attachments)
                    {
                        $hasAttachments = true;

	                    echo HelpdeskProHelperHtml::loadCommonLayout('common/tmpl/ticket_attachments.php', ['item' => $message]);
                    }
                ?>
            </div>
        <?php
        }

        if ($hasAttachments)
        {
	        $assetVersion = HelpdeskProHelper::getInstalledVersion();

	        // Load luminous library
	        $app->getDocument()
		        ->getWebAssetManager()
		        ->registerAndUseScript('com_helpdeskpro.luminous', 'media/com_helpdeskpro/assets/js/luminous/luminous.min.js', ['defer' => true, 'version' => $assetVersion])
		        ->registerAndUseStyle('com_helpdeskpro.luminous', 'media/com_helpdeskpro/assets/js/luminous/luminous-basic.min.css', ['version' => $assetVersion]);
        }
    ?>
</div>
