<?php
/**
 * @package     Lmstarbiats
 * @subpackage  com_lmstarbiats
 *
 * @author      Abdul waheed <info@abdulwaheed.pk>
 * @website		www.abdulwaheed.pk
 * @copyright   Copyright (C) abdulwaheed.pk All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Abdul\Component\Lmstarbiats\Site\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Versioning\VersionableControllerTrait;
use Joomla\Input\Input;
use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Uri\Uri;

/**
 * Controller for a single park_exchg_b
 *
 * @since  1.6
 */
class CourseController extends FormController
{
	
	/**
     * Constructor.
     *
     * @param   array                $config   An optional associative array of configuration settings.
     * Recognized key values include 'name', 'default_task', 'model_path', and
     * 'view_path' (this list is not meant to be comprehensive).
     * @param   MVCFactoryInterface  $factory  The factory.
     * @param   CMSApplication       $app      The Application for the dispatcher
     * @param   Input                $input    Input
     *
     * @since   3.0
     */
    public function __construct($config = array(), MVCFactoryInterface $factory = null, $app = null, $input = null)
    {
        parent::__construct($config, $factory, $app, $input);
		$this->registerTask( 'add'  , 	'edit' );
		$this->registerTask( 'apply', 	'save' );
		$this->registerTask( 'register','register' );
		$this->registerTask( 'review', 	'review' );
		$this->registerTask( 'qa', 		'qa' );
		$this->registerTask( 'defaultcourse', 	'defaultcourse' );

    }
	
	// Send Message by Student
	public function sendMSG()
	{
		$user_= Factory::getUser();
        $app    = Factory::getApplication();
        $input  = $app->input;
		$db = Factory::getDBO();
//		$post = $app->input->post->get('jform', array(), 'array');
		$s_id = ($app->input->get('s_id', 0, 'INT')>0) ? $app->input->get('s_id', 0, 'INT')
		: $app->input->get('active_s', 0, 'INT');

		$txtmsg = $app->input->get('msg', "", 'STRING');
		$course_id = $app->input->get('course_id', 0, 'INT');
		$Itemid= $app->input->get('Itemid', 0, 'INT');
		$this->getCourse($course_id);
//		echo $msg;exit;
 // echo '<pre>';print_r($this->getCourse($course_id)->created_by);echo '</pre>';
//		$txtmsg=$post["msg"];

		// Stop Sharing Contact info
		// Regular Expressions
		$pattern = "'/(\b\d{10,}\b)|(\+?\d{2,4}[-.\s]?\d{3}[-.\s]?\d{3,4})|([a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,})|(facebook|twitter|instagram|t\.me|wa\.me|whatsapp|telegram|discord|skype|linkedin|snapchat|tiktok|pinterest|reddit|tumblr|wechat|viber|line|messenger)/i'";
		
/*
STOP CONTACT INFO
		if (preg_match($pattern, $txtmsg)) {
//			echo "Message Blocked: Contact info sharing not allowed!";
			$this->setMessage(Text::_("COM_QARIS_MESSAGE_BLOCKED"), 'error');
			$this->setRedirect('index.php?option=com_qaris&view=quras');
		} else {
		//    echo "Message Sent Successfully!";
*/

		$v_id=$s_id;
		$m_id=$this->getCourse($course_id)->created_by;
		$datetime=date("Y-m-d H:i:s");//$post["datetime"];
		$recipient=Factory::getUser($m_id);
		/*
		$subject="ðŸ“– New Tajweed Learning Request";
		$body='
		<p>Aslam o alaikum <strong>Qari Sahib</strong>,</p>
        <p>A student has shown interest in learning Tajweed from you on our website.</p>
        <h3 style="color: #333;">ðŸ“Œ Student Details:</h3>
        <ul>
            <li><strong>Name:</strong> {'.$user_->name.'}</li>
            <li><strong>Email:</strong> {'.$user_->email.'}</li>
            <li><strong>Message:</strong> {'.$txtmsg.'}</li>
        </ul>
        <p>ðŸ“… Please respond to the student(shagird) at your earliest convenience.</p>
        <hr>
        <p style="font-size: 12px; color: #777;">This is an automated notification from <a href="https://ravaabit.com" style="color: #008000;">ravaabit.com</a>.</p>
		';

//		$this->sendEmail( $recipient->email, $subject, $body);
		*/

/****************************
PUSHER
***********************************/
		require_once JPATH_COMPONENT. '/pusher/vendor/autoload.php';
//	echo JPATH_COMPONENT. '/pusher/vendor/autoload.php' . ' '. file_exists(JPATH_COMPONENT. '/pusher/vendor/autoload.php');exit;

		$pusher = new Pusher\Pusher(
/*
app_id = "2015687"
key = "9d933ea36c1205020ef8"
secret = "04c69ab41726ff6f8bb2"
cluster = "ap1"
*/
			'9d933ea36c1205020ef8',  // From Pusher dashboard
			'04c69ab41726ff6f8bb2',
			'2015687',
			[
				'cluster' => 'ap1',
				'useTLS' => true
			]
		);
		
		// When saving a message (in your controller)
		$data = [
			's_id' => $v_id, 
			'm_id' => $m_id,
			'sender' => 's',
			'course_id' => $course_id, 
			'txtmsg' => $txtmsg, 
			'datetime' => $datetime, 
			'ordering' => 1, 
			'state' => 1
		];

	//	Save to your table first
	//	$db->insertObject('#__lmst_course_msg', $data);

		// Then push to Pusher
		$pusher->trigger(
			"course-$course_id", // Channel name
			'new-message',     // Event name
			$data             // Actual message data
		);
/****************************
PUSHER Ends
***********************************/


		$query = "INSERT INTO #__lmst_course_msg(s_id,m_id,sender,course_id,txtmsg,datetime,ordering,state) 
		VALUES($v_id, $m_id, 's', $course_id, '$txtmsg', '$datetime', 1, 1)";
 // 	echo $query;exit;		

		$db->setQuery($query);
		$result = $db->execute();
		if(!$result)
		  $this->setMessage("Something went wrong.", 'error');
		else
		  $this->setMessage("Message Sent Successfully.", 'success');

//	echo $query;exit;
		$this->setRedirect("index.php?option=com_lmstarbiats&view=course&Itemid=$Itemid");
		
	}
	
	// Load Chathistory
	public function chathistory($sid=0,$mid=0)
	{
		$user_loggedin= Factory::getUser();
		$db = Factory::getDBO();
        $app    = Factory::getApplication();
        $input  = $app->input;
		$s_id= ($sid>0) ? $sid : $app->input->get('s_id', 0, 'INT');
		$m_id= ($mid>0) ? $mid : $app->input->get('m_id', 0, 'INT');
		$course_id = $app->input->get('course_id', 0, 'INT');

		echo
			'<script>jQuery(".heading").show();jQuery(".btnhire").show();jQuery("#sendBox").addClass("d-flex").show();</script>';
		
		$user_s= Factory::getUser($s_id);
		$user_q= Factory::getUser($m_id);

		$query = "SELECT * from #__lmst_course_msg where s_id=$s_id AND m_id=$m_id AND course_id=$course_id order by datetime DESC";
  
  //	echo $query;exit;

		$db->setQuery($query);
		$result=$db->loadObjectList();
 //		echo '<pre>'.count($result);print_r($result);exit;
		if(count($result)>0) 
		{
//			$html='<table class="table "><tbody>';

			$html2=
			'<div class="position-relative">
			<div class="">';
			
			$sender_='';$msgs='';
			// Extract existing messages from the database
			$existing_msgs = [];
			foreach ($result as $item) {
				$existing_msgs[] = $item->txtmsg; // Store all used messages
			}

			for($j=0;$j<count($result);$j++) {
				
				$item=$result[$j];
				
				//$html.='<li class="shadow mb-1 mb-md-2 bg-body rounded p-2 p-md-3 ">'.$item->txtmsg.'</li>';
				$sender=($item->sender=='m')?Factory::getUser($m_id):Factory::getUser($s_id);
				// If next row is same user, hide its name
				// to make conversation like fb
			//	$html.='<tr><th>'.$sender_.":".$sender->name.'</th></tr>';
			
				if($item->sender=='m')
				{
					$css_1='d-block text-white mb-2';
					$css_2='fw-bold pt-1 pb-2 bg-info border rounded-circle me-2 ';
					$css_3='bg-info ps-2 pe-2 pt-1 pb-1 rounded border-dark';
				}
				else
				{
					$css_1='d-block mb-2';
					$css_2='fw-bold pt-1 pb-2 bg-light border rounded-circle me-2 ';
					$css_3='ps-2 pe-2 pt-1 pb-1 bg-light border rounded';
				}

				if($sender_!=$item->sender)
				{
					$html2.=
					'<div class="'.$css_1.'"><div style="display:inline-flex;"><div class="'.$css_2.'" style="width:30px; height:30px;text-align:center;">'.substr(strtoupper($sender->name), 0, 1).'</div><div class="'.$css_3.'">'.$item->txtmsg.'</div>';

				//	if($j>0) 
						$html2.='</div></div>';
				}
				else
				{
					$html2.=
					'<div class="'.$css_1.'"><div style="display:inline-flex;"><div class="'.$css_2.'" style="width:30px; height:30px;text-align:center;">'.substr(strtoupper($sender->name), 0, 1).'</div><div class="'.$css_3.'">'.$item->txtmsg.'</div>';

//					if($j>0) 
						$html2.='</div></div>';
				}

				$sender_=$item->sender;
				

			} // ENDS : for($j=0;$j<count($result);$j++) {
			
			// Only show to Student
			$predefined_msg=array('Asalam o alaikum','Are you available to teach me?');

			$params = ComponentHelper::getParams('com_qaris');
			$student_gid= $params->get('student_gid', 10);
			if(in_array($student_gid, $user_loggedin->groups) )
			{
				foreach ($predefined_msg as $msg) {
					if(!in_array($msg, $existing_msgs))
					{
					//	echo !in_array($item->txtmsg, $predefined_msg).'here'.$msg;exit;
					$msgs.='<button class="btn btn-primary predefined-message-item" data-value="'.$msg.'">'.$msg.'</button>';
					}
				}
			}

			$html2.=
				'
				</div>
				</div>';
/*
PREDEFINED MESSAGES
			$html2.='
				<div class="predefined-messages-container position-absolute" style="bottom:0; z-index:9999;">
                    <div class="predefined-messages-list">
                        '.$msgs.'
                        <!-- Add more predefined messages as needed -->
                    </div>
                </div>
				';
*/
			$html2.="
                <input type='hidden' name='active_s' id='active_s2' value='$s_id' />
                <input type='hidden' name='active_m' id='active_m2' value='$m_id' />
<script>
// Send predefined message
jQuery('.predefined-message-item').click(function(e) {
    var msg=jQuery(this).attr('data-value');

 // alert(msg); return;
	jQuery(this).attr('disabled','true');
	jQuery(this).addClass('disabled');
	jQuery(this).addClass('btn-outline-secondary');
	jQuery(this).removeClass('btn-primary');

	/*	Send msg	*/
	sendReply_2(msg);
});

function sendReply_2(msg) {
	const replyMessage = msg;
	const active_s = document.getElementById('active_s2').value;
	const active_m = document.getElementById('active_m2').value;
	const sender = '$sender_'

	if (replyMessage.trim()) {
	//    alert('Reply sent: ' + replyMessage);
	
		jQuery.ajax({
			type: 'POST',
			url: 'index.php?option=com_lmstarbiats&task=course.sendMSG&active_s='+active_s+'&active_m='+active_m+'&msg='+replyMessage+'&sender='+sender+'&course_id=".$course_id."',
			//data:'keyword='+jQuery(this).val(),
			beforeSend: function(){
			
			},
			success: function(data){
			 //	alert(data);
				jQuery('#message-thread').html(data);
			}
		});
		document.getElementById('reply-message').value = '';
	} else {
		alert('Please type a reply message before sending.');
	}
}

</script>";

			echo $html2;
		}
		exit;
	}
	
	
	
	public function updateprogress()
	{
		echo 'here';exit;
 		$userid= $this->input->get('userid', "0", 'INT');
        $course_id= $this->input->get('course_id', "", 'INT');
		$lesson_id= $this->input->get('lesson_id', "", 'INT');
		$enrollment_id= $this->input->get('enrollment_id', "", 'INT');
//		$progress_percentage= $this->input->get('progress_percentage', "", 'INT');
//		$last_updated= $this->input->get('last_updated', "", 'STRING');

		$db = Factory::getContainer()->get('DatabaseDriver');
		$q1="SELECT id FROM t1d1f_lmst_user_progress WHERE user_id=$userid";
		$db->setQuery($query2a);
		$result1=$db->loadObject();
foreach($result1 as $result){echo $result->enrollment_id.':'.$result->progress_percentage.':'.$result->last_updated;}exit;
		$query2a="INSERT INTO (user_id,	course_id, lesson_id, enrollment_id, progress_percentage, last_updated) 
VALUES ($user_id,	$course_id, $lesson_id, $enrollment_id, '$progress_percentage', '$last_updated') ";
//		echo $query2a;exit;
		$db->setQuery($query2a);
		$result=$db->execute();
//	echo $query2aResult;exit;
		$msg=Text::_("COM_LMST_QA_FAILURE");

		if($result) {
			echo Text::_("COM_LMST_QA_SUCCESS");exit;
		}

$user_id = $data['user_id'];
$content_id = $data['content_id'];
$content_type = $data['content_type'];
$progress = $data['progress'];

// Check if a record already exists
$stmt = $conn->prepare("SELECT id FROM user_progress WHERE user_id = ? AND content_id = ? AND content_type = ?");
$stmt->bind_param("iis", $user_id, $content_id, $content_type);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    // Update the existing record
    $stmt = $conn->prepare("UPDATE user_progress SET progress = ?, last_updated = NOW() WHERE user_id = ? AND content_id = ? AND content_type = ?");
    $stmt->bind_param("diis", $progress, $user_id, $content_id, $content_type);
} else {
    // Insert a new record
    $stmt = $conn->prepare("INSERT INTO user_progress (user_id, content_id, progress, content_type) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("iids", $user_id, $content_id, $progress, $content_type);
}

if ($stmt->execute()) {
    echo json_encode(['status' => 'success']);
} else {
    echo json_encode(['status' => 'error', 'message' => $stmt->error]);
}

$stmt->close();
$conn->close();

	}
	public function defaultcourse() {
		
		$params = ComponentHelper::getParams('com_lmstarbiats');

		// To get the value of the param.
		$courseimg_ = Uri::root().$params->get('courseimg');
		
		echo '<div style="width:100%; position: relative;">
<h1 style="margin-top: 30px; text-align: center">
        <img src="'.$courseimg_. '" alt="'.Text::_('COM_LMST_SELECT_COURSE_CONTENT').'"  style="max-width:100%; display:block; height:auto; margin: 0 auto;" /> 
	</h1>
	</div>';
		exit;
	}

 // Function to get the client IP address
	public function get_client_ip() {
		$ipaddress = '';
		if (getenv('HTTP_CLIENT_IP'))
			$ipaddress = getenv('HTTP_CLIENT_IP');
		else if(getenv('HTTP_X_FORWARDED_FOR'))
			$ipaddress = getenv('HTTP_X_FORWARDED_FOR');
		else if(getenv('HTTP_X_FORWARDED'))
			$ipaddress = getenv('HTTP_X_FORWARDED');
		else if(getenv('HTTP_FORWARDED_FOR'))
			$ipaddress = getenv('HTTP_FORWARDED_FOR');
		else if(getenv('HTTP_FORWARDED'))
		   $ipaddress = getenv('HTTP_FORWARDED');
		else if(getenv('REMOTE_ADDR'))
			$ipaddress = getenv('REMOTE_ADDR');
		else
			$ipaddress = 'UNKNOWN';
		return $ipaddress;
	}

	public function qa() {
        $userid= $this->input->get('userid', "0", 'INT');
        $q= $this->input->get('m', "", 'STRING');
		$ans='';
        $course_id= $this->input->get('course_id', "", 'INT');
        $submit_date= $this->input->get('submit_date', "", 'STRING');
		$ip=$this->get_client_ip();

		$db = Factory::getContainer()->get('DatabaseDriver');

//		$query2a	= $db->getQuery(true);

$query2a="INSERT INTO #__lmst_course_qa(course_id, userid, question, answer, submit_date, ip) 
VALUES ($course_id, $userid, '$q', '$ans', '$submit_date','$ip') ";
//		echo $query2a;exit;
		$db->setQuery($query2a);
		$result=$db->execute();
//	echo $query2aResult;exit;
		$msg=Text::_("COM_LMST_QA_FAILURE");

		if($result) {
			echo Text::_("COM_LMST_QA_SUCCESS");exit;
		}

	}

	public function review() {
        $userid= $this->input->get('userid', "0", 'INT');
        $username= $this->input->get('username', "", 'STRING');
		$useremail= $this->input->get('useremail', "", 'STRING');
        $txtcomments= $this->input->get('txtcomments', "", 'STRING');
        $course_id= $this->input->get('course_id', "", 'INT');
        $rating= $this->input->get('rating', "0", 'INT');
        $submit_date= $this->input->get('submit_date', "", 'STRING');

		$db = Factory::getContainer()->get('DatabaseDriver');

//		$query2a	= $db->getQuery(true);

		$query2a="INSERT INTO #__lmst_course_reviews(course_id, userid, username, useremail, txtComments, rating, submit_date, ip, state, ordering) 
VALUES ($course_id, $userid, '$username', '$useremail', '$txtcomments', $rating, '$submit_date', '".$_SERVER['REMOTE_ADDR']."', 0, 1) ";
//		echo $query2a;exit;
		$db->setQuery($query2a);
		$result=$db->execute();
//	echo $query2aResult;exit;
		$msg='<h3 style="color:red; font-weight:bold;">'.Text::_("COM_LMST_REVIEW_RATING_SUBMISSION_SAVE_ERROR_MSG").'</h3><hr />';
		if($result) {
	//		echo $query2a;
		$msg='<h3 style="color:green; font-weight:bold;">'.Text::_("COM_LMST_REVIEW_RATING_SUBMISSION_SAVE_SUCCESS_MSG").'</h3><hr />';
		}
		echo $msg;exit;

	}


	public function getLessonInfo() {

		$app    = Factory::getApplication();
        $input  = $app->input;
		$id= $input->get('id', 0, 'INT');
		
		$db = Factory::getDBO();
		//$where = ($id == "") ? "where id=".$id : "";
		$query = "select * from #__lmst_lessons where id=".$id;
//	echo $query;exit;
		$db->setQuery($query);
		$result = $db->loadObject();

		echo (isset($result->description)&&$result->description!="")?$result->description:"";
		exit;
	}
	
	public function getCourseInfo($course_id) {
		$db = Factory::getDBO();
		//$where = ($id == "") ? "where id=".$id : "";
		$query = "select * from #__lmst_courses where id=".$course_id;
//	echo $query;exit;
		$db->setQuery($query);
		$result = $db->loadObject();

		return $result;
	}
	
	public function getCountryTaxes($selected=""){
		
		$db = Factory::getContainer()->get('DatabaseDriver'); //J4 onwards, outside of the Model or Table  
		$query = "SELECT * from #__lmst_taxes where state=1";
		$db->setQuery($query);
		$result=$db->loadObjectList();
		$default="";
		## Initialize array to store dropdown options ##
		$options = array();
		
		$options[] = HTMLHelper::_('select.option', '', Text::_("COM_LMST_C_COUNTRY_SELECT"));
		for($i=0; $i<count($result); $i++) :
			## Create $value ##
			$item=$result[$i];
			$options[] = HTMLHelper::_('select.option', $item->tax, $item->country);
		endfor;
		
		## Create <select name="month" class="inputbox"></select> ##
		$dropdown = HTMLHelper::_('select.genericlist', $options, 'jform[country]', 'class="mt-1 mb-2" style="width: 70%; padding: 0.5rem; font-size: 1.6rem; " onchange="updateprice(this.value);"', 'value', 'text', $default);
		
		## Output created <select> list ##
		return $dropdown;
	}
	
	public function getCountryList($selected=""){
		$html='
		<select class="mt-1 mb-2" style="width: 70%; padding: 0.5rem; font-size: 1.6rem; ">
			<option value="Pakistan">Pakistan</option>
			<option value="Afghanistan">Afghanistan</option>
			<option value="Åland Islands">Åland Islands</option>
			<option value="Albania">Albania</option>
			<option value="Algeria">Algeria</option>
			<option value="American Samoa">American Samoa</option>
			<option value="Andorra">Andorra</option>
			<option value="Angola">Angola</option>
			<option value="Anguilla">Anguilla</option>
			<option value="Antarctica">Antarctica</option>
			<option value="Antigua and Barbuda">Antigua and Barbuda</option>
			<option value="Argentina">Argentina</option>
			<option value="Armenia">Armenia</option>
			<option value="Aruba">Aruba</option>
			<option value="Australia">Australia</option>
			<option value="Austria">Austria</option>
			<option value="Azerbaijan">Azerbaijan</option>
			<option value="Bahamas">Bahamas</option>
			<option value="Bahrain">Bahrain</option>
			<option value="Bangladesh">Bangladesh</option>
			<option value="Barbados">Barbados</option>
			<option value="Belarus">Belarus</option>
			<option value="Belgium">Belgium</option>
			<option value="Belize">Belize</option>
			<option value="Benin">Benin</option>
			<option value="Bermuda">Bermuda</option>
			<option value="Bhutan">Bhutan</option>
			<option value="Bolivia">Bolivia</option>
			<option value="Bosnia and Herzegovina">Bosnia and Herzegovina</option>
			<option value="Botswana">Botswana</option>
			<option value="Bouvet Island">Bouvet Island</option>
			<option value="Brazil">Brazil</option>
			<option value="British Indian Ocean Territory">British Indian Ocean Territory</option>
			<option value="Brunei Darussalam">Brunei Darussalam</option>
			<option value="Bulgaria">Bulgaria</option>
			<option value="Burkina Faso">Burkina Faso</option>
			<option value="Burundi">Burundi</option>
			<option value="Cambodia">Cambodia</option>
			<option value="Cameroon">Cameroon</option>
			<option value="Canada">Canada</option>
			<option value="Cape Verde">Cape Verde</option>
			<option value="Cayman Islands">Cayman Islands</option>
			<option value="Central African Republic">Central African Republic</option>
			<option value="Chad">Chad</option>
			<option value="Chile">Chile</option>
			<option value="China">China</option>
			<option value="Christmas Island">Christmas Island</option>
			<option value="Cocos (Keeling) Islands">Cocos (Keeling) Islands</option>
			<option value="Colombia">Colombia</option>
			<option value="Comoros">Comoros</option>
			<option value="Congo">Congo</option>
			<option value="Congo, The Democratic Republic of The">Congo, The Democratic Republic of The</option>
			<option value="Cook Islands">Cook Islands</option>
			<option value="Costa Rica">Costa Rica</option>
			<option value="Cote Divoire">Cote Divoire</option>
			<option value="Croatia">Croatia</option>
			<option value="Cuba">Cuba</option>
			<option value="Cyprus">Cyprus</option>
			<option value="Czech Republic">Czech Republic</option>
			<option value="Denmark">Denmark</option>
			<option value="Djibouti">Djibouti</option>
			<option value="Dominica">Dominica</option>
			<option value="Dominican Republic">Dominican Republic</option>
			<option value="Ecuador">Ecuador</option>
			<option value="Egypt">Egypt</option>
			<option value="El Salvador">El Salvador</option>
			<option value="Equatorial Guinea">Equatorial Guinea</option>
			<option value="Eritrea">Eritrea</option>
			<option value="Estonia">Estonia</option>
			<option value="Ethiopia">Ethiopia</option>
			<option value="Falkland Islands (Malvinas)">Falkland Islands (Malvinas)</option>
			<option value="Faroe Islands">Faroe Islands</option>
			<option value="Fiji">Fiji</option>
			<option value="Finland">Finland</option>
			<option value="France">France</option>
			<option value="French Guiana">French Guiana</option>
			<option value="French Polynesia">French Polynesia</option>
			<option value="French Southern Territories">French Southern Territories</option>
			<option value="Gabon">Gabon</option>
			<option value="Gambia">Gambia</option>
			<option value="Georgia">Georgia</option>
			<option value="Germany">Germany</option>
			<option value="Ghana">Ghana</option>
			<option value="Gibraltar">Gibraltar</option>
			<option value="Greece">Greece</option>
			<option value="Greenland">Greenland</option>
			<option value="Grenada">Grenada</option>
			<option value="Guadeloupe">Guadeloupe</option>
			<option value="Guam">Guam</option>
			<option value="Guatemala">Guatemala</option>
			<option value="Guernsey">Guernsey</option>
			<option value="Guinea">Guinea</option>
			<option value="Guinea-bissau">Guinea-bissau</option>
			<option value="Guyana">Guyana</option>
			<option value="Haiti">Haiti</option>
			<option value="Heard Island and Mcdonald Islands">Heard Island and Mcdonald Islands</option>
			<option value="Holy See (Vatican City State)">Holy See (Vatican City State)</option>
			<option value="Honduras">Honduras</option>
			<option value="Hong Kong">Hong Kong</option>
			<option value="Hungary">Hungary</option>
			<option value="Iceland">Iceland</option>
			<option value="India">India</option>
			<option value="Indonesia">Indonesia</option>
			<option value="Iran, Islamic Republic of">Iran, Islamic Republic of</option>
			<option value="Iraq">Iraq</option>
			<option value="Ireland">Ireland</option>
			<option value="Isle of Man">Isle of Man</option>
			<option value="Italy">Italy</option>
			<option value="Jamaica">Jamaica</option>
			<option value="Japan">Japan</option>
			<option value="Jersey">Jersey</option>
			<option value="Jordan">Jordan</option>
			<option value="Kazakhstan">Kazakhstan</option>
			<option value="Kenya">Kenya</option>
			<option value="Kiribati">Kiribati</option>
			<option value="Korea">Korea</option>
			<option value="Korea, Republic of">Korea, Republic of</option>
			<option value="Kuwait">Kuwait</option>
			<option value="Kyrgyzstan">Kyrgyzstan</option>
			<option value="Latvia">Latvia</option>
			<option value="Lebanon">Lebanon</option>
			<option value="Lesotho">Lesotho</option>
			<option value="Liberia">Liberia</option>
			<option value="Libyan Arab Jamahiriya">Libyan Arab Jamahiriya</option>
			<option value="Liechtenstein">Liechtenstein</option>
			<option value="Lithuania">Lithuania</option>
			<option value="Luxembourg">Luxembourg</option>
			<option value="Macao">Macao</option>
			<option value="Macedonia, The Former Yugoslav Republic of">Macedonia, The Former Yugoslav Republic of</option>
			<option value="Madagascar">Madagascar</option>
			<option value="Malawi">Malawi</option>
			<option value="Malaysia">Malaysia</option>
			<option value="Maldives">Maldives</option>
			<option value="Mali">Mali</option>
			<option value="Malta">Malta</option>
			<option value="Marshall Islands">Marshall Islands</option>
			<option value="Martinique">Martinique</option>
			<option value="Mauritania">Mauritania</option>
			<option value="Mauritius">Mauritius</option>
			<option value="Mayotte">Mayotte</option>
			<option value="Mexico">Mexico</option>
			<option value="Micronesia, Federated States of">Micronesia, Federated States of</option>
			<option value="Moldova, Republic of">Moldova, Republic of</option>
			<option value="Monaco">Monaco</option>
			<option value="Mongolia">Mongolia</option>
			<option value="Montenegro">Montenegro</option>
			<option value="Montserrat">Montserrat</option>
			<option value="Morocco">Morocco</option>
			<option value="Mozambique">Mozambique</option>
			<option value="Myanmar">Myanmar</option>
			<option value="Namibia">Namibia</option>
			<option value="Nauru">Nauru</option>
			<option value="Nepal">Nepal</option>
			<option value="Netherlands">Netherlands</option>
			<option value="Netherlands Antilles">Netherlands Antilles</option>
			<option value="New Caledonia">New Caledonia</option>
			<option value="New Zealand">New Zealand</option>
			<option value="Nicaragua">Nicaragua</option>
			<option value="Niger">Niger</option>
			<option value="Nigeria">Nigeria</option>
			<option value="Niue">Niue</option>
			<option value="Norfolk Island">Norfolk Island</option>
			<option value="Northern Mariana Islands">Northern Mariana Islands</option>
			<option value="Norway">Norway</option>
			<option value="Oman">Oman</option>
			<option value="Palau">Palau</option>
			<option value="Palestinian Territory, Occupied">Palestinian Territory, Occupied</option>
			<option value="Panama">Panama</option>
			<option value="Papua New Guinea">Papua New Guinea</option>
			<option value="Paraguay">Paraguay</option>
			<option value="Peru">Peru</option>
			<option value="Philippines">Philippines</option>
			<option value="Pitcairn">Pitcairn</option>
			<option value="Poland">Poland</option>
			<option value="Portugal">Portugal</option>
			<option value="Puerto Rico">Puerto Rico</option>
			<option value="Qatar">Qatar</option>
			<option value="Reunion">Reunion</option>
			<option value="Romania">Romania</option>
			<option value="Russian Federation">Russian Federation</option>
			<option value="Rwanda">Rwanda</option>
			<option value="Saint Helena">Saint Helena</option>
			<option value="Saint Kitts and Nevis">Saint Kitts and Nevis</option>
			<option value="Saint Lucia">Saint Lucia</option>
			<option value="Saint Pierre and Miquelon">Saint Pierre and Miquelon</option>
			<option value="Saint Vincent and The Grenadines">Saint Vincent and The Grenadines</option>
			<option value="Samoa">Samoa</option>
			<option value="San Marino">San Marino</option>
			<option value="Sao Tome and Principe">Sao Tome and Principe</option>
			<option value="Saudi Arabia">Saudi Arabia</option>
			<option value="Senegal">Senegal</option>
			<option value="Serbia">Serbia</option>
			<option value="Seychelles">Seychelles</option>
			<option value="Sierra Leone">Sierra Leone</option>
			<option value="Singapore">Singapore</option>
			<option value="Slovakia">Slovakia</option>
			<option value="Slovenia">Slovenia</option>
			<option value="Solomon Islands">Solomon Islands</option>
			<option value="Somalia">Somalia</option>
			<option value="South Africa">South Africa</option>
			<option value="South Georgia and The South Sandwich Islands">South Georgia and The South Sandwich Islands</option>
			<option value="Spain">Spain</option>
			<option value="Sri Lanka">Sri Lanka</option>
			<option value="Sudan">Sudan</option>
			<option value="Suriname">Suriname</option>
			<option value="Svalbard and Jan Mayen">Svalbard and Jan Mayen</option>
			<option value="Swaziland">Swaziland</option>
			<option value="Sweden">Sweden</option>
			<option value="Switzerland">Switzerland</option>
			<option value="Syrian Arab Republic">Syrian Arab Republic</option>
			<option value="Taiwan">Taiwan</option>
			<option value="Tajikistan">Tajikistan</option>
			<option value="Tanzania, United Republic of">Tanzania, United Republic of</option>
			<option value="Thailand">Thailand</option>
			<option value="Timor-leste">Timor-leste</option>
			<option value="Togo">Togo</option>
			<option value="Tokelau">Tokelau</option>
			<option value="Tonga">Tonga</option>
			<option value="Trinidad and Tobago">Trinidad and Tobago</option>
			<option value="Tunisia">Tunisia</option>
			<option value="Turkey">Turkey</option>
			<option value="Turkmenistan">Turkmenistan</option>
			<option value="Turks and Caicos Islands">Turks and Caicos Islands</option>
			<option value="Tuvalu">Tuvalu</option>
			<option value="Uganda">Uganda</option>
			<option value="Ukraine">Ukraine</option>
			<option value="United Arab Emirates">United Arab Emirates</option>
			<option value="United Kingdom">United Kingdom</option>
			<option value="United States">United States</option>
			<option value="United States Minor Outlying Islands">United States Minor Outlying Islands</option>
			<option value="Uruguay">Uruguay</option>
			<option value="Uzbekistan">Uzbekistan</option>
			<option value="Vanuatu">Vanuatu</option>
			<option value="Venezuela">Venezuela</option>
			<option value="Viet Nam">Viet Nam</option>
			<option value="Virgin Islands, British">Virgin Islands, British</option>
			<option value="Virgin Islands, U.S.">Virgin Islands, U.S.</option>
			<option value="Wallis and Futuna">Wallis and Futuna</option>
			<option value="Western Sahara">Western Sahara</option>
			<option value="Yemen">Yemen</option>
			<option value="Zambia">Zambia</option>
			<option value="Zimbabwe">Zimbabwe</option>
				</select>
				';
			return $html;
	
	}

	public function getCourse($course_id) {
		$db = Factory::getDBO();
		$query = "Select * from #__lmst_courses where id=$course_id ";
//	echo $query;exit;

		$db->setQuery($query);
		$result= $db->loadObject();
		return $result;

//		$state=(isset($result->state)) ? $result->state: "";
//		return $state;
	}

	public function getModel($name = 'course', $prefix = 'Administrator', $config = array('ignore_request' => true))
	{
//		echo 'aya';exit;
		return parent::getModel($name, $prefix, $config);
	}


	public function cancel($key = NULL)
	{
		$msg = ( 'Operation Cancelled' );
	//	echo 'cancel';exit;
		$this->setRedirect( 'index.php?option=com_lmstarbiats&view=courses', $msg );
	}

    /**
     * Method override to check if you can add a new record.
     *
     * @param   array  $data  An array of input data.
     *
     * @return  boolean
     *
     * @since   1.6
     */
    protected function allowAdd($data = array())
    {
        $categoryId = ArrayHelper::getValue($data, 'catid', $this->input->getInt('filter_category_id'), 'int');

        if ($categoryId) {
            // If the category has been passed in the data or URL check it.
            return $this->app->getIdentity()->authorise('core.create', 'com_content.category.' . $categoryId);
        }

        // In the absence of better information, revert to the component permissions.
        return parent::allowAdd();
    }

    /**
     * Method override to check if you can edit an existing record.
     *
     * @param   array   $data  An array of input data.
     * @param   string  $key   The name of the key for the primary key.
     *
     * @return  boolean
     *
     * @since   1.6
     */
    protected function allowEdit($data = array(), $key = 'id')
    {
		return true;
        $recordId = (int) isset($data[$key]) ? $data[$key] : 0;
        $user = $this->app->getIdentity();

        // Zero record (id:0), return component edit permission by calling parent controller method
        if (!$recordId) {
            return parent::allowEdit($data, $key);
        }

        // Check edit on the record asset (explicit or inherited)
        if ($user->authorise('core.edit', 'com_content.article.' . $recordId)) {
            return true;
        }

        // Check edit own on the record asset (explicit or inherited)
        if ($user->authorise('core.edit.own', 'com_content.article.' . $recordId)) {
            // Existing record already has an owner, get it
            $record = $this->getModel()->getItem($recordId);

            if (empty($record)) {
                return false;
            }

            // Grant if current user is owner of the record
            return $user->id == $record->created_by;
        }

        return false;
    }
	
	// First : Buy now Pressed
	public function buynow() {
		// If the user clicked the add to cart button on the product page we can check for the form data
		$input=Factory::getApplication()->input;
		$id=$input->get('id', 0, 'INT');
		$Itemid=$input->get('Itemid', 0, 'INT');
		$lang=$input->get('lang', 'en', 'STRING');
		$return=base64_encode("index.php?option=com_lmstarbiats&task=course.buynow&id=$id&Itemid=$Itemid&lang=$lang");
		$params = ComponentHelper::getParams('com_lmstarbiats');
		$loginmenu = $params->get('loginmenu',0);

		$app   = $this->app;
		$db = Factory::getContainer()->get('DatabaseDriver'); //J4 onwards, outside of the Model or Table  
	//	$db = $this->_db; //only works in the model or table classes, J4 onwards

		 // Get the user data.
		$user = Factory::getUser();
		$user_id=$user->id;
		// ASK user to LOGIN
		if($user_id<1) { 
			$this->setMessage(Text::_('LOGIN_MESSAGE'), 'error');
			$this->setRedirect(Route::_("index.php?option=com_users&view=login&Itemid=$loginmenu&lang=$lang&return=$return", false));
			return false;
		}

		$usergroup="";
		$ordering=1;
        $course_id= $this->input->get('id', "", 'INT');
		$quantity = (int)1;
		//if (isset($_POST['id'], $_POST['quantity']) && is_numeric($_POST['product_id']) && is_numeric($_POST['quantity'])) {
		if($course_id>0) {
			
			// IF USER HAS ALREADY ENROLLED OR NOT
			$db = Factory::getDBO();
			$query="Select * from #__lmst_enrollments where course_id=$course_id AND user_id=$user_id";
	//	echo $query;exit;
			$db->setQuery($query);
			$result = $db->loadObject();
			if(isset($result)&&$result->id>0) {
				
				'You have already enrolled in this course';
			}
			
			$course=$this->getCourseInfo($course_id);
			
			// Product exists in database, now we can create/update the session variable for the cart
			if (isset($_SESSION['cart']) && is_array($_SESSION['cart'])) {
				if (array_key_exists($course_id, $_SESSION['cart'])) {
					// Product exists in cart so just update the quanity
					$_SESSION['cart'][$course_id] += $quantity;
				} else {
					// Product is not in cart so add it
					$_SESSION['cart'][$course_id] = $quantity;
				}
			} else {
				// There are no products in cart, this will add the first product to cart
				$_SESSION['cart'] = array($course_id => $quantity);
			}
			
		}
		
		$tax=1;
		$currency=$course->currency;//'EUR';
		//echo $course->price;exit;
		if(($course->price)&&$course->price!=""&&$course->price>0) 
		{
			$course->price=($course->discount_price>0&&$course->discount_price!="") 
						 ? $course->discount_price
						 : $course->price;
		}
		else
		{
			$course->price=0;
		}
	//	echo $course->price;exit;
		$total=(float)$course->price*$tax;
		$voucher_code=$course->voucher_code;
        $voucher_percent=$course->voucher_percent;
		
		$params = ComponentHelper::getParams('com_lmstarbiats');
		
		// To get the value of the param.
		$loginmenu = $params->get('loginmenu',171);
		$param_itemid= $params->get('coursemenu', 1524);

		$redirectUrl = urlencode(base64_encode(
					Route::_("index.php?option=com_lmstarbiats&view=course&id=" . $course_id."&Itemid=$param_itemid")) );
	?>
		<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
		<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
		<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
        <script>
		$(document).ready(function(){
			$("#tax_div").hide();
			$("#voucher_div").hide();
		
			var payment_method;
			$('.payment_method').click(function(e) {
				payment_method=$(this).val();
//				alert(payment_method);
				if(payment_method=='j') { $("#pay_div_j").show();$("#pay_div_e").hide(); }
				else
				if(payment_method=='e') { $("#pay_div_e").show();$("#pay_div_j").hide(); }
				else
				{ $("#pay_div_j").hide();$("#pay_div_e").hide(); }
			});
		
		});
        

		function btnCancel_action()
		{
			$('#formpayment').attr("action","index.php?option=com_lmstarbiats&task=course.cancel_payment&return=<?=$redirectUrl?>");
			$('#formpayment').submit();
		}
		function btnComplete_action()
		{
            var jformcountry;
			var payment_method_ischecked;
			jformcountry=$('#jformcountry');
			payment_method_ischecked=$('.payment_method').is(':checked');
			
			if(jformcountry.val()=='') {
				alert('Select Country to apply Tax.');
				jformcountry.focus();
				return false;
			}
			else if(payment_method_ischecked==false) {
				alert('Select Payment Method.');
				$('.payment_method').focus();
				return false;
			}
			else
			{
				$('#formpayment').submit();
				return true;
			}
		}
		
		function updateprice(tax_val){
        
			//$('#total_price_span').html(" ");
			//$('#total_price').val(0);
			
            var course_price_;
			course_price_=$('#course_price').val();
			var total_price_;
			total_price_=$('#total_price').val();

			var tax;
			//tax=$('#jformcountry').val();
			var add_tax_price;
			add_tax_price=(course_price_*tax_val)/100;
			add_tax_price= add_tax_price.toFixed(2);
			
	//		alert(add_tax_price);
			var final_price;
			final_price=parseFloat(add_tax_price)+parseFloat(course_price_);
			final_price= final_price.toFixed(2);
	//	alert(final_price);

			// Show tax Div & set Tax price
			$("#tax_div").show('slow');
			$('#tax_price').val(parseFloat(add_tax_price));
			$('#tax_price_span').html('<?=$course->currency . ' ' ?>'+(add_tax_price));

			$('#total_price').val(final_price);
			$('#total_price_span').animate({'opacity': 0}, 100, function(){
				$(this).html('<?=$course->currency . ' ' ?>'+final_price).animate({'opacity': 1}, 100);    
			});
        }
		
		// Update voucher Price
		function updateprice_v(p)
		{
		
		// First Check if country select to APPLY Tax
			var jformcountry;
			jformcountry=$('#jformcountry');
			
			if(jformcountry.val()=='') {
				alert('First Select Country to apply Tax.');
				jformcountry.focus();
				return false;
			}
			
			var course_price_;
			course_price_=$('#course_price').val();
			var total_price_;
			total_price_=$('#total_price').val();
			var voucher_code;
			voucher_code=$('#voucher_code').val();
			var voucher_percent;
			voucher_percent=$('#voucher_percent').val();
			var voucher_used;
			voucher_used=$('#voucher_used').val();
//	alert(voucher_used + voucher_code+p);
			if(p==voucher_code&&voucher_used=='0') {
				
				var vp;
				var _voucher_percent;
				_voucher_percent=(course_price_*voucher_percent)/100;
				var final_price;
				//final_price=parseFloat(course_price_)-parseFloat(_voucher_percent);
				final_price=parseFloat(total_price_)-parseFloat(_voucher_percent);
				final_price= final_price.toFixed(2);
			//	alert(total_price_+':'+voucher_percent+' : '+_voucher_percent+' : ' +(total_price_*voucher_percent));
		//	alert(final_price);
				
				// Show voucher Div
				$("#voucher_div").css('color','green').html('Vocher Applied Successfully').show('slow');
			//	$('#voucher_percent').val(parseFloat(_voucher_percent));
			//	$('#voucher_percent_span').html(parseFloat(_voucher_percent.toFixed(2)));
				
				$('#total_price').val(final_price);
				$('#total_price_span').animate({'opacity': 0}, 100, function(){
					$(this).html('<?=$course->currency . ' ' ?>'+final_price).animate({'opacity': 1}, 100);    
				});
				$('#voucher_used').val('1');
				$.ajax({
					url: "index.php?option=com_lmstarbiats&task=course.updatecoupen&id=<?=$course_id?>&Itemid=<?=$param_itemid?>",
					data: "id=<?=$course_id?>",
					type: "post",
					
					success: function(response){
					if(response=='true') {
					//alert(response);
						$("#txtRaseed").prop( "disabled", true );
						$("#btnRaseed").prop( "disabled", true ).css("background","red");
					}
					}
				});
				    
				return true;
			}
			else
			{
				$("#voucher_div").show('fast').css('color','red').html('Sorry your Voucher Code is expired Or it is already Applied.');
			}
			
			
		}// Update voucher Price ENDS
        </script>

		<div class="container-fluid">
        <div class="row">
        <div class="col-md-12 ms-3 shadow">
            <img src="https://www.abdulwaheed.pk/images/logo_circle_100.png" alt="logo here" class="img-fluid" />
        </div>
        </div>
        </div>

        <form action="index.php?option=com_lmstarbiats&task=course.payment&id=<?=$course->id?>&Itemid=<?=$Itemid?>&lang=<?=$lang?>&return=<?=$redirectUrl?>" method="post" id="formpayment">
        
        <div class="container">
        
        <div class="row">
        
            <h1><?=Text::_("COM_LMST_C_CHECKOUT")?></h1>
        <div class="col-md-6 pt-0 pb-2">
            <h3 class="pt-1 pb-1"><?=Text::_("COM_LMST_C_BILLING_ADDRESS")?></h3>
            <div class="fw-bold"><?=Text::_("COM_LMST_C_COUNTRY")?></div>
            <?=$this->getCountryTaxes()?>
            <p><?=Text::_("COM_LMST_C_LAW_TEXT")?></p>

<!----------------
PAYMENT METHODS
---------------------------------------------------->
<?php
$params = ComponentHelper::getParams('com_lmstarbiats');

// To get the value of the param.
$jazz_enabled=$params->get('jazz_enabled');
$easypaisa_enabled=$params->get('easypaisa_enabled');
$stripe_enabled=$params->get('stripe_enabled');
$mollie_enabled=$params->get('mollie_enabled');
?>
            <h3 class="pt-1 pb-1"><?=Text::_("COM_LMST_C_PAYMENT_METHOD");?></h3>
			<table  class="table table-striped d-block bg-light">
                <?php
                if($jazz_enabled)
				{
					?>
                <tr class="border">
                    <td class="p-3"><input type="radio" id="payment_method" name="payment_method" class="payment_method" value="j"  /></td>
                    <td><img src="<?=Uri::root()?>/components/com_lmstarbiats/assets/img/jazzcash.png" alt="Jazzcash" width="35" /></td>
                    <td class="w-100"><?=Text::_("COM_LMST_C_PM_JAZZCASH");?></td>
                </tr>
                <tr class="border" id="pay_div_j" style="display:none; font-style:italic;"><td colspan="3"><div><?=Text::_("COM_LMST_C_PM_JAZZCASH_DETAIL");?></div></td></tr>
                <?php
				}
					?>

                <?php
                if($easypaisa_enabled)
				{
					?>
                <tr class="border">
                    <td class="p-3"><input type="radio" id="payment_method" name="payment_method" class="payment_method" value="e" /></td>
                    <td><img src="<?=Uri::root()?>/components/com_lmstarbiats/assets/img/easypaisa.png" alt="Easypaisa" width="35" /></td>
                    <td class="w-100"><?=Text::_("COM_LMST_C_PM_EASYPAISA");?></td>
                </tr>
                <tr class="border" id="pay_div_e" style="display:none; font-style:italic;"><td colspan="3"><div><?=Text::_("COM_LMST_C_PM_EASYPAISA_DETAIL");?></div></td></tr>
                <?php
				}
					?>
                
                <?php
				if($mollie_enabled)
				{
				?>
                <tr class="border">
                    <td class="p-3"><input type="radio" id="payment_method" name="payment_method" class="payment_method" value="m" /></td>
                    <td><img src="<?=Uri::root()?>/components/com_lmstarbiats/assets/img/mollie_70x70.png" alt="Mollie" width="35" /></td>
                    <td class="w-100"><?=Text::_("COM_LMST_C_PM_MOLLIE");?></td>
                </tr>
                <?php
				}
				?>
                <!--<tr class="border">
                    <td class="p-3"><input type="radio" id="payment_method" name="payment_method" class="payment_method" value="p" /></td>
                    <td><img src="/components/com_lmstarbiats/assets/img/paypal.png" alt="Paypal" width="35" /></td>
                    <td class="w-100">Paypal</td>
                </tr>-->
                <?php
                if($stripe_enabled)
				{
					?>
                <tr class="border">
                    <td class="p-3"><input type="radio" id="payment_method" name="payment_method"  value="s" /></td>
                    <td><img src="<?=Uri::root()?>/components/com_lmstarbiats/assets/img/stripe.png" alt="Stripe" width="35" /></td>
                    <td class="w-100"><?=Text::_("COM_LMST_C_PM_STRIPE");?></td>
                </tr>
                <?php
				}
				?>
                </table>
        </div>
        
        <div class="col-md-6 bg-light pt-0 pb-2">
            
            <h3 class="pt-1 pb-1"><?=Text::_("COM_LMST_C_PM_SUMMARY");?></h3>
            <h5 class="pt-1 pb-1"><?=Text::_("COM_LMST_C_ORDER_DETAILS");?></h5>
            <div class="fw-bold"><?=$course->title?></div>
            <hr />

            <div><?=Text::_("COM_LMST_C_ORIGINAL_PRICE");?><span class="float-end" id="course_price_span"><?=$course->currency . ' ' .number_format($course->price,2)?></span></div>
            <hr />
            <div id="tax_div"><?=Text::_("COM_LMST_C_TAX_PRICE");?><span class="float-end" id="tax_price_span"></span></div>
            <div id="voucher_div" style="font-weight:bold;"><span class="float-end" id="voucher_percent_span"></span></div>
			<div class="fw-bold"><?=Text::_("COM_LMST_C_TOTAL_PRICE");?><span class="float-end" id="total_price_span"><?=($course->currency . ' ' .number_format($total,2))?></span></div>
            <hr />
                
			<p><input type="text" name="txtRaseed" id="txtRaseed" style="line-height: 0px; width: 68%; padding: 1rem 1rem; height: 3rem;font-size: 1.2rem;margin-bottom: .8rem;" class="" placeholder="<?=Text::_("COM_LMST_C_PLACEHOLDER");?>" /> <button style="background:#a435f0; color:#FFFFFF; line-height: 0px; width: 30%; padding: 1rem 1rem; height: 3rem;font-size: 1.2rem;margin-bottom: .8rem;" type="button" class="" id="btnRaseed" onClick="return updateprice_v(document.getElementById('txtRaseed').value);"><?=Text::_("COM_LMST_C_DISCOUNT");?></button></p>

            <p><?=Text::_("COM_LMST_C_TERMS_1");?> <a href="#"><?=Text::_("COM_LMST_C_TERMS_2")?></a></p>
			<p><button style="background:#a435f0; color:#FFFFFF; line-height: 0px; width: 100%; padding: 2rem 1rem; height: 4.8rem;font-size: 1.6rem;margin-bottom: .8rem;" type="button" class="" id="btnComplete" onClick="return btnComplete_action();"><?=Text::_("COM_LMST_C_BTN_PAYMENT");?></button> <button style="background:#cccccc; color:#000; line-height: 0px; width: 100%; padding: 2rem 1rem; height: 4.8rem;font-size: 1.6rem;margin-bottom: .8rem;" type="button" class="" id="btnCancel" onClick="return btnCancel_action();"><?=Text::_("COM_LMST_C_BTN_CANCEL_PAYMENT");?></button></p>
        
        </div>
        
        </div>
        </div>
        
        <input type="hidden" name="lang" id="lang" value="<?=$lang?>" /> 
        <input type="hidden" name="Itemid" id="Itemid" value="<?=$Itemid?>" /> 
        <input type="hidden" name="currency" id="currency" value="<?=$currency?>" /> 
        <input type="hidden" name="tax_price" id="tax_price" value="" /> 
        <input type="hidden" name="course_price" id="course_price" value="<?=(float)$course->price?>" /> 
        <input type="hidden" name="total_price" id="total_price" value="<?=(float)$total?>" />
        <input type="hidden" name="voucher_code" id="voucher_code" value="<?=$voucher_code?>" />
        <input type="hidden" name="voucher_percent" id="voucher_percent" value="<?=$voucher_percent?>" />
        <input type="hidden" name="voucher_used" id="voucher_used" value="0" />
        <input type="hidden" name="return" value="<?=$redirectUrl?>" />
        </form>

        <div class="container-fluid">
        <div class="row">
        <div class="col-md-12 ms-3 text-center pt-5 pb-3 bg-success">
            © <?=date("Y")?> abdulaheed.pk
        </div>
        </div>
        </div>

	<?php
		exit;
	}
	
	public function updatecoupen(){
		$input=Factory::getApplication()->input;
		$Itemid=$input->get('Itemid', 0, 'INT');
		$lang=$input->get('lang', 'en', 'STRING');
		$course_id=$input->get('id', 0, 'INT');
		$db = Factory::getDBO();
		$query="SELECT voucher_limit FROM #__lmst_courses WHERE id=$course_id";
//		echo $query;exit;
		$db->setQuery($query);
		$result=$db->loadObject();
		$new_voucher_limit=(isset($result->voucher_limit) && $result->voucher_limit>0) 
		? $result->voucher_limit-1 
		:0;
		
		$query2="Update #__lmst_courses set voucher_limit=$new_voucher_limit WHERE id=$course_id";
	//	echo $query2;//exit;
		$db->setQuery($query2);
		$result2=$db->execute();
		$output='false';
		if($result2) {
			$output='true';
		}
		echo $output;
		exit;
		
	}

	// Step cancel payment process
	public function cancel_payment(){
		$params = ComponentHelper::getParams('com_lmstarbiats');
		
		// To get the value of the param.
		$loginmenu = $params->get('loginmenu',171);
		$param_itemid= $params->get('coursemenu', 236);
		$input=Factory::getApplication()->input;
		$Itemid=$input->get('Itemid', 0, 'INT');
		$lang=$input->get('lang', 'en', 'STRING');
		$course_id=$input->get('id', 0, 'INT');
	
		$return=$input->get('return', '', 'STRING');


		$msg = Text::_("COM_LMST_C_CANCEL_PAYMENT_MESSAGE");
		$this->setRedirect( "index.php?return=$return", $msg, 'error' );
	}

	// Step 1 : Initiate payment process
	public function payment(){
		
		$params = ComponentHelper::getParams('com_lmstarbiats');
		
		// To get the value of the param.
		$loginmenu = $params->get('loginmenu',171);
		$param_itemid= $params->get('coursemenu', 236);

		$input=Factory::getApplication()->input;
		$Itemid=$input->get('Itemid', 0, 'INT');
		$lang=$input->get('lang', 'en', 'STRING');
		$course_id=$input->get('id', 0, 'INT');
		$currency=$input->get('currency', 'EUR', 'STRING');
		$payment_method=$input->get('payment_method', 'mollie', 'STRING');
		$payment_id="";
		$payment_description="";
		$payment_status="";
		$orderId = time();

		$tax_price=$input->get('tax_price', '0', 'STRING');
		$course_price=$input->get('course_price', '0', 'STRING');
		$total_price=$input->get('total_price', '0', 'STRING');
		$voucher_code=$input->get('voucher_code', '', 'STRING');
		$voucher_percent=$input->get('voucher_percent', '0', 'STRING');
		$db = Factory::getDBO();
		$user = Factory::getUser();
		$user_id=$user->id;
		$enrolled_on_time=date("Y-m-d h:i:sa");
		
		switch($payment_method) {
			
		/**************************
		1 : JAzzcash
		------------------------------*/
		case 'j':
			$query="INSERT INTO #__lmst_enrollments (course_id, `user_id`, `on_time`, `state`, `ordering`,`currency`,`payment_method`,payment_id, payment_orderid	,payment_description,payment_status,`tax_price`,`course_price`,`total_price`,voucher_code,voucher_percent) VALUES ($course_id, $user_id,'".$enrolled_on_time."',0,1,'$currency','$payment_method', '$payment_id','$orderId','$payment_description','$payment_status','$tax_price','$course_price','$total_price','$voucher_code','$voucher_percent')";
		
	//	echo $query;exit;
			$db->setQuery($query);
			$result=true;
			$result=$db->execute();
			
			if($result) {
				
				$msg = ( 'Welcome to Course : '.$this->getCourseInfo($course_id)->title );
				$this->notifyadmin($user_id, $course_id, $enrolled_on_time);
				$this->setRedirect( "index.php?option=com_lmstarbiats&view=course&id=$course_id&Itemid=$Itemid&lang=$lang", $msg );
			}
		break;

		/**************************
		2 : Easypaisa
		------------------------------*/
		case 'e':
			$query="INSERT INTO #__lmst_enrollments (course_id, `user_id`, `on_time`, `state`, `ordering`,`currency`,`payment_method`,payment_id, payment_orderid	,payment_description,payment_status,`tax_price`,`course_price`,`total_price`,voucher_code,voucher_percent) VALUES ($course_id, $user_id,'".$enrolled_on_time."',0,1,'$currency','$payment_method', '$payment_id','$orderId','$payment_description','$payment_status','$tax_price','$course_price','$total_price','$voucher_code','$voucher_percent')";
		
	//	echo $query;exit;
			$db->setQuery($query);
			$result=$db->execute();
			
			if($result) {
				
				$msg = ( 'Welcome to Course : '.$this->getCourseInfo($course_id)->title );
				$this->notifyadmin($user_id, $course_id, $enrolled_on_time);
				$this->setRedirect( "index.php?option=com_lmstarbiats&view=course&id=$course_id&Itemid=$Itemid&lang=$lang", $msg );
			}
		break;

		/**************************
		3 : MOLLIE
		------------------------------*/
		case 'm':

			$params = ComponentHelper::getParams('com_lmstarbiats');

			// To get the value of the param.
			$mollie_apikey=$params->get('mollie_apikey');
			$mollie_mode=$params->get('mollie_mode');

			require_once JPATH_COMPONENT . "/mollie-api/vendor/autoload.php";
		//	require_once JPATH_COMPONENT . "/mollie-api/functions.php";
			$mollie = new \Mollie\Api\MollieApiClient();
			// live_4PEbctgabrzyVbT5dCPnNqxghKphny

			$mollie->setApiKey($mollie_apikey);//"test_v92dncPf5RuGJdJBxbq7zK3rUsaPjs");
			
			$payment_description="This is Order # $orderId";

//echo "https://www.abdulwaheed.pk/index.php?option=com_lmstarbiats&task=course.webhook&Itemid=$param_itemid&lang=en&order_id={$orderId}&course_id={$course_id}&user_id={$user_id}&on_time=&state=0&ordering=1&payment_method=$payment_method&payment_id=0&payment_orderid	={$orderId}&payment_description={$payment_description}&payment_status=&tax_price={$tax_price}&course_price={$course_price}&total_price={$total_price}&voucher_code={$voucher_code}&voucher_percent={$voucher_percent}";exit;

			$payment = $mollie->payments->create([
			"amount" => [
				"currency" => $currency,
				"value" => $total_price,
			],
			"description" => $payment_description,
			"redirectUrl" => "https://www.abdulwaheed.pk/index.php?option=com_lmstarbiats&task=course.redirectUrl&Itemid=$param_itemid&lang=en&order_id={$orderId}",
			"webhookUrl" => "https://www.abdulwaheed.pk/index.php?option=com_lmstarbiats&task=course.webhook&Itemid=$param_itemid&lang=en&order_id={$orderId}&course_id={$course_id}&user_id={$user_id}&on_time=&state=0&ordering=1&payment_method=$payment_method&tax_price={$tax_price}&course_price={$course_price}&total_price={$total_price}&voucher_code={$voucher_code}&voucher_percent={$voucher_percent}",
			"metadata" => [
				"order_id" => $orderId				
			],
			]);
			
	//		echo $payment->getCheckoutUrl();exit;
	//$app = Factory::getApplication();
	//$app->redirect($payment->getCheckoutUrl(), 'message text', '', 303);
	//$app->close();
	
			$this->notifyadmin($user_id, $course_id, $enrolled_on_time);
			header("Location: " . $payment->getCheckoutUrl(), true, 303);
		break;

		/**************************
		4 : Paypal
		------------------------------*/
		case 'p':
			
			$this->notifyadmin($user_id, $course_id, $enrolled_on_time);
		break;
		/**************************
		5 : Stripe
		------------------------------*/
		case 's':
			
			$this->notifyadmin($user_id, $course_id, $enrolled_on_time);
		break;
		}
		
	}
	
	// Step 2 : webhook to check payment status and perform actions
	public function webhook(){
	
		$params = ComponentHelper::getParams('com_lmstarbiats');

		// To get the value of the param.
		$mollie_apikey=$params->get('mollie_apikey');
		$mollie_mode=$params->get('mollie_mode');

		require_once JPATH_COMPONENT . "/mollie-api/vendor/autoload.php";
	//	require_once JPATH_COMPONENT . "/mollie-api/functions.php";
		$mollie = new \Mollie\Api\MollieApiClient();
		$mollie->setApiKey($mollie_apikey);//"test_v92dncPf5RuGJdJBxbq7zK3rUsaPjs");
	
		/*
		 * Get the all payments for this API key ordered by newest.
		 */
		$payments = $mollie->payments->page();
		$myfile = fopen("_webhook_error_log.txt", "a") or die("Unable to open file!");

		// Get single payment Details
		$payment = $mollie->payments->get($_POST['id']);
		$status = $payment->status;	
		$txt =  $payment->id . " : " . $_GET['order_id']." : ". $payment->description." : ". $status."\n";
		
		$course_id=$_GET['course_id'];
		$user_id=$_GET['user_id'];
		$currency=$payment->amount->currency;//$_GET['currency'];
		$payment_method='m';
		$payment_id=$payment->id;
		$orderId=$_GET['order_id'];
		$payment_description=$payment->description;
		$payment_status=$status;
		$tax_price=$_GET['tax_price'];
		$course_price=$_GET['course_price'];
		$total_price=$_GET['total_price'];
		$voucher_code=$_GET['voucher_code'];
		$voucher_percent=$_GET['voucher_percent'];

		$db = Factory::getDBO();
		$query="INSERT INTO #__lmst_enrollments (course_id, `user_id`, `on_time`, `state`, `ordering`,`currency`,`payment_method`,payment_id, payment_orderid	,payment_description,payment_status,`tax_price`,`course_price`,`total_price`,voucher_code,voucher_percent) VALUES ($course_id, $user_id,'".date("Y-m-d h:i:sa")."',0,1,'$currency','$payment_method', '$payment_id','$orderId','$payment_description','$payment_status','$tax_price','$course_price','$total_price','$voucher_code','$voucher_percent')";

// INSERT INTO #__lmst_enrollments (course_id, `user_id`, `on_time`, `state`, `ordering`,`currency`,`payment_method`,payment_id, payment_orderid	,payment_description,payment_status,`tax_price`,`course_price`,`total_price`,voucher_code,voucher_percent) VALUES (1, 956,'2024-09-27 06:37:13pm',0,1,'','m', 'tr_B3KMUBf9tt','1727462212','This is Order # 1727462212','paid','','','','','')		
			
	//	echo $query;exit;
			$db->setQuery($query);
			$result=$db->execute();
			
			if(!$result) {
				fwrite($myfile, $query.'\n');
//				$msg = ( 'Welcome to Course : '.$this->getCourseInfo($course_id)->title );
	//	echo 'cancel';exit;
//				$this->setRedirect( "index.php?option=com_lmstarbiats&view=course&id=$course_id&Itemid=$Itemid&lang=$lang", $msg );
			}			
		/*
		foreach ($payments as $payment) {

			$txt =  $_POST['id']." <<< ". $payments[0]->id . " : " . $_GET['order_id']." : ". $payments[0]->description." : ". $payments[0]->status."\n";
		//	fwrite($myfile, $txt);
		}
		*/
		fclose($myfile);

	}

	// Step 3 : Direct to website page after user completed payment process
	public function redirectUrl(){
	
		require_once JPATH_COMPONENT . "/mollie-api/vendor/autoload.php";
	//	require_once JPATH_COMPONENT . "/mollie-api/functions.php";
		$mollie = new \Mollie\Api\MollieApiClient();
		$mollie->setApiKey("test_v92dncPf5RuGJdJBxbq7zK3rUsaPjs");

 		/*
		 * Determine the url parts to these example files.
		 */
		$protocol = isset($_SERVER['HTTPS']) && strcasecmp('off', $_SERVER['HTTPS']) !== 0 ? "https" : "http";
		$hostname = $_SERVER['HTTP_HOST'];
		$path = dirname($_SERVER['REQUEST_URI'] ?? $_SERVER['PHP_SELF']);
	
		/*
		 * Get the all payments for this API key ordered by newest.
		 */
		$payments = $mollie->payments->page();
	
// Get single payment Details
//$payment = $mollie->payments->get("tr_H32mjPikUJ");
//$status = $payment->status;

		echo "<ul>";
		foreach ($payments as $payment) {
			echo "<li>";
			echo "<strong style='font-family: monospace'>" . htmlspecialchars($payment->id) . "</strong><br />";
			echo htmlspecialchars($payment->description) . " : ". $_GET['order_id']  . "<br />";
			echo htmlspecialchars($payment->amount->currency) . " " . htmlspecialchars($payment->amount->value) . "<br />";
	
			echo Text::_("COM_LMST_C_STATUS_LABEL") . htmlspecialchars($payment->status) . "<br />";
	
			if ($payment->hasRefunds()) {
				echo Text::_("COM_LMST_C_PAYMENT_PARTIAL_REFUNDED");
			}
	
			if ($payment->hasChargebacks()) {
				echo Text::_("COM_LMST_C_PAYMENT_REFUNDED");
			}
	
			if ($payment->canBeRefunded() && $payment->amountRemaining->currency === 'EUR' && $payment->amountRemaining->value >= '2.00') {
				echo " (<a href=\"{$protocol}://{$hostname}{$path}/refund-payment.php?payment_id=" . htmlspecialchars($payment->id) . "\">refund</a>)";
			}
	
			echo "</li>";
		}
		echo "</ul>";

//		$myfile = fopen("newfile_redirectUrl.txt", "w") or die("Unable to open file!");
		$txt =  $_GET['order_id'] . ":". "\n";
//		fwrite($myfile, $txt);
//		fclose($myfile);
		
	}
	
	// 4. Notify admin for enrollment
	public function notifyadmin($user_id, $course_id, $enrolled_on_time) {

		$config = Factory::getConfig();
		$fromname = $config->get('fromname');
		$mailfrom= $config->get('mailfrom');
		$mailer = Factory::getMailer();
		$app   = $this->app;
		
		$sender = array( 
			$mailfrom,
			$fromname	
		);
		$mailer->setSender($sender);
		
		$recipient = array("sayfrndship@gmail.com");
//		$recipient = array("ericenhed@gmail.com", "ericauzon@gmail.com");
		$mailer->addRecipient($recipient);
		$user = Factory::getUser($user_id);
		$username=$user->name;
		$coursename=$this->getCourse($course_id)->title;
		
		$body   = "The student '$username' has enrolled in new course:\n Course Name: ".    $coursename." \n Enrollment on : " .$enrolled_on_time . "\n
		In order to publish this enrollment follow the link:
		https://www.abdulwaheed.pk/index.php?option=com_lmstarbiats&task=course.publish&user_id=$user_id&course_id=$course_id";

		$mailer->setSubject("Student '$username' Enrollment in Course (".$coursename.")");
		$mailer->setBody($body);
		
		$send = $mailer->Send();
		if ( $send !== true ) {
			echo $body.Text::_("COM_LMST_C_MAIL_ERR"); //	exit;
		} else {
			echo $body.Text::_("COM_LMST_C_MAIL_SENT"); //	exit;
		}

	}
	
    public function publish() {

		$db = Factory::getDBO();
		$app = Factory::getApplication();
		$input = $app->input;
		$user_id= $input->get('user_id', 0, 'INT');
		$course_id= $input->get('course_id', 0, 'INT');

		$q3="UPDATE #__lmst_enrollments set state='1' Where user_id=$user_id AND course_id=$course_id";

        try {
            $db->setQuery($q3)->execute();
			

$config = Factory::getConfig();
$sender = array( 
    $config->get( 'mailfrom' ),
    $config->get( 'fromname' ) 
);
$mailer = Factory::getMailer();

$mailer->setSender($sender);

$user = Factory::getUser($user_id);
$recipient = $user->email;
$s_name= $user->name;

$c_title=$this->getCourse($course_id)->title;
$recipient = array( 'sayfrndship@gmail.com' );
$mailer->addRecipient($recipient);

$body   = 
 '<div>
 A course enrollment has be enabled. \n <br /><br />
 Following are Details : <br /><br />
Course Name : '.$c_title.' <br />
Student Name : '.$s_name.'
 </div>';
$mailer->isHtml(true);
$mailer->Encoding = 'base64';
$mailer->setSubject("Course Enrollment Publish Notice");
$mailer->setBody($body);
// Optionally add embedded image
//$mailer->AddEmbeddedImage( JPATH_COMPONENT.'/assets/logo128.jpg', 'logo_id', 'logo.jpg', 'base64', 'image/jpeg' );


$send = $mailer->Send();
if ( $send !== true ) {
    echo Text::_("COM_LMST_C_ENROLMENT_ERR_MSG");
} else {
    echo Text::_("COM_LMST_C_ENROLMENT_SUCCESS_MSG");
}	
exit;
        } 
		
		catch (ExecutionFailureException $e) {
        }
		
	}
	



}


	