<?php
/*------------------------------------------------------------------------
# customer.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/

// No direct access.
defined('_JEXEC') or die;

class OsCalendarCustomer{
	/**
	 * Osproperty default
	 *
	 * @param unknown_type $option
	 */
	static function display($option,$task){
		global $mainframe;
		require_once(JPATH_ROOT.DS."components".DS."com_osproperty".DS."helpers".DS."common.php");
		require_once(JPATH_COMPONENT_ADMINISTRATOR.DS."tables".DS."order.php");
		$document = JFactory::getDocument();
		$pid = $mainframe->input->getInt('pid',0);
		$cid = $mainframe->input->get('cid',array(),'array');
		$id  = $mainframe->input->getInt('id',0);
		switch ($task){
			case "customer_default":
				OsCalendarCustomer::defaultPage();
			break;
		}
	}
	
	/**
	 * Default page
	 *
	 */
	static function defaultPage(){
		global $mainframe,$cClass,$configClass;
		OSPHelper::generateHeading(1,JText::_('OS_LIST_MY_ORDERS'));
		$db = JFactory::getDbo();
		$user = JFactory::getUser();
		if(intval($user->id) == 0){
			$mainframe->enqueueMessage(JText::_('OS_YOU_DO_NOT_HAVE_PERMISSION_TO_GO_TO_THIS_AREA'));
			$mainframe->redirect(JURI::root());
		}
		$email = $user->email;
		//synchronous orders
		OSCHelper::synOrder();
		
		$sortby = $mainframe->input->getString('sortby','a.order_date');
		$orderby = $mainframe->input->getString('orderby','desc');
		
		$limit = $mainframe->input->getInt('limit',20);
		$limitstart = $mainframe->input->getInt('limitstart',0);
		
		$start_from = $mainframe->input->getString('start_from','');
		$end_to = $mainframe->input->getString('end_to','');
		
		$query = "Select count(a.id) from #__oscalendar_booking as a inner join #__osrs_properties as b on a.pid =  b.id where b.published = '1' and b.approved = '1'  and a.user_id = '$user->id'";
		if($start_from != ""){
			$query .= " and a.order_date >= '$start_from'";
		}
		if($end_to != ""){
			$query .= " and a.order_date <= '$end_to'";
		}
		$db->setQuery($query);
		$total = $db->loadResult();
		
		$pageNav = new OSCJPagination($total,$limitstart,$limit);
		
		$query = "Select a.*,b.ref,b.pro_name,c.room_name,c.room_image from #__oscalendar_booking as a inner join #__osrs_properties as b on a.pid =  b.id inner join #__oscalendar_rooms as c on c.id = a.rid where b.published = '1' and b.approved = '1' and a.user_id = '$user->id'";
		if($start_from != ""){
			$query .= " and a.order_date >= '$start_from'";
		}
		if($end_to != ""){
			$query .= " and a.order_date <= '$end_to'";
		}
		$query .= " order by $sortby $orderby";
		$db->setQuery($query,$pageNav->limitstart,$pageNav->limit);
		//echo $db->getQuery();
		$rows = $db->loadObjectList();
		
		$optionArr = array();
		$optionArr[] = JHTML::_('select.option','a.order_date',Jtext::_('OS_CALENDAR_ORDER_DATE'));
		$optionArr[] = JHTML::_('select.option','a.total',Jtext::_('OS_TOTAL'));
		$optionArr[] = JHTML::_('select.option','a.book_from',Jtext::_('OS_CALENDAR_CHECK_IN'));
		$optionArr[] = JHTML::_('select.option','a.book_to',Jtext::_('OS_CALENDAR_CHECK_OUT'));
		$optionArr[] = JHTML::_('select.option','a.order_status',Jtext::_('OS_CALENDAR_ORDER_STATUS'));
		$lists['sortby'] = JHTML::_('select.genericlist',$optionArr,'sortby','class="input-medium"','value','text',$sortby);
		
		$optionArr = array();
		$optionArr[] = JHTML::_('select.option','desc',Jtext::_('OS_DESCENDING'));
		$optionArr[] = JHTML::_('select.option','asc',Jtext::_('OS_ASCENDING'));
		$lists['orderby'] = JHTML::_('select.genericlist',$optionArr,'orderby','class="input-medium"','value','text',$orderby);
		
		$optionArr = array();
		$optionArr[] = JHTML::_('select.option','',JText::_('OS_CALENDAR_ANY_ORDER_STATUS'));
		$optionArr[] = JHTML::_('select.option','P',Jtext::_('OS_CALENDAR_PENDDING'));
		$optionArr[] = JHTML::_('select.option','S',Jtext::_('OS_CALENDAR_COMPLETE'));
		$optionArr[] = JHTML::_('select.option','S',Jtext::_('OS_CALENDAR_CANCEL'));
		$lists['status'] = JHTML::_('select.genericlist',$optionArr,'status','class="input-medium"','value','text',$status);
		
		
		HTML_OsCalendarCustomer::listOrders($rows,$pageNav,$lists);
	}
}
?>