<?php
/*------------------------------------------------------------------------
# price.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/

// No direct access.
defined('_JEXEC') or die;

class OsCalendarPrice{
	/**
	 * Osproperty default
	 *
	 * @param unknown_type $option
	 */
	function display($option,$task){
		global $mainframe;
		$mainframe = JFactory::getApplication();
		$cid = $mainframe->input->get( 'cid', array(0),'array');
		JArrayHelper::toInteger($cid, array(0));		
		$pid = $mainframe->input->getInt('pid',0);
		$rid = $mainframe->input->getInt('rid',0);
		
		if((!HelperOspropertyCommon::isAgent()) and (!HelperOspropertyCommon::isCompanyAdmin())){
			$mainframe->enqueueMessage(JText::_('OS_YOU_DO_NOT_HAVE_PERMISION_TO_GO_TO_THIS_AREA'));
			$mainframe->redirect(JUri::root());
		}
		if((HelperOspropertyCommon::isCompanyAdmin()) and ($configClass['company_admin_add_properties'] == 0)){
			$mainframe->enqueueMessage(JText::_('OS_YOU_DO_NOT_HAVE_PERMISION_TO_GO_TO_THIS_AREA'));
			$mainframe->redirect(JUri::root());
		}
		if((!HelperOspropertyCommon::isOwner($pid)) and (!HelperOspropertyCommon::isCompanyOwner($pid))){
			$mainframe->enqueueMessage(JText::_('OS_YOU_DO_NOT_HAVE_PERMISION_TO_GO_TO_THIS_AREA'));
			$mainframe->redirect(JUri::root());
		}
		switch ($task){
			case "price_setup":
				OsCalendarPrice::setupPrice($pid,$rid);
			break;
			case "price_addnew":
				OsCalendarPrice::price_edit(0,$pid,$rid);
			break;
			case "price_edit":
				OsCalendarPrice::price_edit($cid[0],$pid,$rid);
			break;
			case "price_save":
				OsCalendarPrice::price_save($option,1,$pid,$rid);
			break;
			case "price_apply":
				OsCalendarPrice::price_save($option,0,$pid,$rid);
			break;
			case "price_remove":
				OsCalendarPrice::price_remove($pid,$rid,$cid);
			break;
			case "price_cancel":
				$mainframe->redirect(JRoute::_('index.php?option=com_oscalendar&task=price_setup&pid='.$pid.'&rid='.$rid));
			break;
			case "price_loadavailability":
				OsCalendarPrice::loadPriceAvailability($pid,$rid);
			break;
		}
	}
	
	/**
	 * Setup Price
	 *
	 * @param unknown_type $pid
	 * @param unknown_type $rid
	 */
	function setupPrice($pid,$rid){
		global $mainframe,$configClass,$cClass;
		$db = JFactory::getDbo();
		$db->setQuery("Select id,pro_name,pro_type,curr from #__osrs_properties where id = '$pid'");
		$property = $db->loadObject();
		$db->setQuery("Select id,room_name from #__oscalendar_rooms where id = '$rid'");
		$room = $db->loadObject();
		$category_id = $property->pro_type;
		$db->setQuery("Select * from #__osrs_types where id = '$category_id'");
		$category = $db->loadObject();
		$price_type = $category->price_type;
		$property->price_type = $price_type;
		
		$title .= $property->pro_name;
		$title = $title ." > ".$room->room_name." > ".JText::_('OS_MANAGE_PRICE');
		OSPHelper::generateHeading(1,$title);
		
		$pathway	= $mainframe->getPathway();
		$pathway->addItem($property->pro_name,JRoute::_('index.php?option=com_oscalendar&task=room_manage&pid='.$pid.'&Itemid='.$mainframe->input->getInt('Itemid',0)));
		$pathway->addItem($room->room_name,JRoute::_('index.php?option=com_oscalendar&task=room_manage&pid='.$pid.'&Itemid='.$mainframe->input->getInt('Itemid',0)));
		$pathway->addItem(JText::_('OS_MANAGE_PRICE'),'');
		
		if($price_type == 1){
			include_once(JPATH_COMPONENT_ADMINISTRATOR.'/classes/price.php');
			$db->setQuery("Select * from #__oscalendar_room_prices where rid = '$rid' order by created_on desc");
			$room_prices = $db->loadObjectList();
			HTML_OsCalendarPrice::showPropertyPrice($property,$room,$room_prices);
		}else{
			$start = $mainframe->input->getString('start','');
			$end = $mainframe->input->getString('end','');
			$startQuery = "";
			$endQuery = "";
			if($start != ""){
				$startQuery = " and price_from = '$start' ";
			}
			if($end != ""){
				$endQuery = " and price_to = '$end' ";
			}
			$limit = $mainframe->input->getInt('limit',20);
			$limitstart = $mainframe->input->getInt('limitstart',0);
			$filter_order 	 	= $mainframe->input->getString('filter_order','price_from');
			$filter_order_Dir 	= $mainframe->input->getString('filter_order_Dir','desc');
			$lists['order'] 	= $filter_order;
			$lists['order_Dir'] = $filter_order_Dir;
			$today = date("Y-m-d",time());
			$db->setQuery("Select count(id) from #__oscalendar_room_prices where rid = '$rid' and price_from >= '$today' $startQuery $endQuery ");
			$count = $db->loadResult();
			
			include_once(JPATH_ROOT.'/components/com_osproperty/helpers/pagination.php');
			$pageNav = new OSPJPagination($count,$limitstart,$limit);
			$db->setQuery("Select * from #__oscalendar_room_prices where rid = '$rid' and price_from >= '$today' $startQuery $endQuery order by $filter_order $filter_order_Dir",$pageNav->limitstart,$pageNav->limit);
			$rows = $db->loadObjectList();
			HTML_OsCalendarPrice::listPrices($property,$room,$rows,$pageNav,$lists);
		}
	}
	
	/**
	 * Add/edit season
	 *
	 * @param unknown_type $id
	 */
	function price_edit($id,$pid,$rid){
		global $mainframe;
		include_once(JPATH_COMPONENT_ADMINISTRATOR.'/classes/price.php');
		$db = JFactory::getDBO();
		$db->setQuery("Select id,pro_name,category_id,curr from #__osrs_properties where id = '$pid'");
		$property = $db->loadObject();
		$db->setQuery("Select id,room_name from #__oscalendar_rooms where id = '$rid'");
		$room = $db->loadObject();
		$row = &JTable::getInstance('Price','OsCalendarTable');
		if($id > 0){
			$row->load((int)$id);
			$func = JText::_('OS_EDIT');
		}else{
			$func = JText::_('OS_ADDNEW');
		}
		$price_type = $mainframe->input->getInt('price_type',0);
		$property->price_type = $price_type;
		
		$pathway	= $mainframe->getPathway();
		$title .= $property->pro_name;
		$pathway->addItem($title,JRoute::_('index.php?option=com_oscalendar&task=room_manage&pid='.$pid.'&Itemid='.$mainframe->input->getInt('Itemid',0)));
		$pathway->addItem($room->room_name,JRoute::_('index.php?option=com_oscalendar&task=room_manage&pid='.$pid.'&Itemid='.$mainframe->input->getInt('Itemid',0)));
		$pathway->addItem(JText::_('OS_MANAGE_PRICE'),JRoute::_('index.php?option=com_oscalendar&task=price_setup&pid='.$pid.'&rid='.$rid.'&Itemid='.$mainframe->input->getInt('Itemid',0)));
		$pathway->addItem($func,'');
		
		$title = $title ." > ".$room->room_name." > ".JText::_('OS_MANAGE_PRICE')." > ".$func;
		OSPHelper::generateHeading(1,$title);
		
		HTML_OsCalendarPrice::editPrice($row,$property,$room);
	}
	
	/**
	 * Save season information
	 *
	 * @param unknown_type $option
	 * @param unknown_type $save
	 */
	function price_save($option,$save,$pid,$rid){
		global $mainframe;
		
		$db 			= JFactory::getDBO();
		$id				= $mainframe->input->getInt('id',0);
		$row 			= &JTable::getInstance('Price','OsCalendarTable');
		$price_from 	= $mainframe->input->getString('price_from','');
		$price_to 		= $mainframe->input->getString('price_to','');
		$price_from_int = strtotime($price_from);
		$price_to_int   = strtotime($price_to);
		$price_type 	= $mainframe->input->getInt('price_type',0);
		if($price_from_int >= $price_to_int){
			$msg = JText::_('OS_END_DATE_MUST_LATER_THAN_START_DATE');
			$mainframe->enqueueMessage($msg);
			if($price_type == 1){
				$mainframe->redirect(JRoute::_("index.php?option=com_oscalendar&task=price_setup&rid=".$rid."&pid=".$pid));
			}else{
				$mainframe->redirect(JRoute::_("index.php?option=com_oscalendar&task=price_edit&cid[]=$id&rid=".$rid."&pid=".$pid));
			}
			
		}
		if($price_type == 0){
			//check to see if there is any existing price plan in this time
			if($id > 0){
				$addition_sql = " and id <> '$id'";
			}else{
				$addition_sql = "";
			}
			$db->setQuery("Select count(id) from #__oscalendar_room_prices where rid = '$rid' and ((price_from <= '$price_from' and price_to >= '$price_from') or (price_from <= '$price_to' and price_to >= '$price_to') or (price_from >= '$price_from' and price_to <= '$price_to')) $addition_sql");
			$count = $db->loadResult();
			if($count > 0){
				$msg = JText::_('OS_THERE_IS_EXISTING_PRICE_PLAN');
				$mainframe->enqueueMessage($msg);
				$mainframe->redirect(JRoute::_("index.php?option=com_oscalendar&task=price_edit&cid[]=$id&rid=".$rid."&pid=".$pid));
			}
		}
		
		$post = Jrequest::get('post');
		$row->created_on = date("Y-m-d H:i:s",time());
		$row->bind($post);
		$row->id = $id;
		if($price_type == 0){
			$row->allday = 1;
			$row->min_booking = 1;
		}
		if($row->store()){
			$msg = JText::_('OS_PRICE_INFORMATION_HAVE_BEEN_SAVED');
		}
		$mainframe->enqueueMessage($msg);
		if($price_type == 0){
			if($save == 1){
				$mainframe->redirect(JRoute::_("index.php?option=com_oscalendar&task=price_setup&rid=".$rid."&pid=".$pid));
			}else{
				$mainframe->redirect(JRoute::_("index.php?option=com_oscalendar&task=price_edit&cid[]=".$row->id."&rid=".$rid."&pid=".$pid));
			}
		}else{
			if($save == 1){
				$mainframe->redirect(JRoute::_("index.php?option=com_oscalendar&task=room_manage&pid=".$pid));
			}else{
				$mainframe->redirect(JRoute::_("index.php?option=com_oscalendar&task=price_setup&rid=".$rid."&pid=".$pid));
			}
		}
	}
	
	/**
	 * Remove price items
	 *
	 * @param unknown_type $pid
	 * @param unknown_type $rid
	 * @param unknown_type $cid
	 */
	function price_remove($pid,$rid,$cid){
		global $mainframe;
		$db = JFactory::getDbo();
		if(count($cid) > 0){
			$db->setQuery("Delete from #__oscalendar_room_prices where id in (".implode(",",$cid).")");
			$db->execute();
			$msg = JText::_('OS_ITEMS_HAVE_BEEN_REMOVED');
			$mainframe->redirect(JRoute::_('index.php?option=com_oscalendar&task=price_setup&pid='.$pid.'&rid='.$rid),$msg);
		}else{
			$msg = JText::_('OS_PLEASE_SELECT_ITEMS_TO_REMOVE');
			$mainframe->redirect(JRoute::_('index.php?option=com_oscalendar&task=price_setup&pid='.$pid.'&rid='.$rid),$msg);
		}
	}
	
	function loadPriceAvailability($pid,$rid){
		global $mainframe,$configClass,$cClass;
		
		$select_year = $mainframe->input->getInt('year',intval(date("Y",time())));
		$current_year = date("Y",time());
		if($select_year == $current_year){
			$start_month = intval(date("m",time()));
		}else{
			$start_month = 1;
		}
		for($i=$start_month;$i<=12;$i++){
			HelperOsCalendarCalendar::showCalendarWithPriceBackend($rid,$pid,$select_year,$i);
			echo "<BR />";
		}
		exit();
	}
}
?>