<?php
/**
 * @package     OSL
 * @subpackage  Provider
 *
 * @copyright   Copyright (C) 2016 Ossolution Team, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */

namespace OSL\Provider;

use Joomla\CMS\Factory;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use OSL\Inflector\Inflector;
use OSL\Input\Input;

class SystemProvider implements ServiceProviderInterface
{
	public function register(Container $container)
	{
		// Joomla Application
		$container->share(
			'app',
			function () {
				return Factory::getApplication();
			},
			true
		);

		// Database
		$container->share(
			'db',
			function () {
				return Factory::getContainer()->get('db');
			},
			true
		);

		// Session
		$container->share(
			'session',
			function (Container $container) {
				return $container->get('app')->getSession();
			},
			true
		);

		// Language
		$container->share(
			'language',
			function (Container $container) {
				return $container->get('app')->getLanguage();
			},
			true
		);

		// String Inflector
		$container->share(
			'inflector',
			function () {
				return new Inflector();
			},
			true
		);

		// Joomla Document
		$container->share(
			'document',
			function (Container $container) {
				return $container->get('app')->getDocument();
			},
			true
		);

		// Current Joomla User
		$container->share(
			'user',
			function (Container $container) {
				return $container->get('app')->getIdentity();
			},
			true
		);

		// Joomla Input
		$container->share(
			'input',
			function (Container $container) {
				$source = $container->get('app')->getInput();

				return new Input($source);
			}
		);

		// OSL Factory
		$container->share(
			'factory',
			function (Container $container) {
				return new \OSL\Factory\Factory($container);
			}
		);
	}
}