<?php
/**
 * @package     OSL
 * @subpackage  Controller
 *
 * @copyright   Copyright (C) 2016 Ossolution Team, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */

namespace OSL\Utils;

use Joomla\Database\DatabaseQuery;

class Database
{
	/**
	 * Helper method to get fields from database table in case the site is multilingual
	 *
	 * @param   DatabaseQuery  $query
	 * @param   array          $fields
	 * @param   string         $fieldSuffix
	 */
	public static function getMultilingualFields(DatabaseQuery $query, $fields = [], $fieldSuffix = '')
	{
		foreach ($fields as $field)
		{
			$alias  = $field;
			$dotPos = strpos($field, '.');

			if ($dotPos !== false)
			{
				$alias = substr($field, $dotPos + 1);
			}

			$query->select($query->quoteName($field . $fieldSuffix, $alias));
		}
	}
}