(function (document, Joomla) {
	function loadTicketsChart() {
		const dailyCtx = document.getElementById('hdp-tickets-chart').getContext('2d');
		new Chart(dailyCtx, {
			type: 'bar',
			data: Joomla.getOptions('chartData', []),
			plugins: [ChartDataLabels],
			options: {
				responsive: true,
				interaction: {
					mode: 'index',
					intersect: false
				},
				scales: {
					yAxes: [{
						ticks: {
							beginAtZero: true
						}
					}]
				},
				plugins: {
					datalabels: {
						anchor: 'end',
						align: 'top',
						font: {
							weight: 'bold'
						}
					},
					legend: {
						display: false // hides the whole legend
					}
				}
			}
		});
	}

	function updateDurationStatistic() {
		const durationElement = document.getElementById('statistic_duration');

		durationElement.addEventListener('change', function () {
			let baseUri = Joomla.getOptions('baseUri');
			let duration = durationElement.value;
			Joomla.request({
				url: baseUri + '/index.php?option=com_helpdeskpro&task=get_statistic_for_duration&statistic_duration=' + duration,
				method: 'POST',
				headers: {
					'Content-Type': 'application/json'
				},
				onSuccess: function (resp) {
					let reponse = JSON.parse(resp);

					document.getElementById('hdp-total-number-tickets').textContent = reponse.totalNumberTickets;
					document.getElementById('hpd-total-closed-tickets').textContent = reponse.totalClosedTickets;
					document.getElementById('hdp-total-number-comments').textContent = reponse.totalNumberComments;
				},
				onError: function (error) {
					alert(error.statusText);
				}
			});
		});
	}

	document.addEventListener('DOMContentLoaded', function () {
		loadTicketsChart();
		updateDurationStatistic();
	});
})(document, Joomla);