(function (document, Joomla) {
	function insertAtCursor(myField, myValue) {
		//IE support
		if (document.selection) {
			myField.focus();
			sel = document.selection.createRange();
			sel.text = myValue;
		}
		//MOZILLA and others
		else if (myField.selectionStart || myField.selectionStart === 0) {
			var startPos = myField.selectionStart;
			var endPos = myField.selectionEnd;
			myField.value = myField.value.substring(0, startPos)
				+ myValue
				+ myField.value.substring(endPos, myField.value.length);
		} else {
			myField.value += myValue;
		}
	}

	document.addEventListener('DOMContentLoaded', () => {
		document.getElementById('ajaxAssign').addEventListener('click', function () {
			const replyId = document.getElementById('replies_id').value;
			Joomla.request({
				url: Joomla.getOptions('hdpRootUri') + '/index.php?option=com_helpdeskpro&task=get_reply&reply_id=' + replyId,
				method: 'GET',
				perform: true,
				onSuccess: response => {
					if (Joomla.getOptions('use_html_editor')) {
						Joomla.editors.instances['message'].replaceSelection(response);
					} else {
						const message = document.getElementById('message');

						if (message.tagName === 'TEXTAREA') {
							insertAtCursor(message, response);
						}
					}
				},
				onError: error => {
					alert(error.statusText);
				}
			});
		});
	});
})(document, Joomla);