<?php
/**
 * @package         Joomla.Plugin
 * @subpackage      Captcha.jdcaptcha
 * @author          Tuan Pham Ngoc
 *
 * @copyright       Copyright (C) 2024 JoomDonation Team
 * @license         GNU General Public License version 3, or later
 */

namespace Gregwar\Captcha;

\defined('_JEXEC') or die;

/**
 * A Captcha builder
 */
interface CaptchaBuilderInterface
{
    /**
     * Builds the code
     */
    public function build($width, $height, $font, $fingerprint);

    /**
     * Saves the code to a file
     */
    public function save($filename, $quality);

    /**
     * Gets the image contents
     */
    public function get($quality);

    /**
     * Outputs the image
     */
    public function output($quality);
}
