<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Plugin\HelpdeskPro\AssignTicket\Extension;

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Event\DispatcherInterface;
use Joomla\Event\Event;
use Joomla\Event\SubscriberInterface;
use OSSolution\HelpdeskPro\Site\Helper\Database as HelpdeskProHelperDatabase;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;

defined('_JEXEC') or die;

class AssignTicket extends CMSPlugin implements SubscriberInterface
{
	public function __construct(
		DispatcherInterface $dispatcher,
		array $config,
		CMSApplicationInterface $application
	) {
		parent::__construct($dispatcher, $config);

		$this->setApplication($application);
	}


	/**
	 * Returns an array of events this subscriber will listen to.
	 *
	 * @return array
	 *
	 */
	public static function getSubscribedEvents(): array
	{
		return [
			'onViewTicket' => 'onViewTicket',
		];
	}

	/**
	 * Display interface to allow assigning ticket to staffs
	 *
	 * @param   Event  $event
	 *
	 * @return void
	 */
	public function onViewTicket(Event $event): void
	{
		if (!$this->getApplication()->getIdentity()->authorise('helpdeskpro.assignticket', 'com_helpdeskpro'))
		{
			return;
		}

		[$row] = array_values($event->getArguments());

		$config   = HelpdeskProHelper::getConfig();
		$rowUsers = HelpdeskProHelperDatabase::getAllStaffs($config->staff_group_id);

		if (!count($rowUsers))
		{
			return;
		}

		ob_start();

		require PluginHelper::getLayoutPath('helpdeskpro', 'assignticket');

		$output = ob_get_clean();

		HelpdeskProHelper::addEventListenerResult($event, $output);
	}
}