<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;
use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskProHelperHtml;

/**
 * Layout variables
 *
 * @var stdClass $row
 * @var array    $rowReplies
 */

HTMLHelper::_('behavior.core');

$config = HelpdeskProHelper::getConfig();

/* @var \Joomla\CMS\Application\CMSApplication $app */
$app = $this->getApplication();

$app->getDocument()
	->addScriptOptions('ticket_id', $row->id)
	->addScriptOptions('use_html_editor', (bool) $config->use_html_editor)
	->getWebAssetManager()
	->registerAndUseScript('plug_helpdeskpro_prereply', 'media/com_helpdeskpro/js/plug_helpdeskpro_prereply.js', ['version' => HelpdeskProHelper::getInstalledVersion()]);

if ($app->isClient('site'))
{
	$bootstrapHelper = HelpdeskProHelperBootstrap::getInstance();
}
else
{
	$bootstrapHelper = HelpdeskProHelperBootstrap::getInstance();
}
?>
<tr>
	<th colspan="2" class="hdp-pre-defined-reply-heading <?php echo $bootstrapHelper->getClassMapping('btn-primary'); ?>">
		<?php echo Text::_('HDP_PRE_REPLIES'); ?>
	</th>
</tr>
<tr>
	<td colspan="2">
		<?php echo HelpdeskProHelperHtml::getChoicesJsSelect(HTMLHelper::_('select.genericlist', $rowReplies, 'replies_id', 'class="chosen form-select"', 'value', 'text', '')); ?>
		<input type="button" class="btn btn-primary" id="ajaxAssign" value="<?php echo Text::_('HDP_ADD_REPLY') ?>"/>
	</td>
</tr>