<?php
/**
 * 4LOGS
 *
 * @package          4LOGS
 * @copyright        Copyright Weeblr llc - 2021
 * @author           Yannick Gaultier - Weeblr llc
 * @license          GNU General Public License version 3; see LICENSE.md
 * @version          1.1.2.217
 * @date        2021-08-20
 */

use Joomla\CMS\Plugin;
use Joomla\CMS\Language\Text;
use Weeblr\Wblib\V_FORLOGS_217\Wb;
use Weeblr\Wblib\V_FORLOGS_217\Factory as wblFactory;
use Weeblr\Wblib\V_FORLOGS_217\System;
use Weeblr\Wblib\V_FORLOGS_217\Joomla\StringHelper\StringHelper;

// no direct access
defined('_JEXEC') || die();

/**
 * 4LOGS for Joomla system plugin.
 */
class plgSystemForlogs extends Plugin\CMSPlugin
{
	/**
	 * The Application object
	 *
	 * @var    JApplicationSite
	 * @since  3.9.0
	 */
	protected $app;

	/**
	 * Load the language file on instantiation.
	 *
	 * @var    boolean
	 * @since  3.9.0
	 */
	protected $autoloadLanguage = true;

	/**
	 * Mimic Base\Base and load up wbLib factory and platform objects.
	 * Hook is added as well as this plugin is essentially relaying
	 * Joomla events through wbLib hooks.
	 */
	private $factory  = null;
	private $platform = null;
	private $hook     = null;

	/**
	 * @var Instance of the 4LOGS app.
	 */
	private $forlogs = null;

	public function __construct($subject, array $config = array())
	{
		parent::__construct($subject, $config);

		// init app
		defined('WBLIB_EXEC') or define('WBLIB_EXEC', true);
		if (file_exists(__DIR__ . '/boot.php'))
		{
			include_once __DIR__ . '/boot.php';
		}
		else
		{
			return;
		}

		$this->factory  = wblFactory::get();
		$this->platform = $this->factory->getThe('platform');
		$this->hook     = $this->factory->getThe('hook');
	}

	/**
	 * Earliest event, create application.
	 */
	public function onAfterInitialise()
	{
		// something went wrong during init.
		if (!defined('FORLOGS_APP_PATH'))
		{
			return;
		}

		// setup some basic path and initialize the app.
		// This will also register the app API handler
		// which needs to be done as early as possible.
		$this->forlogs = $this->factory->getThis(
			'app',
			'forlogs',
			array(
				'id'        => 'forlogs',
				'namespace' => '\Weeblr\Forlogs',
				'rootpath'  => FORLOGS_APP_PATH
			)
		);

		/**
		 * Hook to run the registered onAfterInitialise handlers.
		 *
		 * @api     forlogs
		 * @package forlogs\action\events
		 * @var forlogs_onAfterInitialise
		 * @since   1.0.0
		 *
		 */
		$this->hook->run(
			'forlogs_onAfterInitialise'
		);
	}

	/**
	 * Hook into wbLib after initial parsing's been done by Joomla.
	 */
	public function onAfterRoute()
	{
		// something went wrong during init.
		if (!defined('FORLOGS_APP_PATH'))
		{
			return;
		}

		/**
		 * Hook to run the registered API handlers.
		 *
		 * @api     forlogs
		 * @package wbLib\action\api
		 * @var wblib_api_process_request
		 * @since   1.0.0
		 *
		 */
		$this->hook->run(
			'wblib_api_process_request'
		);
	}

	public function onPrivacyCollectAdminCapabilities()
	{
		// something went wrong during init.
		if (!defined('FORLOGS_APP_PATH'))
		{
			return;
		}

		/**
		 * Hook to run the registered onPrivacyCollectAdminCapabilities handlers.
		 *
		 * @api     forlogs
		 * @package forlogs\filter\events
		 * @var forlogs_onPrivacyCollectAdminCapabilities
		 * @since   1.0.0
		 *
		 */
		return $this->hook->filter(
			'forlogs_onPrivacyCollectAdminCapabilities',
			[
				'4LOGS' => [
					Text::_('PLG_SYSTEM_FORLOGS_PRIVACY_CAPABILITIES')
				]
			]
		);
	}
}
