<?php
/**
* ChronoForms 8
* Copyright (c) 2023 ChronoEngine.com, All rights reserved.
* Author: (ChronoEngine.com Team)
* license:     GNU General Public License version 2 or later; see LICENSE.txt
* Visit http://www.ChronoEngine.com for regular updates and information.
**/
defined('_JEXEC') or die('Restricted access');

$rows = ChronoModel::instance()->Select(sql: "SELECT * FROM INFORMATION_SCHEMA.TABLES where TABLE_SCHEMA = '" . ChronoApp::config()->get("db") . "' ORDER BY TABLE_NAME asc;");
// Chrono::pr($rows);
?>
<form class="nui form" action="<?php echo ChronoApp::$instance->current_url; ?>" method="post" accept-charset="UTF-8">
	<?php
	new MenuBar(title: "Database Tables", buttons: [
		new MenuButton(link: true, url: "action=ma.tables.new", title: "Create Table", color:"blue", icon:"plus"),
		new MenuButton(link: true, url: "action=ma.sql", title: "Run SQL", color:"slate", icon:"code"),
		new MenuButton(link: true, url: "action=settings", title: "Settings", color:"slate", icon:"gear"),
	]);

	new DataTable($rows, [
		new TableColumn(selector:true, name:"TABLE_NAME"),
		new TableColumn(name:"TABLE_NAME", title:"Table name", expand:true, func:function($row){
			return '<a href="'.ChronoApp::$instance->extension_url.'&action=ma.browse&table='.$row["TABLE_NAME"].'">'.$row["TABLE_NAME"].'</a>';
		}),
		new TableColumn(name:"functions", title:"", func:function($row){
			return '<a class="nui label blue rounded" href="'.ChronoApp::$instance->extension_url."&action=ma.structure&table=".$row["TABLE_NAME"].'">Structure</a>
			&nbsp;
			<a class="nui label grey rounded" href="'.ChronoApp::$instance->extension_url."&action=ma.search&table=".$row["TABLE_NAME"].'">Search</a>
			&nbsp;
			<a class="nui label red rounded" href="'.ChronoApp::$instance->extension_url."&action=ma.truncate&table=".$row["TABLE_NAME"].'">Truncate</a>
			&nbsp;
			<a class="nui label red inverted rounded" href="'.ChronoApp::$instance->extension_url."&action=ma.drop&table=".$row["TABLE_NAME"].'">Drop</a>';
		}),
		// new TableColumn(name:"published", title:Chrono::l("Published"), func:function($row){
		// 	if($row["published"] == "1"){
		// 		return '<a href="'.ChronoApp::$instance->extension_url.'&action=toggle&id='.$row["id"].'&field=published&value=0">'.Chrono::ShowIcon("check nui green").'</a>';
		// 	}else{
		// 		return '<a href="'.ChronoApp::$instance->extension_url.'&action=toggle&id='.$row["id"].'&field=published&value=1">'.Chrono::ShowIcon("xmark nui red").'</a>';
		// 	}
		// }),
		// new TableColumn(name:"view", title:"View Form", func:function($row){
		// 	return '<a href="'.ChronoApp::$instance->extension_url.'&action=view&id='.$row["id"].'">View</a>';
		// }),
		// new TableColumn(name:"log", title:"Data Log", func:function($row){
		// 	if(!empty($row["params"]["log_data"])){
		// 		return '<a href="'.ChronoApp::$instance->extension_url.'&action=datalog&form_id='.$row["id"].'">Data</a>';
		// 	}
		// }),
		new TableColumn(name:"TABLE_ROWS", title:"Rows"),
		new TableColumn(name:"ENGINE", title:"Engine"),
		new TableColumn(name:"TABLE_COLLATION", title:"Collation"),
		new TableColumn(name:"Size", title:"Size", func:function($row){
			return (((int)$row["DATA_LENGTH"] + (int)$row["INDEX_LENGTH"])/1024) ."KB";
		}),
	]);
	?>
</form>